/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;

public class XtendClassUtil {
    public static String create(String typeName, IPackageFragment packageFragment, String superClass, List superInterfaces, String indentation, String lineSeparator, IProgressMonitor monitor) throws CoreException {
        Iterator i;
        StringBuffer sb = new StringBuffer();
        if (packageFragment.getElementName() != null && !packageFragment.getElementName().equals("")) {
            sb.append("package ");
            sb.append(packageFragment.getElementName());
            sb.append(lineSeparator);
            sb.append(lineSeparator);
        }
        if (!superClass.equals("java.lang.Object")) {
            XtendClassUtil.addImport(sb, superClass, lineSeparator);
        }
        for (Object object : superInterfaces) {
            XtendClassUtil.addImport(sb, object, lineSeparator);
        }
        if (superInterfaces.size() > 0 || !superClass.equals("java.lang.Object")) {
            sb.append(lineSeparator);
        }
        sb.append("class ");
        sb.append(typeName);
        if (!superClass.equals("java.lang.Object")) {
            sb.append(" extends ");
            sb.append(XtendClassUtil.stripPackage(superClass));
        }
        if ((i = superInterfaces.iterator()).hasNext()) {
            sb.append(" implements ");
            sb.append(XtendClassUtil.stripPackage(i.next()));
            while (i.hasNext()) {
                sb.append(", ");
                sb.append(XtendClassUtil.stripPackage(i.next()));
            }
        }
        sb.append(" {");
        sb.append(lineSeparator);
        sb.append(indentation);
        sb.append(lineSeparator);
        sb.append("}");
        return sb.toString();
    }

    private static Object stripPackage(Object superType) {
        return superType.toString().replaceAll("^(\\w+\\.)*", "");
    }

    private static void addImport(StringBuffer sb, Object object, String lineSeparator) {
        sb.append("import ");
        sb.append(XtendClassUtil.removeGenerics(object));
        sb.append(lineSeparator);
    }

    private static String removeGenerics(Object object) {
        String ret = object.toString().replaceAll("<.*>$", "");
        return ret;
    }
}

