/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;

public class UnboundTypeParameter
extends AbstractReentrantTypeReferenceProvider {
    private final XExpression expression;
    private final JvmTypeParameter typeParameter;
    private final CommonTypeComputationServices services;
    private final List<JvmTypeReference> hints;
    private JvmTypeReference boundTo;
    private Set<UnboundTypeParameter> equallyBound;

    public UnboundTypeParameter(XExpression expression, JvmTypeParameter typeParameter, CommonTypeComputationServices services) {
        this.expression = expression;
        this.typeParameter = typeParameter;
        this.services = services;
        this.hints = Lists.newArrayList();
        this.equallyBound = Sets.newHashSetWithExpectedSize((int)2);
    }

    protected JvmTypeReference doGetTypeReference() {
        JvmTypeReference substitute;
        if (this.boundTo != null) {
            return this.boundTo;
        }
        if (!this.hints.isEmpty() || !this.equallyBound.isEmpty()) {
            JvmTypeReference superType;
            ArrayList allHints = Lists.newArrayList(this.hints);
            for (UnboundTypeParameter similar : this.equallyBound) {
                allHints.addAll(similar.hints);
            }
            if (!allHints.isEmpty() && (superType = this.services.getTypeConformanceComputer().getCommonSuperType((List)allHints)) != null) {
                this.boundTo = superType;
                return superType;
            }
        }
        TypeParameterByConstraintSubstitutor unboundSubstitutor = new TypeParameterByConstraintSubstitutor(Collections.<JvmTypeParameter, JvmTypeReference>emptyMap(), this.services);
        this.boundTo = substitute = unboundSubstitutor.substitute((JvmTypeReference)this.services.getTypeReferences().createTypeRef((JvmType)this.typeParameter, new JvmTypeReference[0]));
        return substitute;
    }

    public void acceptHint(JvmTypeReference hint) {
        IJvmTypeReferenceProvider typeProvider;
        if (hint instanceof XComputedTypeReference && (typeProvider = ((XComputedTypeReference)hint).getTypeProvider()) instanceof UnboundTypeParameter) {
            UnboundTypeParameter other = (UnboundTypeParameter)typeProvider;
            this.equallyBound.add(other);
            other.equallyBound.add(this);
            return;
        }
        this.hints.add(hint);
    }

    public XExpression getExpression() {
        return this.expression;
    }

    public JvmTypeParameter getTypeParameter() {
        return this.typeParameter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.typeParameter == null ? 0 : this.typeParameter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnboundTypeParameter other = (UnboundTypeParameter)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.typeParameter == null ? other.typeParameter != null : !this.typeParameter.equals(other.typeParameter));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UnboundTypeParameter [typeParameter=");
        builder.append(this.typeParameter);
        builder.append("]");
        return builder.toString();
    }
}

