/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.ecore2xtext;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.EPackageInfo;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPackageChooser {
    private static final String PATH_TO_ECORE_ECORE = "org.eclipse.emf.ecore/model/Ecore.ecore";
    private final Shell shell;
    private final IJdtHelper jdtHelper;

    public EPackageChooser(Shell shell, IJdtHelper jdtHelper) {
        this.shell = shell;
        this.jdtHelper = jdtHelper;
    }

    protected List<EPackageInfo> createEPackageInfosFromGenModel(URI genModelURI) {
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.getResource(genModelURI, true);
        ArrayList ePackageInfos = Lists.newArrayList();
        TreeIterator i = resource.getAllContents();
        while (i.hasNext()) {
            EObject next = (EObject)i.next();
            if (next instanceof GenPackage) {
                GenPackage genPackage = (GenPackage)next;
                EPackage ePackage = genPackage.getEcorePackage();
                URI importURI = ePackage.eResource() == null ? URI.createURI((String)ePackage.getNsURI()) : ePackage.eResource().getURI();
                EPackageInfo ePackageInfo = new EPackageInfo(ePackage, importURI, genModelURI, genPackage.getQualifiedPackageInterfaceName(), genPackage.getGenModel().getModelPluginID());
                ePackageInfos.add(ePackageInfo);
                continue;
            }
            if (next instanceof GenModel) continue;
            i.prune();
        }
        return ePackageInfos;
    }

    private ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource ecorePackageResource = EcorePackage.eINSTANCE.eResource();
        HashMap uriResourceMap = Maps.newHashMap();
        uriResourceMap.put(URI.createPlatformResourceURI((String)PATH_TO_ECORE_ECORE, (boolean)true), ecorePackageResource);
        uriResourceMap.put(URI.createPlatformPluginURI((String)PATH_TO_ECORE_ECORE, (boolean)true), ecorePackageResource);
        resourceSet.setURIResourceMap((Map)uriResourceMap);
        return resourceSet;
    }

    public List<EPackageInfo> open() {
        Iterable<IResource> resourcesContainingGenModels = this.findResourcesContainingGenModels();
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.shell, resourcesContainingGenModels, (IStructuredContentProvider)new ContentProvider(), (ILabelProvider)new LabelProvider(), Messages.EPackageChooser_ChooseGenModel);
        int result = listSelectionDialog.open();
        if (result == 0) {
            ArrayList ePackageInfos = Lists.newArrayList();
            Object[] objectArray = listSelectionDialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selection = objectArray[n2];
                if (selection instanceof IFile) {
                    IFile file = (IFile)selection;
                    URI genModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                    ePackageInfos.addAll(this.createEPackageInfosFromGenModel(genModelURI));
                }
                ++n2;
            }
            return ePackageInfos;
        }
        return Collections.emptyList();
    }

    protected Iterable<IResource> findResourcesContainingGenModels() {
        final ArrayList filteredResources = Lists.newArrayList();
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && "genmodel".equals(((IFile)resource).getFileExtension())) {
                        filteredResources.add(resource);
                    }
                    if (EPackageChooser.this.jdtHelper.isJavaCoreAvailable()) {
                        return !EPackageChooser.this.jdtHelper.isFromOutputPath(resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Logger.getLogger(this.getClass()).error((Object)Messages.EPackageChooser_ErrorFindingGenModels, (Throwable)e);
        }
        return filteredResources;
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private Iterable<Object> content;

        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.content != null) {
                return Iterables.toArray(this.content, Object.class);
            }
            return new Object[0];
        }

        public void dispose() {
            this.content = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Iterable) {
                this.content = (Iterable)newInput;
            }
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private ILabelProvider delegate = new WorkbenchLabelProvider();

        private LabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                return String.valueOf(this.delegate.getText((Object)file)) + " - " + file.getParent().getFullPath();
            }
            return this.delegate.getText(object);
        }

        public Image getImage(Object element) {
            return this.delegate.getImage(element);
        }
    }
}

