/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.util.ToStringContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class ToStringBuilder {
    @Extension
    private static ToStringContext _toStringContext = ToStringContext.INSTANCE;
    private final Object instance;
    private final String typeName;
    private boolean multiLine = true;
    private boolean skipNulls = false;
    private boolean showFieldNames = true;
    private final ArrayList<Part> parts = CollectionLiterals.newArrayList(new Part[0]);

    public ToStringBuilder(Object instance) {
        String _simpleName;
        this.instance = instance;
        Class<?> _class = instance.getClass();
        this.typeName = _simpleName = _class.getSimpleName();
    }

    public ToStringBuilder singleLine() {
        this.multiLine = false;
        return this;
    }

    public ToStringBuilder skipNulls() {
        this.skipNulls = true;
        return this;
    }

    public ToStringBuilder hideFieldNames() {
        this.showFieldNames = false;
        return this;
    }

    @GwtIncompatible(value="Class.getDeclaredFields")
    public ToStringBuilder addDeclaredFields() {
        Class<?> _class = this.instance.getClass();
        Field[] _declaredFields = _class.getDeclaredFields();
        Procedures.Procedure1<Field> _function = new Procedures.Procedure1<Field>(){

            @Override
            public void apply(Field it) {
                ToStringBuilder.this.addField(it);
            }
        };
        IterableExtensions.forEach((Iterable)Conversions.doWrapArray(_declaredFields), _function);
        return this;
    }

    @GwtIncompatible(value="Class.getDeclaredFields")
    public ToStringBuilder addAllFields() {
        Class<?> _class = this.instance.getClass();
        ArrayList<Field> _allDeclaredFields = this.getAllDeclaredFields(_class);
        Procedures.Procedure1<Field> _function = new Procedures.Procedure1<Field>(){

            @Override
            public void apply(Field it) {
                ToStringBuilder.this.addField(it);
            }
        };
        IterableExtensions.forEach(_allDeclaredFields, _function);
        return this;
    }

    @GwtIncompatible(value="Class.getDeclaredField(String)")
    public ToStringBuilder addField(final String fieldName) {
        Class<?> _class = this.instance.getClass();
        ArrayList<Field> _allDeclaredFields = this.getAllDeclaredFields(_class);
        Functions.Function1<Field, Boolean> _function = new Functions.Function1<Field, Boolean>(){

            @Override
            public Boolean apply(Field it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)fieldName);
            }
        };
        Field _findFirst = IterableExtensions.findFirst(_allDeclaredFields, _function);
        return this.addField(_findFirst);
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    private ToStringBuilder addField(Field field) {
        try {
            boolean _not;
            ToStringBuilder _xifexpression = null;
            int _modifiers = field.getModifiers();
            boolean _isStatic = Modifier.isStatic(_modifiers);
            boolean bl = _not = !_isStatic;
            if (_not) {
                ToStringBuilder _xblockexpression = null;
                field.setAccessible(true);
                String _name = field.getName();
                Object _get = field.get(this.instance);
                _xifexpression = _xblockexpression = this.add(_name, _get);
            }
            return _xifexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    public ToStringBuilder add(String fieldName, Object value) {
        return this.addPart(fieldName, value);
    }

    public ToStringBuilder add(Object value) {
        return this.addPart(value);
    }

    private Part addPart() {
        Part p = new Part();
        this.parts.add(p);
        return p;
    }

    private ToStringBuilder addPart(Object value) {
        Part p = this.addPart();
        p.value = value;
        return this;
    }

    private ToStringBuilder addPart(String fieldName, Object value) {
        Part p = this.addPart();
        p.fieldName = fieldName;
        p.value = value;
        return this;
    }

    public String toString() {
        boolean _not;
        boolean _startProcessing = _toStringContext.startProcessing(this.instance);
        boolean bl = _not = !_startProcessing;
        if (_not) {
            return this.toSimpleReferenceString(this.instance);
        }
        try {
            IndentationAwareStringBuilder builder = new IndentationAwareStringBuilder();
            IndentationAwareStringBuilder _append = builder.append(this.typeName);
            _append.append(" ");
            builder.append("[");
            String nextSeparator = "";
            if (this.multiLine) {
                builder.increaseIndent();
            }
            for (Part part : this.parts) {
                boolean _tripleNotEquals;
                boolean _or = false;
                _or = !this.skipNulls ? true : (_tripleNotEquals = part.value != null);
                if (!_or) continue;
                if (this.multiLine) {
                    builder.newLine();
                } else {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                }
                boolean _and = false;
                boolean _tripleNotEquals_1 = part.fieldName != null;
                _and = !_tripleNotEquals_1 ? false : this.showFieldNames;
                if (_and) {
                    IndentationAwareStringBuilder _append_1 = builder.append(part.fieldName);
                    _append_1.append(" = ");
                }
                this.internalToString(part.value, builder);
            }
            if (this.multiLine) {
                IndentationAwareStringBuilder _decreaseIndent = builder.decreaseIndent();
                _decreaseIndent.newLine();
            }
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            _toStringContext.endProcessing(this.instance);
        }
    }

    private void internalToString(Object object, IndentationAwareStringBuilder sb) {
        boolean _equals = Objects.equal((Object)object, null);
        if (_equals) {
            sb.append("null");
        } else if (object instanceof Iterable) {
            this.serializeIterable((Iterable)object, sb);
        } else if (object instanceof Object[]) {
            String _string = Arrays.toString((Object[])object);
            sb.append(_string);
        } else if (object instanceof byte[]) {
            String _string_1 = Arrays.toString((byte[])object);
            sb.append(_string_1);
        } else if (object instanceof char[]) {
            String _string_2 = Arrays.toString((char[])object);
            sb.append(_string_2);
        } else if (object instanceof int[]) {
            String _string_3 = Arrays.toString((int[])object);
            sb.append(_string_3);
        } else if (object instanceof boolean[]) {
            String _string_4 = Arrays.toString((boolean[])object);
            sb.append(_string_4);
        } else if (object instanceof long[]) {
            String _string_5 = Arrays.toString((long[])object);
            sb.append(_string_5);
        } else if (object instanceof float[]) {
            String _string_6 = Arrays.toString((float[])object);
            sb.append(_string_6);
        } else if (object instanceof double[]) {
            String _string_7 = Arrays.toString((double[])object);
            sb.append(_string_7);
        } else if (object instanceof CharSequence) {
            IndentationAwareStringBuilder _append = sb.append("\"");
            String _string_8 = ((CharSequence)object).toString();
            String _replace = _string_8.replace("\n", "\\n");
            String _replace_1 = _replace.replace("\r", "\\r");
            IndentationAwareStringBuilder _append_1 = _append.append(_replace_1);
            _append_1.append("\"");
        } else if (object instanceof Enum) {
            String _name = ((Enum)object).name();
            sb.append(_name);
        } else {
            String _string_9 = object.toString();
            sb.append(_string_9);
        }
    }

    private void serializeIterable(Iterable<?> object, IndentationAwareStringBuilder sb) {
        Iterator<?> iterator = object.iterator();
        Class<?> _class = object.getClass();
        String _simpleName = _class.getSimpleName();
        IndentationAwareStringBuilder _append = sb.append(_simpleName);
        _append.append(" (");
        if (this.multiLine) {
            sb.increaseIndent();
        }
        boolean wasEmpty = true;
        while (iterator.hasNext()) {
            wasEmpty = false;
            if (this.multiLine) {
                sb.newLine();
            }
            Object _next = iterator.next();
            this.internalToString(_next, sb);
            boolean _hasNext = iterator.hasNext();
            if (!_hasNext) continue;
            sb.append(",");
        }
        if (this.multiLine) {
            sb.decreaseIndent();
        }
        boolean _and = false;
        _and = wasEmpty ? false : this.multiLine;
        if (_and) {
            sb.newLine();
        }
        sb.append(")");
    }

    private String toSimpleReferenceString(Object obj) {
        Class<?> _class = obj.getClass();
        String _simpleName = _class.getSimpleName();
        String _plus = String.valueOf(_simpleName) + "@";
        int _identityHashCode = System.identityHashCode(obj);
        return String.valueOf(_plus) + Integer.valueOf(_identityHashCode);
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    private ArrayList<Field> getAllDeclaredFields(Class<?> clazz) {
        Class<?> _superclass;
        Class<?> current = clazz;
        ArrayList<Field> result = CollectionLiterals.newArrayList(new Field[0]);
        do {
            Field[] _declaredFields = current.getDeclaredFields();
            Iterables.addAll(result, (Iterable)((Iterable)Conversions.doWrapArray(_declaredFields)));
        } while (!Objects.equal(current = (_superclass = current.getSuperclass()), null));
        return result;
    }

    private static class IndentationAwareStringBuilder {
        private final StringBuilder builder = new StringBuilder();
        private final String indentationString = "  ";
        private final String newLineString = "\n";
        private int indentation = 0;

        private IndentationAwareStringBuilder() {
        }

        public IndentationAwareStringBuilder increaseIndent() {
            ++this.indentation;
            return this;
        }

        public IndentationAwareStringBuilder decreaseIndent() {
            --this.indentation;
            return this;
        }

        public IndentationAwareStringBuilder append(CharSequence string) {
            if (this.indentation > 0) {
                String _repeat = Strings.repeat((String)"  ", (int)this.indentation);
                String replacement = String.valueOf("\n") + _repeat;
                String _string = string.toString();
                String indented = _string.replace("\n", replacement);
                this.builder.append(indented);
            } else {
                this.builder.append(string);
            }
            return this;
        }

        public IndentationAwareStringBuilder newLine() {
            StringBuilder _append = this.builder.append("\n");
            String _repeat = Strings.repeat((String)"  ", (int)this.indentation);
            _append.append(_repeat);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    private static final class Part {
        private String fieldName;
        private Object value;

        private Part() {
        }
    }
}

