/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.navigation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.xtext.ui.TypeAwareHyperlinkHelper;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.AbstractHyperlink;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

public class XbaseHyperLinkHelper
extends TypeAwareHyperlinkHelper {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private StaticallyImportedMemberProvider staticImpMemberProvider;

    public IHyperlink[] createHyperlinksByOffset(XtextResource resource, int offset, boolean createMultipleHyperlinks) {
        if (!createMultipleHyperlinks) {
            return super.createHyperlinksByOffset(resource, offset, createMultipleHyperlinks);
        }
        ArrayList links = Lists.newArrayList();
        HyperlinkHelper.HyperlinkAcceptor acceptor = new HyperlinkHelper.HyperlinkAcceptor((List)links);
        INode crossRefNode = this.getEObjectAtOffsetHelper().getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (crossRefNode == null) {
            this.createHyperlinksByOffset(resource, offset, (IHyperlinkAcceptor)acceptor);
        } else {
            this.createHyperlinksForCrossRef(resource, crossRefNode, (IHyperlinkAcceptor)acceptor);
        }
        if (!links.isEmpty()) {
            return (IHyperlink[])Iterables.toArray((Iterable)links, IHyperlink.class);
        }
        return null;
    }

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        ITextRegion textRegion;
        XImportDeclaration importDeclaration;
        EObject element = this.getEObjectAtOffsetHelper().resolveElementAt(resource, offset);
        if (element instanceof XImportDeclaration && (importDeclaration = (XImportDeclaration)element).isStatic() && !importDeclaration.isWildcard() && (textRegion = this.getTextRegion(importDeclaration, offset)) != null) {
            Region region = new Region(textRegion.getOffset(), textRegion.getLength());
            Iterable _allFeatures = this.staticImpMemberProvider.getAllFeatures(importDeclaration);
            for (JvmFeature feature : _allFeatures) {
                this.createHyperlinksTo(resource, region, (EObject)feature, acceptor);
            }
        }
        super.createHyperlinksByOffset(resource, offset, acceptor);
    }

    protected void createHyperlinksForCrossRef(XtextResource resource, INode crossRefNode, final IHyperlinkAcceptor acceptor) {
        EObject containedElementAt = this.getEObjectAtOffsetHelper().resolveContainedElementAt(resource, crossRefNode.getOffset());
        if (containedElementAt instanceof XAbstractFeatureCall) {
            IResolvedTypes resolveTypes = this.typeResolver.resolveTypes((Resource)resource);
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)containedElementAt;
            final JvmIdentifiableElement targetElement = featureCall.getFeature();
            if (targetElement instanceof JvmType || featureCall.getFeature() instanceof JvmEnumerationLiteral) {
                return;
            }
            LightweightTypeReference typeReference = resolveTypes.getActualType((XExpression)featureCall);
            if (typeReference == null || typeReference.isPrimitive() || typeReference.isPrimitiveVoid()) {
                return;
            }
            final JvmType type = typeReference.getType();
            this.createHyperlinksTo(resource, crossRefNode, (EObject)type, new IHyperlinkAcceptor(){

                public void accept(IHyperlink hyperlink) {
                    if (hyperlink instanceof AbstractHyperlink) {
                        String target = this.labelForTargetElement(targetElement);
                        ((AbstractHyperlink)hyperlink).setHyperlinkText("Open " + target + " Type - " + type.getSimpleName());
                    }
                    acceptor.accept(hyperlink);
                }

                private String labelForTargetElement(JvmIdentifiableElement targetElement2) {
                    String target = "Return";
                    if (targetElement2 instanceof JvmField) {
                        target = "Field";
                    } else if (targetElement2 instanceof JvmFormalParameter) {
                        target = "Parameter";
                    } else if (targetElement2 instanceof XVariableDeclaration) {
                        target = "Variable";
                    }
                    return target;
                }
            });
        }
    }

    protected void createHyperlinksTo(XtextResource resource, INode node, EObject target, IHyperlinkAcceptor acceptor) {
        EObject semanticObj = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        if (semanticObj instanceof XImportDeclaration) {
            if (((XImportDeclaration)semanticObj).isStatic()) {
                ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion(semanticObj, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, 0);
                int _offset = textRegion.getOffset();
                int _length = textRegion.getLength();
                Region region = new Region(_offset, _length);
                this.createHyperlinksTo(resource, region, target, acceptor);
            }
        } else if (semanticObj instanceof XAbstractFeatureCall && target instanceof JvmType) {
            XAbstractFeatureCall casted = (XAbstractFeatureCall)semanticObj;
            while (casted.isPackageFragment()) {
                casted = (XAbstractFeatureCall)casted.eContainer();
            }
            if (casted.isTypeLiteral()) {
                ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion((EObject)casted);
                Region jfaceRegion = new Region(textRegion.getOffset(), textRegion.getLength());
                this.createHyperlinksTo(resource, jfaceRegion, target, acceptor);
                return;
            }
        }
        super.createHyperlinksTo(resource, node, target, acceptor);
    }

    private ITextRegion getTextRegion(XImportDeclaration it, int offset) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)it, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__MEMBER_NAME);
        for (INode node : nodes) {
            ITextRegion textRegion = node.getTextRegion();
            if (!textRegion.contains(offset)) continue;
            return textRegion;
        }
        return null;
    }

    public IBatchTypeResolver getBatchTypeResolver() {
        return this.typeResolver;
    }
}

