/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.iwork.AutoPageNumberUtils;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PagesContentHandler
extends DefaultHandler {
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private DocumentPart inPart = null;
    private boolean ghostText;
    private static String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private boolean parseProperty = false;
    private int pageCount = 0;
    private int slPageCount = 0;
    private HeaderFooter headers = null;
    private HeaderFooter footers = null;
    private Footnotes footnotes = null;
    private Annotations annotations = null;
    private Map<String, List<List<String>>> tableData = new HashMap<String, List<List<String>>>();
    private String activeTableId;
    private int numberOfColumns = 0;
    private List<String> activeRow = new ArrayList<String>();
    private String metaDataLocalName;
    private String metaDataQName;

    PagesContentHandler(XHTMLContentHandler xhtml, Metadata metadata) {
        this.xhtml = xhtml;
        this.metadata = metadata;
    }

    public void endDocument() throws SAXException {
        this.metadata.set(Metadata.PAGE_COUNT, String.valueOf(this.pageCount));
        if (this.pageCount > 0) {
            this.doFooter();
            this.xhtml.endElement("div");
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String value;
        if (this.parseProperty && (value = this.parsePrimitiveElementValue(qName, attributes)) != null) {
            Object metaDataKey = this.resolveMetaDataKey(this.metaDataLocalName);
            if (metaDataKey instanceof Property) {
                this.metadata.set((Property)metaDataKey, value);
            } else {
                this.metadata.add((String)metaDataKey, value);
            }
        }
        if ("sl:publication-info".equals(qName)) {
            this.inPart = DocumentPart.METADATA;
        } else if ("sf:metadata".equals(qName)) {
            this.inPart = DocumentPart.METADATA;
        } else if ("sf:page-start".equals(qName) || "sl:page-group".equals(qName)) {
            if (this.pageCount > 0) {
                this.doFooter();
                this.xhtml.endElement("div");
            }
            this.xhtml.startElement("div");
            if ("sl:page-group".equals(qName)) {
                ++this.slPageCount;
            } else {
                ++this.pageCount;
            }
            this.doHeader();
        } else if ("sf:p".equals(qName)) {
            if (this.pageCount + this.slPageCount > 0) {
                this.inPart = DocumentPart.PARSABLE_TEXT;
                this.xhtml.startElement("p");
            }
        } else if ("sf:attachment".equals(qName)) {
            String kind = attributes.getValue("sf:kind");
            if ("tabular-attachment".equals(kind)) {
                this.activeTableId = attributes.getValue("sfa:ID");
                this.tableData.put(this.activeTableId, new ArrayList());
            }
        } else if ("sf:attachment-ref".equals(qName)) {
            String idRef = attributes.getValue("sfa:IDREF");
            this.outputTable(idRef);
        } else if ("sf:headers".equals(qName)) {
            this.headers = new HeaderFooter(qName);
            this.inPart = DocumentPart.HEADERS;
        } else if ("sf:footers".equals(qName)) {
            this.footers = new HeaderFooter(qName);
            this.inPart = DocumentPart.FOOTERS;
        } else if ("sf:header".equals(qName)) {
            this.inPart = this.headers.identifyPart(attributes.getValue("sf:name"));
        } else if ("sf:footer".equals(qName)) {
            this.inPart = this.footers.identifyPart(attributes.getValue("sf:name"));
        } else if ("sf:page-number".equals(qName)) {
            if (this.inPart == DocumentPart.FOOTER_ODD || this.inPart == DocumentPart.FOOTER_FIRST || this.inPart == DocumentPart.FOOTER_EVEN) {
                this.footers.hasAutoPageNumber = true;
                this.footers.autoPageNumberFormat = attributes.getValue("sf:format");
            } else {
                this.headers.hasAutoPageNumber = true;
                this.headers.autoPageNumberFormat = attributes.getValue("sf:format");
            }
            this.xhtml.characters(Integer.toString(this.pageCount));
        } else if ("sf:footnotes".equals(qName)) {
            this.footnotes = new Footnotes();
            this.inPart = DocumentPart.FOOTNOTES;
        } else if ("sf:footnote-mark".equals(qName)) {
            this.footnotes.recordMark(attributes.getValue("sf:mark"));
        } else if ("sf:footnote".equals(qName) && this.inPart == DocumentPart.PARSABLE_TEXT) {
            String footnoteText;
            String footnoteMark = attributes.getValue("sf:autonumber");
            if (this.footnotes != null && (footnoteText = this.footnotes.footnotes.get(footnoteMark)) != null) {
                this.xhtml.startElement("div", "style", "footnote");
                this.xhtml.characters("Footnote:");
                this.xhtml.characters(footnoteText);
                this.xhtml.endElement("div");
            }
        } else if ("sf:annotations".equals(qName)) {
            this.annotations = new Annotations();
            this.inPart = DocumentPart.ANNOTATIONS;
        } else if ("sf:annotation".equals(qName) && this.inPart == DocumentPart.ANNOTATIONS) {
            this.annotations.start(attributes.getValue("sf:target"));
        } else if ("sf:annotation-field".equals(qName) && this.inPart == DocumentPart.PARSABLE_TEXT) {
            this.xhtml.startElement("div", "style", "annotated");
            String annotationText = this.annotations.annotations.get(attributes.getValue("sfa:ID"));
            if (annotationText != null) {
                this.xhtml.startElement("div", "style", "annotation");
                this.xhtml.characters(annotationText);
                this.xhtml.endElement("div");
            }
        } else if ("sf:ghost-text".equals(qName)) {
            this.ghostText = true;
        }
        if (this.activeTableId != null) {
            this.parseTableData(qName, attributes);
        }
        if (this.inPart == DocumentPart.METADATA) {
            this.metaDataLocalName = localName;
            this.metaDataQName = qName;
            this.parseProperty = true;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.metaDataLocalName != null && this.metaDataLocalName.equals(localName)) {
            this.metaDataLocalName = null;
            this.parseProperty = false;
        }
        if ("sl:publication-info".equals(qName)) {
            this.inPart = null;
        } else if ("sf:metadata".equals(qName)) {
            this.inPart = null;
        } else if ("sf:p".equals(qName) && this.pageCount + this.slPageCount > 0) {
            this.inPart = null;
            this.xhtml.endElement("p");
        } else if ("sf:attachment".equals(qName)) {
            this.activeTableId = null;
        } else if ("sf:annotation".equals(qName) && this.inPart == DocumentPart.ANNOTATIONS) {
            this.annotations.end();
        } else if ("sf:annotation-field".equals(qName) && this.inPart == DocumentPart.PARSABLE_TEXT) {
            this.xhtml.endElement("div");
        } else if ("sf:ghost-text".equals(qName)) {
            this.ghostText = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            if (this.inPart == DocumentPart.PARSABLE_TEXT) {
                if (!this.ghostText) {
                    this.xhtml.characters(ch, start, length);
                }
            } else if (this.inPart != null) {
                String str = new String(ch, start, length);
                if (this.inPart == DocumentPart.HEADER_FIRST) {
                    this.headers.defaultFirst = str;
                }
                if (this.inPart == DocumentPart.HEADER_EVEN) {
                    this.headers.defaultEven = str;
                }
                if (this.inPart == DocumentPart.HEADER_ODD) {
                    this.headers.defaultOdd = str;
                }
                if (this.inPart == DocumentPart.FOOTER_FIRST) {
                    this.footers.defaultFirst = str;
                }
                if (this.inPart == DocumentPart.FOOTER_EVEN) {
                    this.footers.defaultEven = str;
                }
                if (this.inPart == DocumentPart.FOOTER_ODD) {
                    this.footers.defaultOdd = str;
                }
                if (this.inPart == DocumentPart.FOOTNOTES) {
                    this.footnotes.text(str);
                }
                if (this.inPart == DocumentPart.ANNOTATIONS) {
                    this.annotations.text(str);
                }
            }
        }
    }

    private void parseTableData(String qName, Attributes attributes) {
        if ("sf:grid".equals(qName)) {
            String numberOfColumns = attributes.getValue("sf:numcols");
            this.numberOfColumns = Integer.parseInt(numberOfColumns);
        } else if ("sf:ct".equals(qName)) {
            this.activeRow.add(attributes.getValue("sfa:s"));
            if (this.activeRow.size() >= 3) {
                this.tableData.get(this.activeTableId).add(this.activeRow);
                this.activeRow = new ArrayList<String>();
            }
        }
    }

    private void outputTable(String idRef) throws SAXException {
        List<List<String>> tableData = this.tableData.get(idRef);
        if (tableData != null) {
            this.xhtml.startElement("table");
            for (List<String> row : tableData) {
                this.xhtml.startElement("tr");
                for (String cell : row) {
                    this.xhtml.element("td", cell);
                }
                this.xhtml.endElement("tr");
            }
            this.xhtml.endElement("table");
        }
    }

    private Object resolveMetaDataKey(String metaDataLocalName) {
        String metaDataKey = metaDataLocalName;
        if ("sf:authors".equals(this.metaDataQName)) {
            metaDataKey = TikaCoreProperties.CREATOR;
        } else if ("sf:title".equals(this.metaDataQName)) {
            metaDataKey = TikaCoreProperties.TITLE;
        } else if ("sl:SLCreationDateProperty".equals(this.metaDataQName)) {
            metaDataKey = TikaCoreProperties.CREATED;
        } else if ("sl:SLLastModifiedDateProperty".equals(this.metaDataQName)) {
            metaDataKey = Metadata.LAST_MODIFIED;
        } else if ("sl:language".equals(this.metaDataQName)) {
            metaDataKey = TikaCoreProperties.LANGUAGE;
        }
        return metaDataKey;
    }

    private String parsePrimitiveElementValue(String qName, Attributes attributes) {
        if ("sl:string".equals(qName) || "sf:string".equals(qName)) {
            return attributes.getValue("sfa:string");
        }
        if ("sl:number".equals(qName)) {
            return attributes.getValue("sfa:number");
        }
        if ("sl:date".equals(qName)) {
            return attributes.getValue("sf:val");
        }
        return null;
    }

    private void doHeader() throws SAXException {
        if (this.headers != null) {
            this.headers.output("header");
        }
    }

    private void doFooter() throws SAXException {
        if (this.footers != null) {
            this.footers.output("footer");
        }
    }

    private class Annotations {
        Map<String, String> annotations = new HashMap<String, String>();
        String currentID = null;
        StringBuffer currentText = null;

        private Annotations() {
        }

        private void start(String id) {
            this.currentID = id;
            this.currentText = new StringBuffer();
        }

        private void text(String text) {
            if (text != null && text.length() > 0 && this.currentText != null) {
                this.currentText.append(text);
            }
        }

        private void end() {
            if (this.currentText.length() > 0) {
                this.annotations.put(this.currentID, this.currentText.toString());
                this.currentID = null;
                this.currentText = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DocumentPart {
        METADATA,
        PARSABLE_TEXT,
        HEADERS,
        HEADER_ODD,
        HEADER_EVEN,
        HEADER_FIRST,
        FOOTERS,
        FOOTER_ODD,
        FOOTER_EVEN,
        FOOTER_FIRST,
        FOOTNOTES,
        ANNOTATIONS;

    }

    private static class Footnotes {
        Map<String, String> footnotes = new HashMap<String, String>();
        String lastSeenMark = null;

        private Footnotes() {
        }

        private void recordMark(String mark) {
            this.lastSeenMark = mark;
        }

        private void text(String text) {
            if (this.lastSeenMark != null) {
                if (this.footnotes.containsKey(this.lastSeenMark)) {
                    text = this.footnotes.get(this.lastSeenMark) + text;
                }
                this.footnotes.put(this.lastSeenMark, text);
            }
        }
    }

    private class HeaderFooter {
        private String type;
        private String defaultOdd;
        private String defaultEven;
        private String defaultFirst;
        private boolean hasAutoPageNumber;
        private String autoPageNumberFormat;

        private HeaderFooter(String type) {
            this.type = type;
        }

        private DocumentPart identifyPart(String name) {
            if ("SFWPDefaultOddHeaderIdentifier".equals(name)) {
                return DocumentPart.HEADER_ODD;
            }
            if ("SFWPDefaultEvenHeaderIdentifier".equals(name)) {
                return DocumentPart.HEADER_EVEN;
            }
            if ("SFWPDefaultFirstHeaderIdentifier".equals(name)) {
                return DocumentPart.HEADER_FIRST;
            }
            if ("SFWPDefaultOddFooterIdentifier".equals(name)) {
                return DocumentPart.FOOTER_ODD;
            }
            if ("SFWPDefaultEvenFooterIdentifier".equals(name)) {
                return DocumentPart.FOOTER_EVEN;
            }
            if ("SFWPDefaultFirstFooterIdentifier".equals(name)) {
                return DocumentPart.FOOTER_FIRST;
            }
            return null;
        }

        private void output(String what) throws SAXException {
            String text = null;
            text = PagesContentHandler.this.pageCount == 1 && this.defaultFirst != null ? this.defaultFirst : (PagesContentHandler.this.pageCount % 2 == 0 && this.defaultEven != null ? this.defaultEven : this.defaultOdd);
            if (text != null) {
                PagesContentHandler.this.xhtml.startElement("div", "class", "header");
                PagesContentHandler.this.xhtml.characters(text);
                if (this.hasAutoPageNumber) {
                    if (this.autoPageNumberFormat == null) {
                        PagesContentHandler.this.xhtml.characters("\t" + PagesContentHandler.this.pageCount);
                    } else if (this.autoPageNumberFormat.equals("upper-roman")) {
                        PagesContentHandler.this.xhtml.characters("\t" + AutoPageNumberUtils.asRomanNumerals(PagesContentHandler.this.pageCount));
                    } else if (this.autoPageNumberFormat.equals("lower-roman")) {
                        PagesContentHandler.this.xhtml.characters("\t" + AutoPageNumberUtils.asRomanNumeralsLower(PagesContentHandler.this.pageCount));
                    } else if (this.autoPageNumberFormat.equals("upper-alpha")) {
                        PagesContentHandler.this.xhtml.characters("\t" + AutoPageNumberUtils.asAlphaNumeric(PagesContentHandler.this.pageCount));
                    } else if (this.autoPageNumberFormat.equals("lower-alpha")) {
                        PagesContentHandler.this.xhtml.characters("\t" + AutoPageNumberUtils.asAlphaNumericLower(PagesContentHandler.this.pageCount));
                    }
                }
                PagesContentHandler.this.xhtml.endElement("div");
            }
        }
    }
}

