/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.prt;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PRTParser
extends AbstractParser {
    private static final long serialVersionUID = 4659638314375035178L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-prt"));
    public static final String PRT_MIME_TYPE = "application/x-prt";
    private static final int MAX_SANE_TEXT_LENGTH = 2048;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        int read;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        Last5 l5 = new Last5();
        byte[] header = new byte[30];
        IOUtils.readFully((InputStream)stream, (byte[])header);
        byte[] date = new byte[12];
        IOUtils.readFully((InputStream)stream, (byte[])date);
        String dateStr = new String(date, "ASCII");
        if (dateStr.startsWith("19") || dateStr.startsWith("20")) {
            String formattedDate = dateStr.substring(0, 4) + "-" + dateStr.substring(4, 6) + "-" + dateStr.substring(6, 8) + "T" + dateStr.substring(8, 10) + ":" + dateStr.substring(10, 12) + ":00";
            metadata.set(TikaCoreProperties.CREATED, formattedDate);
            metadata.set(Metadata.DATE, formattedDate);
        }
        metadata.set("Content-Type", PRT_MIME_TYPE);
        byte[] desc = new byte[500];
        IOUtils.readFully((InputStream)stream, (byte[])desc);
        String description = this.extractText(desc, true);
        if (description.length() > 0) {
            metadata.set(TikaCoreProperties.DESCRIPTION, description);
        }
        while ((read = stream.read()) > -1) {
            if (read == 224 || read == 227 || read == 240) {
                int nread = stream.read();
                if (nread != 63 && nread != 191) continue;
                if (read == 227 && nread == 63) {
                    if (!l5.is33()) continue;
                    this.handleNoteText(stream, xhtml);
                    continue;
                }
                if (!l5.is00()) continue;
                this.handleViewName(read, nread, stream, xhtml, l5);
                continue;
            }
            l5.record(read);
        }
    }

    private void handleNoteText(InputStream stream, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        int read;
        for (int i = 0; i < 10; ++i) {
            read = stream.read();
            if (read >= 0 && read <= 15) continue;
            return;
        }
        read = stream.read();
        if (read != 31) {
            return;
        }
        int length = EndianUtils.readUShortLE((InputStream)stream);
        if (length <= 2048) {
            this.handleText(length, stream, xhtml);
        }
    }

    private void handleViewName(int typeA, int typeB, InputStream stream, XHTMLContentHandler xhtml, Last5 l5) throws IOException, SAXException, TikaException {
        int maybeLength = EndianUtils.readUShortLE((InputStream)stream);
        if (maybeLength == 0) {
            for (int i = 0; i < 6; ++i) {
                int read = stream.read();
                if (read >= 0 && read <= 15) continue;
                return;
            }
            byte[] b2 = new byte[2];
            IOUtils.readFully((InputStream)stream, (byte[])b2);
            int length = EndianUtils.getUShortLE((byte[])b2);
            if (length > 1 && length <= 2048) {
                this.handleText(length, stream, xhtml);
            } else {
                l5.record(b2[0]);
                l5.record(b2[1]);
            }
        } else if (maybeLength > 0 && maybeLength < 2048) {
            this.handleText(maybeLength, stream, xhtml);
        }
    }

    private void handleText(int length, InputStream stream, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        byte[] str = new byte[length];
        IOUtils.readFully((InputStream)stream, (byte[])str);
        if (str[length - 1] != 0) {
            return;
        }
        String text = this.extractText(str, false);
        xhtml.startElement("p");
        xhtml.characters(text);
        xhtml.endElement("p");
    }

    private String extractText(byte[] data, boolean trim) throws TikaException {
        String text;
        int length = data.length - 1;
        if (trim) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 0) continue;
                length = i;
                break;
            }
        }
        try {
            text = new String(data, 0, length, "cp437");
        }
        catch (UnsupportedEncodingException e) {
            throw new TikaException("JVM Broken, core codepage CP437 missing!");
        }
        text = text.replace("\u03c6", "\u00d8");
        return text;
    }

    private static class Last5 {
        byte[] data = new byte[5];
        int pos = 0;

        private Last5() {
        }

        private void record(int b) {
            this.data[this.pos] = (byte)b;
            ++this.pos;
            if (this.pos >= this.data.length) {
                this.pos = 0;
            }
        }

        private byte[] get() {
            byte[] ret = new byte[5];
            for (int i = 0; i < ret.length; ++i) {
                int p = this.pos - i;
                if (p < 0) {
                    p += ret.length;
                }
                ret[i] = this.data[p];
            }
            return ret;
        }

        private boolean is33() {
            byte[] last5;
            for (byte b : last5 = this.get()) {
                if (b == 51) continue;
                return false;
            }
            return true;
        }

        private boolean is00() {
            byte[] last5;
            for (byte b : last5 = this.get()) {
                if (b == 0) continue;
                return false;
            }
            return true;
        }
    }
}

