/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Code;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class CodeSpan
extends SourceSpan {
    Pattern pattern = Pattern.compile("(`+).*", 40);

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if (c == '`' && (!cursor.hasPrevious() || cursor.getPrevious() != '`') && (matcher = cursor.matcher(this.pattern)).matches()) {
            String openingBackticks = matcher.group(1);
            int backtickCount = openingBackticks.length();
            Pattern closingPattern = Pattern.compile("(?<!`)(" + Strings.repeat((String)"`", (int)backtickCount) + ")([^`]|$)", 40);
            cursor.advance(backtickCount);
            String textAtOffset = cursor.getTextAtOffset();
            cursor.rewind(backtickCount);
            Matcher closingMatcher = closingPattern.matcher(textAtOffset);
            if (closingMatcher.find()) {
                String codeText = textAtOffset.substring(0, closingMatcher.start());
                return Optional.of((Object)new Code(cursor.getLineAtOffset(), cursor.getOffset(), backtickCount, codeText));
            }
        }
        return Optional.absent();
    }
}

