/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TikaConfig {
    private final CompositeParser parser;
    private final Detector detector;
    private final MimeTypes mimeTypes;

    private static MimeTypes getDefaultMimeTypes() {
        return MimeTypes.getDefaultMimeTypes();
    }

    private static Detector getDefaultDetector(MimeTypes types, ServiceLoader loader) {
        return new DefaultDetector(types, loader);
    }

    private static CompositeParser getDefaultParser(MimeTypes types, ServiceLoader loader) {
        return new DefaultParser(types.getMediaTypeRegistry(), loader);
    }

    public TikaConfig(String file) throws TikaException, IOException, SAXException {
        this(new File(file));
    }

    public TikaConfig(File file) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(file));
    }

    public TikaConfig(URL url) throws TikaException, IOException, SAXException {
        this(url, ServiceLoader.getContextClassLoader());
    }

    public TikaConfig(URL url, ClassLoader loader) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(url.toString()).getDocumentElement(), loader);
    }

    public TikaConfig(InputStream stream) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(stream));
    }

    public TikaConfig(Document document) throws TikaException, IOException {
        this(document.getDocumentElement());
    }

    public TikaConfig(Element element) throws TikaException, IOException {
        this(element, new ServiceLoader());
    }

    public TikaConfig(Element element, ClassLoader loader) throws TikaException, IOException {
        this(element, new ServiceLoader(loader));
    }

    private TikaConfig(Element element, ServiceLoader loader) throws TikaException, IOException {
        this.mimeTypes = TikaConfig.typesFromDomElement(element);
        this.detector = TikaConfig.detectorFromDomElement(element, this.mimeTypes, loader);
        this.parser = TikaConfig.parserFromDomElement(element, this.mimeTypes, loader);
    }

    public TikaConfig(ClassLoader loader) throws MimeTypeException, IOException {
        ServiceLoader serviceLoader = new ServiceLoader(loader);
        this.mimeTypes = TikaConfig.getDefaultMimeTypes();
        this.detector = TikaConfig.getDefaultDetector(this.mimeTypes, serviceLoader);
        this.parser = TikaConfig.getDefaultParser(this.mimeTypes, serviceLoader);
    }

    public TikaConfig() throws TikaException, IOException {
        ServiceLoader loader = new ServiceLoader();
        String config = System.getProperty("tika.config");
        if (config == null) {
            config = System.getenv("TIKA_CONFIG");
        }
        if (config == null) {
            this.mimeTypes = TikaConfig.getDefaultMimeTypes();
            this.parser = TikaConfig.getDefaultParser(this.mimeTypes, loader);
            this.detector = TikaConfig.getDefaultDetector(this.mimeTypes, loader);
        } else {
            InputStream stream = null;
            File file = new File(config);
            if (file.isFile()) {
                stream = new FileInputStream(file);
            }
            if (stream == null) {
                try {
                    stream = new URL(config).openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (stream == null) {
                stream = loader.getResourceAsStream(config);
            }
            if (stream == null) {
                throw new TikaException("Specified Tika configuration not found: " + config);
            }
            try {
                try {
                    Element element = TikaConfig.getBuilder().parse(stream).getDocumentElement();
                    this.mimeTypes = TikaConfig.typesFromDomElement(element);
                    this.parser = TikaConfig.parserFromDomElement(element, this.mimeTypes, loader);
                    this.detector = TikaConfig.detectorFromDomElement(element, this.mimeTypes, loader);
                }
                catch (SAXException e) {
                    throw new TikaException("Specified Tika configuration has syntax errors: " + config, e);
                }
            }
            finally {
                stream.close();
            }
        }
    }

    private static String getText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            StringBuilder builder = new StringBuilder();
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                builder.append(TikaConfig.getText(list.item(i)));
                ++i;
            }
            return builder.toString();
        }
        return "";
    }

    public Parser getParser(MediaType mimeType) {
        return this.parser.getParsers().get(mimeType);
    }

    public Parser getParser() {
        return this.parser;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public MimeTypes getMimeRepository() {
        return this.mimeTypes;
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.mimeTypes.getMediaTypeRegistry();
    }

    public static TikaConfig getDefaultConfig() {
        try {
            return new TikaConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read default configuration", e);
        }
        catch (TikaException e) {
            throw new RuntimeException("Unable to access default configuration", e);
        }
    }

    private static DocumentBuilder getBuilder() throws TikaException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser not available", e);
        }
    }

    private static Element getChild(Element element, String name) {
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && name.equals(child.getNodeName())) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private static MimeTypes typesFromDomElement(Element element) throws TikaException, IOException {
        Element mtr = TikaConfig.getChild(element, "mimeTypeRepository");
        if (mtr != null && mtr.hasAttribute("resource")) {
            return MimeTypesFactory.create(mtr.getAttribute("resource"));
        }
        return TikaConfig.getDefaultMimeTypes();
    }

    private static CompositeParser parserFromDomElement(Element element, MimeTypes mimeTypes, ServiceLoader loader) throws TikaException, IOException {
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        NodeList nodes = element.getElementsByTagName("parser");
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String name = node.getAttribute("class");
            try {
                Class<Parser> parserClass = loader.getServiceClass(Parser.class, name);
                if (AutoDetectParser.class.isAssignableFrom(parserClass)) {
                    throw new TikaException("AutoDetectParser not supported in a <parser> configuration element: " + name);
                }
                Parser parser = parserClass.newInstance();
                NodeList mimes = node.getElementsByTagName("mime");
                if (mimes.getLength() > 0) {
                    HashSet<MediaType> types = new HashSet<MediaType>();
                    int j = 0;
                    while (j < mimes.getLength()) {
                        String mime = TikaConfig.getText(mimes.item(j));
                        MediaType type = MediaType.parse(mime);
                        if (type == null) {
                            throw new TikaException("Invalid media type name: " + mime);
                        }
                        types.add(type);
                        ++j;
                    }
                    parser = ParserDecorator.withTypes(parser, types);
                }
                parsers.add(parser);
            }
            catch (ClassNotFoundException e) {
                throw new TikaException("Unable to find a parser class: " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new TikaException("Unable to access a parser class: " + name, e);
            }
            catch (InstantiationException e) {
                throw new TikaException("Unable to instantiate a parser class: " + name, e);
            }
            ++i;
        }
        if (parsers.isEmpty()) {
            return TikaConfig.getDefaultParser(mimeTypes, loader);
        }
        MediaTypeRegistry registry = mimeTypes.getMediaTypeRegistry();
        return new CompositeParser(registry, parsers);
    }

    private static Detector detectorFromDomElement(Element element, MimeTypes mimeTypes, ServiceLoader loader) throws TikaException, IOException {
        ArrayList<Detector> detectors = new ArrayList<Detector>();
        NodeList nodes = element.getElementsByTagName("detector");
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String name = node.getAttribute("class");
            try {
                Class<Detector> detectorClass = loader.getServiceClass(Detector.class, name);
                detectors.add(detectorClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new TikaException("Unable to find a detector class: " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new TikaException("Unable to access a detector class: " + name, e);
            }
            catch (InstantiationException e) {
                throw new TikaException("Unable to instantiate a detector class: " + name, e);
            }
            ++i;
        }
        if (detectors.isEmpty()) {
            return TikaConfig.getDefaultDetector(mimeTypes, loader);
        }
        MediaTypeRegistry registry = mimeTypes.getMediaTypeRegistry();
        return new CompositeDetector(registry, detectors);
    }
}

