/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class ImageEvent
extends DocumentBuilderEvent {
    private final String url;
    private final Attributes attributes;

    public ImageEvent(Attributes attributes, String url) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"Must provide an url");
        this.attributes = ((Attributes)Preconditions.checkNotNull((Object)attributes, (Object)"Must provide attributes")).clone();
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.image(this.attributes, this.url);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.url});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageEvent)) {
            return false;
        }
        return Objects.equal((Object)this.url, (Object)((ImageEvent)obj).url);
    }

    public String toString() {
        return String.format("image(%s)", this.url);
    }
}

