/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmItsfHeader;
import org.apache.tika.parser.chm.accessor.ChmItspHeader;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.core.ChmCommons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChmDirectoryListingSet {
    private List<DirectoryListingEntry> dlel;
    private byte[] data;
    private int placeHolder = -1;
    private long dataOffset = -1L;
    private int controlDataIndex = -1;
    private int resetTableIndex = -1;
    private boolean isNotControlDataFound = true;
    private boolean isNotResetTableFound = true;

    public ChmDirectoryListingSet(byte[] data, ChmItsfHeader chmItsHeader, ChmItspHeader chmItspHeader) throws TikaException {
        this.setDirectoryListingEntryList(new ArrayList<DirectoryListingEntry>());
        ChmCommons.assertByteArrayNotNull(data);
        this.setData(data);
        this.enumerateChmDirectoryListingList(chmItsHeader, chmItspHeader);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("list:=" + this.getDirectoryListingEntryList().toString() + System.getProperty("line.separator"));
        sb.append("number of list items:=" + this.getDirectoryListingEntryList().size());
        return sb.toString();
    }

    public int getControlDataIndex() {
        return this.controlDataIndex;
    }

    protected void setControlDataIndex(int controlDataIndex) {
        this.controlDataIndex = controlDataIndex;
    }

    public int getResetTableIndex() {
        return this.resetTableIndex;
    }

    protected void setResetTableIndex(int resetTableIndex) {
        this.resetTableIndex = resetTableIndex;
    }

    private int getPlaceHolder() {
        return this.placeHolder;
    }

    private void setPlaceHolder(int placeHolder) {
        this.placeHolder = placeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enumerateChmDirectoryListingList(ChmItsfHeader chmItsHeader, ChmItspHeader chmItspHeader) {
        try {
            int startPmgl = chmItspHeader.getIndex_head();
            int stopPmgl = chmItspHeader.getUnknown_0024();
            int dir_offset = (int)(chmItsHeader.getDirOffset() + (long)chmItspHeader.getHeader_len());
            this.setDataOffset(chmItsHeader.getDataOffset());
            int previous_index = 0;
            byte[] dir_chunk = null;
            for (int i = startPmgl; i <= stopPmgl; ++i) {
                int data_copied = (1 + i) * (int)chmItspHeader.getBlock_len() + dir_offset;
                if (i == 0) {
                    dir_chunk = new byte[(int)chmItspHeader.getBlock_len()];
                    dir_chunk = ChmCommons.copyOfRange(this.getData(), dir_offset, (1 + i) * (int)chmItspHeader.getBlock_len() + dir_offset);
                    previous_index = data_copied;
                } else {
                    dir_chunk = new byte[(int)chmItspHeader.getBlock_len()];
                    dir_chunk = ChmCommons.copyOfRange(this.getData(), previous_index, (1 + i) * (int)chmItspHeader.getBlock_len() + dir_offset);
                    previous_index = data_copied;
                }
                this.enumerateOneSegment(dir_chunk);
                dir_chunk = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setData(null);
        }
    }

    private void checkControlData(DirectoryListingEntry dle) {
        if (this.isNotControlDataFound && dle.getName().contains("ControlData")) {
            this.setControlDataIndex(this.getDirectoryListingEntryList().size());
            this.isNotControlDataFound = false;
        }
    }

    private void checkResetTable(DirectoryListingEntry dle) {
        if (this.isNotResetTableFound && dle.getName().contains("ResetTable")) {
            this.setResetTableIndex(this.getDirectoryListingEntryList().size());
            this.isNotResetTableFound = false;
        }
    }

    private void enumerateOneSegment(byte[] dir_chunk) {
        try {
            if (dir_chunk != null) {
                int indexWorkData = ChmCommons.indexOf(dir_chunk, "::".getBytes());
                int indexUserData = ChmCommons.indexOf(dir_chunk, "/".getBytes());
                if (indexUserData < indexWorkData) {
                    this.setPlaceHolder(indexUserData);
                } else {
                    this.setPlaceHolder(indexWorkData);
                }
                if (this.getPlaceHolder() > 0 && dir_chunk[this.getPlaceHolder() - 1] != 115) {
                    do {
                        if (dir_chunk[this.getPlaceHolder() - 1] > 0) {
                            DirectoryListingEntry dle = new DirectoryListingEntry();
                            this.doNameCheck(dir_chunk, dle);
                            dle.setName(new String(ChmCommons.copyOfRange(dir_chunk, this.getPlaceHolder(), this.getPlaceHolder() + dle.getNameLength())));
                            this.checkControlData(dle);
                            this.checkResetTable(dle);
                            this.setPlaceHolder(this.getPlaceHolder() + dle.getNameLength());
                            if (this.getPlaceHolder() < dir_chunk.length && dir_chunk[this.getPlaceHolder()] == 0) {
                                dle.setEntryType(ChmCommons.EntryType.UNCOMPRESSED);
                            } else {
                                dle.setEntryType(ChmCommons.EntryType.COMPRESSED);
                            }
                            this.setPlaceHolder(this.getPlaceHolder() + 1);
                            dle.setOffset(this.getEncint(dir_chunk));
                            dle.setLength(this.getEncint(dir_chunk));
                            this.getDirectoryListingEntryList().add(dle);
                            continue;
                        }
                        this.setPlaceHolder(this.getPlaceHolder() + 1);
                    } while (this.hasNext(dir_chunk));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doNameCheck(byte[] dir_chunk, DirectoryListingEntry dle) {
        if (dir_chunk[this.getPlaceHolder() - 1] == 115) {
            dle.setNameLength(dir_chunk[this.getPlaceHolder() - 1] & 0x21);
        } else if (dir_chunk[this.getPlaceHolder() + 1] == 47) {
            dle.setNameLength(dir_chunk[this.getPlaceHolder()]);
            this.setPlaceHolder(this.getPlaceHolder() + 1);
        } else {
            dle.setNameLength(dir_chunk[this.getPlaceHolder() - 1]);
        }
    }

    private boolean hasNext(byte[] dir_chunk) {
        while (this.getPlaceHolder() < dir_chunk.length) {
            if (dir_chunk[this.getPlaceHolder()] == 47 && dir_chunk[this.getPlaceHolder() + 1] != 58) {
                this.setPlaceHolder(this.getPlaceHolder());
                return true;
            }
            if (dir_chunk[this.getPlaceHolder()] == 58 && dir_chunk[this.getPlaceHolder() + 1] == 58) {
                this.setPlaceHolder(this.getPlaceHolder());
                return true;
            }
            this.setPlaceHolder(this.getPlaceHolder() + 1);
        }
        return false;
    }

    private int getEncint(byte[] data_chunk) {
        BigInteger bi = BigInteger.ZERO;
        byte[] nb = new byte[1];
        if (this.getPlaceHolder() < data_chunk.length) {
            byte ob;
            while ((ob = data_chunk[this.getPlaceHolder()]) < 0) {
                nb[0] = (byte)(ob & 0x7F);
                bi = bi.shiftLeft(7).add(new BigInteger(nb));
                this.setPlaceHolder(this.getPlaceHolder() + 1);
            }
            nb[0] = (byte)(ob & 0x7F);
            bi = bi.shiftLeft(7).add(new BigInteger(nb));
            this.setPlaceHolder(this.getPlaceHolder() + 1);
        }
        return bi.intValue();
    }

    public static void main(String[] args) {
    }

    public void setDirectoryListingEntryList(List<DirectoryListingEntry> dlel) {
        this.dlel = dlel;
    }

    public List<DirectoryListingEntry> getDirectoryListingEntryList() {
        return this.dlel;
    }

    private void setData(byte[] data) {
        this.data = data;
    }

    private byte[] getData() {
        return this.data;
    }

    private void setDataOffset(long dataOffset) {
        this.dataOffset = dataOffset;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }
}

