/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LookAheadReader;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.ReadAheadBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class UnderlinedHeadingBlock
extends Block
implements ReadAheadBlock {
    private static final Pattern h1pattern = Pattern.compile("(=+)\\s*");
    private static final Pattern h2pattern = Pattern.compile("(-+)\\s*");
    private static final Pattern h3pattern = Pattern.compile("(~+)\\s*");
    private static final Pattern h4pattern = Pattern.compile("(\\^+)\\s*");
    private static final Pattern h5pattern = Pattern.compile("(\\++)\\s*");
    private int blockLineCount;
    private int level;

    @Override
    public boolean canStart(String line, int lineOffset, LookAheadReader lookAheadReader) {
        this.blockLineCount = 0;
        this.level = 0;
        String nextLine = lookAheadReader.lookAhead();
        if (nextLine == null) {
            return false;
        }
        int expectedLength = line.trim().length() - lineOffset;
        if (this.checkNextLine(expectedLength, nextLine, h1pattern, 1)) {
            return true;
        }
        if (this.checkNextLine(expectedLength, nextLine, h2pattern, 2)) {
            return true;
        }
        if (this.checkNextLine(expectedLength, nextLine, h3pattern, 3)) {
            return true;
        }
        if (this.checkNextLine(expectedLength, nextLine, h4pattern, 4)) {
            return true;
        }
        return this.checkNextLine(expectedLength, nextLine, h5pattern, 5);
    }

    private boolean checkNextLine(int length, String nextLine, Pattern pattern, int l) {
        int lineLength;
        Matcher matcher = pattern.matcher(nextLine);
        if (matcher.matches() && (lineLength = matcher.group(1).length()) > length - 2 && lineLength < length + 2) {
            this.level = l;
            return true;
        }
        return false;
    }

    public boolean canStart(String line, int lineOffset) {
        String message = "Read-ahead required, call canStart(String, int, LookAheadReader) instead.";
        throw new UnsupportedOperationException(message);
    }

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            HeadingAttributes attributes = new HeadingAttributes();
            attributes.setId(this.state.getIdGenerator().newId(null, line));
            this.builder.beginHeading(this.level, (Attributes)attributes);
            this.builder.characters(line.trim());
        } else {
            this.builder.endHeading();
            this.setClosed(true);
        }
        ++this.blockLineCount;
        return -1;
    }
}

