/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DesktopSearchLabelProvider
extends DecoratingStyledCellLabelProvider
implements IPropertyChangeListener {
    public DesktopSearchLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
        super(labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        this.registerListeners();
        this.setOwnerDrawEnabled(this.coloredLabels());
        super.initialize(viewer, column);
    }

    private void registerListeners() {
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
    }

    private void deregisterListeners() {
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        PlatformUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.deregisterListeners();
        super.dispose();
    }

    private boolean coloredLabels() {
        return PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS");
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("QUALIFIER_COLOR") || property.equals("DECORATIONS_COLOR") || property.equals("USE_COLORED_LABELS")) {
            if (this.getViewer() == null || this.getViewer().getControl().isDisposed()) {
                return;
            }
            Display display = this.getViewer().getControl().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DesktopSearchLabelProvider.this.refresh();
                }
            });
        }
    }

    protected void refresh() {
        ColumnViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            this.setOwnerDrawEnabled(this.coloredLabels());
            viewer.refresh();
        }
    }
}

