/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.views;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.sandbox.ui.planner.ActivityReportAction;
import org.eclipse.mylyn.internal.sandbox.ui.planner.TaskActivityLabelProvider;
import org.eclipse.mylyn.internal.sandbox.ui.views.TaskActivityViewContentProvider;
import org.eclipse.mylyn.internal.sandbox.ui.views.TaskActivityViewSorter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskListElementAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.IThemeManager;

public class TaskActivityView
extends ViewPart {
    private static final String MEMENTO_KEY_WIDTH = "colwidth";
    public static final String ID = "org.eclipse.mylyn.tasklist.activity";
    public static final String columnWidthIdentifier = "org.eclipse.mylyn.tasklist.ui.views.taskactivity.columnwidth";
    public static final String tableSortIdentifier = "org.eclipse.mylyn.tasklist.ui.views.taskactivity.sortIndex";
    private static TaskActivityView INSTANCE;
    private IMemento taskActivityMemento;
    private OpenTaskListElementAction openTaskEditor;
    private final String[] columnNames = new String[]{" ", " !", "Description", "Elapsed", "Estimated", "Scheduled"};
    private final String[] ESTIMATE_TIMES = new String[]{"0 Hours", "1 Hours", "2 Hours", "3 Hours", "4 Hours", "5 Hours", "6 Hours", "7 Hours", "8 Hours", "9 Hours", "10 Hours"};
    private final int[] columnWidths = new int[]{60, 12, 160, 60, 70, 100};
    private TreeColumn[] columns;
    private TaskActivityLabelProvider taskHistoryTreeLabelProvider;
    private TreeViewer treeViewer;
    private TaskActivityViewContentProvider taskActivityTableContentProvider;
    private IThemeManager themeManager;
    private final IPropertyChangeListener THEME_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end")) {
                TaskActivityView.this.taskHistoryTreeLabelProvider.setCategoryBackgroundColor(TaskActivityView.this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end"));
                TaskActivityView.this.refresh();
            }
        }
    };
    private final ITaskActivationListener TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

        public void taskActivated(ITask task) {
            TaskActivityView.this.refresh();
        }
    };
    private final ITaskListChangeListener TASKLIST_CHANGE_LISTENER = new ITaskListChangeListener(){

        public void containersChanged(Set<TaskContainerDelta> containers) {
            TaskActivityView.this.refresh();
        }
    };
    private TaskActivityViewSorter sorter;

    public static TaskActivityView openInActivePerspective() {
        try {
            return (TaskActivityView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public TaskActivityView() {
        INSTANCE = this;
        TasksUi.getTaskActivityManager().addActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiInternal.getTaskList().addChangeListener(this.TASKLIST_CHANGE_LISTENER);
    }

    public void dispose() {
        super.dispose();
        TasksUi.getTaskActivityManager().removeActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiInternal.getTaskList().removeChangeListener(this.TASKLIST_CHANGE_LISTENER);
    }

    public void createPartControl(Composite parent) {
        this.themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener(this.THEME_CHANGE_LISTENER);
        int treeStyle = 66306;
        this.treeViewer = new TreeViewer(parent, treeStyle);
        this.getViewer().getTree().setHeaderVisible(true);
        this.getViewer().getTree().setLinesVisible(true);
        this.getViewer().setColumnProperties(this.columnNames);
        this.getViewer().setUseHashlookup(true);
        this.columns = new TreeColumn[this.columnNames.length];
        int i = 0;
        while (i < this.columnNames.length) {
            this.columns[i] = new TreeColumn(this.getViewer().getTree(), 16384);
            this.columns[i].setText(this.columnNames[i]);
            this.columns[i].setWidth(this.columnWidths[i]);
            final int index = i;
            this.columns[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int column = index - 1;
                    if (column == TaskActivityView.this.sorter.getSortColumn()) {
                        TaskActivityView.this.sorter.reverseDirection();
                    } else {
                        TaskActivityView.this.sorter.setSortColumn(column);
                    }
                    TaskActivityView.this.getViewer().refresh();
                }
            });
            this.columns[i].addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    int j = 0;
                    while (j < TaskActivityView.this.columnWidths.length) {
                        if (TaskActivityView.this.columns[j].equals(e.getSource())) {
                            ((TaskActivityView)TaskActivityView.this).columnWidths[j] = TaskActivityView.this.columns[j].getWidth();
                        }
                        ++j;
                    }
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            ++i;
        }
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        Color categoryBackground = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        this.sorter = new TaskActivityViewSorter();
        this.getViewer().setSorter((ViewerSorter)this.sorter);
        this.taskActivityTableContentProvider = new TaskActivityViewContentProvider(TasksUiPlugin.getTaskActivityManager());
        this.taskHistoryTreeLabelProvider = new TaskActivityLabelProvider((ILabelProvider)new TaskElementLabelProvider(false), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), categoryBackground, this.taskActivityTableContentProvider);
        this.getViewer().setContentProvider((IContentProvider)this.taskActivityTableContentProvider);
        this.getViewer().setLabelProvider((IBaseLabelProvider)this.taskHistoryTreeLabelProvider);
        this.getViewer().setInput((Object)this.getViewSite());
        this.restoreState();
        this.createCellEditorListener();
        this.makeActions();
        this.initDrop();
        this.hookOpenAction();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)new ActivityReportAction());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void initDrop() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.treeViewer.addDropSupport(2, types, (DropTargetListener)new ViewerDropAdapter((Viewer)this.treeViewer){
            {
                this.setFeedbackEnabled(false);
            }

            public boolean performDrop(Object data) {
                DateRange reminderCalendar;
                IStructuredSelection selection = (IStructuredSelection)TaskListView.getFromActivePerspective().getViewer().getSelection();
                Object target = this.getCurrentTarget();
                if (target instanceof ScheduledTaskContainer) {
                    ScheduledTaskContainer container = (ScheduledTaskContainer)target;
                    reminderCalendar = container.getDateRange();
                } else if (target instanceof ITask) {
                    reminderCalendar = ((AbstractTask)target).getScheduledForDate();
                } else {
                    return false;
                }
                for (Object selectedObject : selection) {
                    AbstractTask task = null;
                    if (selectedObject instanceof ITask) {
                        task = (AbstractTask)selectedObject;
                    }
                    if (task == null) continue;
                    TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, reminderCalendar);
                }
                return true;
            }

            public boolean validateDrop(Object targetObject, int operation, TransferData transferType) {
                Object selectedObject = ((IStructuredSelection)TaskListView.getFromActivePerspective().getViewer().getSelection()).getFirstElement();
                if (selectedObject instanceof ITaskContainer) {
                    return false;
                }
                Object target = this.getCurrentTarget();
                ScheduledTaskContainer dateRangeContainer = null;
                if (target instanceof ScheduledTaskContainer) {
                    dateRangeContainer = (ScheduledTaskContainer)target;
                } else if (target instanceof ITask) {
                    AbstractTask task = (AbstractTask)target;
                    dateRangeContainer = new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), task.getScheduledForDate());
                }
                return dateRangeContainer != null && (dateRangeContainer.isPresent() || dateRangeContainer.isFuture());
            }
        });
    }

    private void makeActions() {
        this.openTaskEditor = new OpenTaskListElementAction();
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.openTaskEditor);
    }

    private void hookOpenAction() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TaskActivityView.this.openTaskEditor.run();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskActivityView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public static TaskActivityView getDefault() {
        return INSTANCE;
    }

    private TreeViewer getViewer() {
        return this.treeViewer;
    }

    private void refresh() {
        if (PlatformUI.getWorkbench() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TaskActivityView.this.getViewer().getControl() != null && !TaskActivityView.this.getViewer().getControl().isDisposed()) {
                        TaskActivityView.this.treeViewer.refresh();
                    }
                }
            });
        }
    }

    public ITask getSelectedTask() {
        StructuredSelection structuredSelection;
        Object element;
        ISelection selection = this.getViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof StructuredSelection && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ITask) {
            return (ITask)structuredSelection.getFirstElement();
        }
        return null;
    }

    public void setFocus() {
    }

    private void createCellEditorListener() {
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        final ComboBoxCellEditor estimateEditor = new ComboBoxCellEditor((Composite)this.treeViewer.getTree(), this.ESTIMATE_TIMES, 8);
        editors[0] = null;
        editors[1] = null;
        editors[2] = null;
        editors[3] = null;
        editors[4] = estimateEditor;
        editors[5] = null;
        estimateEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                Object selection = ((IStructuredSelection)TaskActivityView.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof AbstractTask) {
                    AbstractTask task = (AbstractTask)selection;
                    int estimate = (Integer)estimateEditor.getValue();
                    if (estimate == -1) {
                        estimate = 0;
                    }
                    task.setEstimatedTimeHours(estimate);
                    TaskActivityView.this.refresh();
                }
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        });
        this.treeViewer.setCellEditors(editors);
        this.getViewer().setCellModifier((ICellModifier)new TaskActivityCellModifier(this.treeViewer));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.taskActivityMemento = memento;
    }

    public void saveState(IMemento memento) {
        IMemento colMemento = memento.createChild(columnWidthIdentifier);
        int i = 0;
        while (i < this.columnWidths.length) {
            IMemento m = colMemento.createChild("col" + i);
            m.putInteger(MEMENTO_KEY_WIDTH, this.columnWidths[i]);
            ++i;
        }
        this.sorter.saveState(memento);
    }

    private void restoreState() {
        if (this.taskActivityMemento != null) {
            IMemento taskActivityWidth = this.taskActivityMemento.getChild(columnWidthIdentifier);
            if (taskActivityWidth != null) {
                int i = 0;
                while (i < this.columnWidths.length) {
                    IMemento m = taskActivityWidth.getChild("col" + i);
                    if (m != null) {
                        int width;
                        this.columnWidths[i] = width = m.getInteger(MEMENTO_KEY_WIDTH).intValue();
                        this.columns[i].setWidth(width);
                    }
                    ++i;
                }
            }
            this.sorter.restoreState(this.taskActivityMemento);
        }
        this.getViewer().refresh();
    }

    private class TaskActivityCellModifier
    implements ICellModifier {
        private final TreeViewer treeViewer;

        public TaskActivityCellModifier(TreeViewer tableViewer) {
            this.treeViewer = tableViewer;
        }

        public boolean canModify(Object element, String property) {
            int columnIndex;
            return element instanceof ITask && (columnIndex = Arrays.asList(TaskActivityView.this.columnNames).indexOf(property)) == 4;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof ITask) {
                AbstractTask task = (AbstractTask)element;
                int columnIndex = Arrays.asList(TaskActivityView.this.columnNames).indexOf(property);
                if (columnIndex == 4) {
                    return new Integer(Arrays.asList(TaskActivityView.this.ESTIMATE_TIMES).indexOf(task.getEstimatedTimeHours()));
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(TaskActivityView.this.columnNames).indexOf(property);
            if (element instanceof AbstractTask) {
                AbstractTask task = (AbstractTask)element;
                if (columnIndex == 4 && value instanceof Integer) {
                    task.setEstimatedTimeHours((Integer)value * 10);
                    this.treeViewer.refresh();
                }
            }
        }
    }
}

