/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.sandbox.search.ui.CompositeSearchProvider;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.internal.sandbox.search.ui.SearchPlugin;
import org.eclipse.mylyn.internal.sandbox.search.ui.provider.BasicSearchProvider;
import org.eclipse.mylyn.sandbox.search.ui.SearchProvider;

public class SearchProviders {
    private static final String EXTENSION_POINT_NAME_SEARCH_PROVIDER = "searchProvider";
    private static boolean noProviderWarningLogged;

    public static List<SearchProvider> getSearchProviders() {
        ArrayList<SearchProvider> providers = new ArrayList<SearchProvider>();
        String pluginId = SearchPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginId, EXTENSION_POINT_NAME_SEARCH_PROVIDER);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    SearchProvider provider = (SearchProvider)element.createExecutableExtension("class");
                    providers.add(provider);
                }
                catch (CoreException e) {
                    SearchPlugin.getDefault().getLog().log((IStatus)new Status(4, pluginId, "Cannot instantiate search provider " + element.getAttribute("class"), (Throwable)e));
                }
                ++n2;
            }
        }
        return providers;
    }

    public static SearchProvider getSearchProvider() throws CoreException {
        List<SearchProvider> searchProviders = SearchProviders.getSearchProviders();
        if (searchProviders.size() > 1) {
            return new CompositeSearchProvider(searchProviders);
        }
        if (!searchProviders.isEmpty()) {
            return searchProviders.get(0);
        }
        if (!noProviderWarningLogged) {
            noProviderWarningLogged = true;
            SearchPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.mylyn.sandbox.search.ui", Messages.SearchProviders_NoSearchProvidersAvailable));
        }
        return new BasicSearchProvider();
    }
}

