/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.natures.PDE;

public class EclipseTaskRepositoryLinkProvider
extends AbstractTaskRepositoryLinkProvider {
    public TaskRepository getTaskRepository(IResource resource, IRepositoryManager repositoryManager) {
        IProject project = resource.getProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        if (PDE.hasPluginNature((IProject)project)) {
            String providerName;
            IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
            if (pluginModel != null && (providerName = pluginModel.getPluginBase().getProviderName()) != null) {
                return this.getTaskRepository(providerName, (IModel)pluginModel, repositoryManager);
            }
        } else if (PDE.hasFeatureNature((IProject)project)) {
            String providerName;
            IFeatureModel featureModel = PDECore.getDefault().getFeatureModelManager().getFeatureModel(project);
            if (featureModel != null && (providerName = featureModel.getFeature().getProviderName()) != null) {
                return this.getTaskRepository(providerName, (IModel)featureModel, repositoryManager);
            }
        } else {
            PDE.hasUpdateSiteNature((IProject)project);
        }
        return null;
    }

    private TaskRepository getTaskRepository(String providerName, IModel model, IRepositoryManager repositoryManager) {
        Assert.isNotNull((Object)providerName);
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)repositoryManager);
        if (providerName.startsWith("%")) {
            providerName = model.getResourceString(providerName);
        }
        if ("Eclipse.org".equals(providerName)) {
            return repositoryManager.getRepository("bugzilla", "https://bugs.eclipse.org/bugs");
        }
        return null;
    }
}

