/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.java.ui.JavaStructureBridge;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;

public class InterestInducingProblemListener
implements IProblemChangedListener,
IPropertyChangeListener {
    public static final String PREDICTED_INTEREST_ERRORS = "org.eclipse.mylyn.java.ui.interest.prediction.errors";
    private final JavaStructureBridge javaStructureBridge = new JavaStructureBridge();

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        try {
            if (!ContextCore.getContextManager().isContextActive()) {
                return;
            }
            IResource[] iResourceArray = changedResources;
            int n = changedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && (javaElement = (IJavaElement)resource.getAdapter(IJavaElement.class)) != null) {
                    IInteractionElement element = ContextCore.getContextManager().getElement(javaElement.getHandleIdentifier());
                    if (!this.javaStructureBridge.containsProblem(element)) {
                        ((InteractionContextManager)ContextCore.getContextManager()).removeErrorPredictedInterest(element.getHandleIdentifier(), "java", true);
                    } else {
                        ((InteractionContextManager)ContextCore.getContextManager()).addErrorPredictedInterest(element.getHandleIdentifier(), "java", true);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update marker change", (Throwable)e));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREDICTED_INTEREST_ERRORS.equals(event.getProperty())) {
            if (JavaUiBridgePlugin.getDefault().getPreferenceStore().getBoolean(PREDICTED_INTEREST_ERRORS)) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public void enable() {
        JavaPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void disable() {
        JavaPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }
}

