/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.internal.sandbox.search.ui.SearchPlugin;
import org.eclipse.mylyn.sandbox.search.ui.SearchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

class OpenFileAction
extends org.eclipse.ui.actions.OpenFileAction {
    private final IWorkbenchPage page;

    public OpenFileAction(IWorkbenchPage page) {
        super(page);
        this.page = page;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return !selection.isEmpty();
    }

    public void run() {
        super.run();
        ArrayList<SearchResult> unopenable = new ArrayList<SearchResult>();
        List selectedNonResources = this.getSelectedNonResources();
        for (Object object : selectedNonResources) {
            if (!(object instanceof SearchResult)) continue;
            SearchResult result = (SearchResult)((Object)object);
            IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(result.getFile().getParent()));
            IFileStore fileStore = store.getChild(result.getFile().getName());
            IFileInfo info = fileStore.fetchInfo();
            if (!info.isDirectory() && info.exists()) {
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)this.page, (IFileStore)fileStore);
                }
                catch (PartInitException e) {
                    String message = NLS.bind((String)Messages.OpenFileAction_CannotOpenFile, (Object[])new String[]{result.getFile().getName(), e.getMessage()});
                    SearchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.sandbox.search.ui", message, (Throwable)e));
                    MessageDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)Messages.OpenFileAction_OpenFileErrorTitle, (String)message);
                }
                continue;
            }
            unopenable.add(result);
        }
        if (!unopenable.isEmpty()) {
            MessageDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)Messages.OpenFileAction_OpenFileErrorTitle, (String)NLS.bind((String)Messages.OpenFileAction_OpenFileErrorMessage, (Object)unopenable.size()));
        }
    }
}

