/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.hyperlinks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.IResourceHyperlinkExtension;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.ResourceHyperlinkExtensions;

public class ResourceHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<IHyperlink> hyperlinks;
        block7: {
            String line;
            IRegion lineInfo;
            block6: {
                IDocument document;
                block5: {
                    try {
                        document = textViewer.getDocument();
                        if (document != null) break block5;
                        return null;
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                int offset = region.getOffset();
                lineInfo = document.getLineInformationOfOffset(offset);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                if (line.length() != 0) break block6;
                return null;
            }
            hyperlinks = new ArrayList<IHyperlink>();
            this.detectHyperlinks(line, region.getOffset() - lineInfo.getOffset(), lineInfo.getOffset(), hyperlinks);
            if (!hyperlinks.isEmpty()) break block7;
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    private void detectHyperlinks(String line, int lineOffset, int regionOffset, List<IHyperlink> hyperlinks) {
        for (IResourceHyperlinkExtension resourceHyperlinkExtension : ResourceHyperlinkExtensions.getResourceHyperlinkExtensions()) {
            IHyperlink[] links = resourceHyperlinkExtension.findHyperlink(line, lineOffset, regionOffset);
            if (links == null) continue;
            hyperlinks.addAll(Arrays.asList(links));
        }
    }
}

