/**
 * 
 */
package banking.operations;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.objectteams.Team;

import base world.PrepaidPhone;

/**
 * Solution for exercise 2
 */
public team class Transaction {
	private final Lock lock = new ReentrantLock();
	
	public Transaction include(PrepaidPhone as Participant p) {
		return this;
	}
	
	protected class Participant playedBy PrepaidPhone base when (hasRole(base)) {
		void lock () { lock.lock(); }
		void unlock () { lock.unlock(); }
		
		lock <- before load;
		unlock <- after load;
	}
	
	@Override
	public void activate() {
		lock.lock();
		super.activate(Team.ALL_THREADS);
	}

	@Override
	public void deactivate() {
		super.deactivate(Team.ALL_THREADS);
		lock.unlock();
	}
}
