/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;

public class SingleValueAttribute
extends AbstractAttribute {
    public static final char[] ANCHOR_DELIM = "<@".toCharArray();
    private char[] _value;

    public static SingleValueAttribute playedByAttribute(char[] baseClass) {
        return new SingleValueAttribute(PLAYEDBY_NAME, baseClass);
    }

    public static SingleValueAttribute readPlayedBy(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        int utf8Offset = constantPoolOffsets[reader.u2At(readOffset)];
        char[] value = reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
        SingleValueAttribute result = SingleValueAttribute.playedByAttribute(value);
        result._reader = reader;
        return result;
    }

    public static SingleValueAttribute fieldTypeAnchorAttribute(char[] typeAnchor) {
        return new SingleValueAttribute(FIELD_TYPE_ANCHOR, typeAnchor);
    }

    public static SingleValueAttribute readFieldTypeAnchor(ClassFileStruct reader, int readOffset, int structOffset, int[] constantPoolOffsets) {
        int idx = reader.u2At(readOffset);
        int utf8Offset = constantPoolOffsets[idx] - structOffset;
        int num = reader.u2At(utf8Offset + 1);
        char[] value = reader.utf8At(utf8Offset + 3, num);
        return SingleValueAttribute.fieldTypeAnchorAttribute(value);
    }

    protected SingleValueAttribute(char[] name, char[] value) {
        super(name);
        this._value = value;
    }

    public char[] getValue() {
        return this._value;
    }

    @Override
    int size() {
        return 8;
    }

    @Override
    public void write(ClassFile classFile) {
        super.write(classFile);
        if (this._contentsOffset + 8 > this._contents.length) {
            this._contents = classFile.getResizedContents(8);
        }
        int attributeNameIndex = this._constantPool.literalIndex(this._name);
        this._contents[this._contentsOffset++] = (byte)(attributeNameIndex >> 8);
        this._contents[this._contentsOffset++] = (byte)attributeNameIndex;
        this._contents[this._contentsOffset++] = 0;
        this._contents[this._contentsOffset++] = 0;
        this._contents[this._contentsOffset++] = 0;
        this._contents[this._contentsOffset++] = 2;
        int valueIndex = this._constantPool.literalIndex(this._value);
        this._contents[this._contentsOffset++] = (byte)(valueIndex >> 8);
        this._contents[this._contentsOffset++] = (byte)valueIndex;
        this.writeBack(classFile);
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        if (CharOperation.equals(this._name, PLAYEDBY_NAME)) {
            this.checkBindingMismatch(binding, 0x1000000);
            ReferenceBinding roleType = (ReferenceBinding)binding;
            if (CharOperation.indexOf(ANCHOR_DELIM, this._value, true) > -1) {
                char[] typeName = this.singleRoleName(this._value);
                char[][] anchorPath = this.anchorPath(this._value);
                ReferenceBinding staticPart = null;
                int i = 0;
                while (i < anchorPath.length - 1) {
                    ReferenceBinding envType = environment.askForType(CharOperation.subarray(anchorPath, 0, i + 1));
                    if (envType != null) {
                        staticPart = envType;
                    } else if (staticPart != null) break;
                    ++i;
                }
                if (staticPart == null) {
                    return;
                }
                ReferenceBinding currentType = staticPart;
                ITeamAnchor anchor = null;
                while (i < anchorPath.length) {
                    if (currentType instanceof BinaryTypeBinding && ((BinaryTypeBinding)currentType).version == 0L) {
                        roleType.roleModel.addAttribute(this);
                        return;
                    }
                    FieldBinding f = currentType.getField(anchorPath[i], true);
                    if (f == null || !(f.type instanceof ReferenceBinding)) {
                        return;
                    }
                    currentType = (ReferenceBinding)f.type;
                    anchor = anchor == null ? f : f.setPathPrefix(anchor);
                    ++i;
                }
                if (anchor == null) {
                    return;
                }
                ReferenceBinding baseType = anchor.getMemberTypeOfType(typeName);
                if (baseType == null) {
                    return;
                }
                roleType.baseclass = (ReferenceBinding)anchor.getRoleTypeBinding(baseType, null, 0);
            } else {
                roleType.baseclass = this.getResolvedType(environment, this.toConstantPoolName(this._value), missingTypeNames);
            }
            roleType.baseclass.setIsBoundBase(roleType);
        }
    }

    private char[] singleRoleName(char[] anchoredName) {
        int pos = CharOperation.indexOf('<', this._value);
        char[] typeName = CharOperation.subarray(this._value, 0, pos);
        int dollar = CharOperation.indexOf('$', typeName);
        if (dollar > -1) {
            typeName = CharOperation.subarray(typeName, dollar + 1, -1);
        }
        return typeName;
    }

    private char[][] anchorPath(char[] anchoredName) {
        int pos = CharOperation.indexOf('@', this._value);
        char[] anchorName = CharOperation.subarray(this._value, pos + 1, this._value.length - 1);
        return CharOperation.splitOn('.', anchorName);
    }

    @Override
    public boolean evaluate(FieldBinding binding) {
        if (CharOperation.equals(this._name, FIELD_TYPE_ANCHOR)) {
            FieldModel model = FieldModel.getModel(binding);
            model.typeAnchor = this._value;
            return true;
        }
        return false;
    }

    public String toString() {
        return "OT-Attribute " + new String(this._name) + ": " + new String(this._value);
    }
}

