/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.AccessControl;
import org.eclipse.om2m.commons.constants.NotificationContentType;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.sdt.home.monitoring.servlet.SessionManager;
import org.eclipse.om2m.sdt.home.monitoring.util.Constants;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AeRegistration
implements InterworkingService,
Constants {
    private static Log LOGGER = LogFactory.getLog(AeRegistration.class);
    private static final AeRegistration INSTANCE = new AeRegistration();
    private CseService cseService;
    private AE registeredApplication;
    private AccessControlPolicy registeredAcp;
    private Map<String, Set<String>> subscriptionsPerSessions;
    private Map<String, List<JSONObject>> notifications = new HashMap<String, List<JSONObject>>();
    private Map<String, String> subscriptions = new HashMap<String, String>();
    private Map<String, String> subscribedToResourcesSet = new HashMap<String, String>();

    public static AeRegistration getInstance() {
        return INSTANCE;
    }

    private AeRegistration() {
        this.subscriptionsPerSessions = new HashMap<String, Set<String>>();
    }

    public void setCseService(CseService pCseService) {
        this.cseService = pCseService;
    }

    public boolean createAe() {
        Container presentationUrlContainer;
        if (this.cseService == null || !this.createACP()) {
            return false;
        }
        AE ae = new AE();
        ae.setName("SDT_Home_Monitoring_Application");
        ae.setAppName("Home Monitoring Application");
        ae.setAppID("SDT_Home_Monitoring_Application");
        ae.setRequestReachability(Boolean.TRUE);
        ae.getLabels().add("ResourceID/SDT_Home_Monitoring_Application");
        ae.getLabels().add("ResourceType/Application");
        ae.getAccessControlPolicyIDs().add(this.registeredAcp.getResourceID());
        ae.getPointOfAccess().add("HomeMonitoringPOA");
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.CREATE);
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo("/" + org.eclipse.om2m.commons.constants.Constants.CSE_ID + "/" + org.eclipse.om2m.commons.constants.Constants.CSE_NAME);
        request.setResourceType(2);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)ae);
        ResponsePrimitive response = this.cseService.doRequest(request);
        if (!ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return false;
        }
        try {
            this.registeredApplication = (AE)response.getContent();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        Container iconContainer = this.createContainer(this.registeredApplication.getResourceID(), "ICON");
        if (iconContainer != null) {
            this.createContentInstance(iconContainer, "/Home_Monitoring_Application/webapps/images/logo.png");
        }
        if ((presentationUrlContainer = this.createContainer(this.registeredApplication.getResourceID(), "PRESENTATION_URL")) != null) {
            this.createContentInstance(presentationUrlContainer, "/Home_Monitoring_Application/webapps/login.html");
        }
        return true;
    }

    public void deleteAe() {
        this.deleteAllSubscriptions();
        if (this.registeredApplication == null || this.cseService == null) {
            return;
        }
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.DELETE);
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(this.registeredApplication.getResourceID());
        this.cseService.doRequest(request);
        this.deleteAcp();
    }

    private boolean createACP() {
        LOGGER.info((Object)"createACP");
        RequestPrimitive request = new RequestPrimitive();
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName("SDT_Home_Monitoring_Application_ACP");
        acp.setPrivileges(new SetOfAcrs());
        AccessControlRule adminAccessControlRule = new AccessControlRule();
        adminAccessControlRule.setAccessControlOperations(AccessControl.ALL);
        adminAccessControlRule.getAccessControlOriginators().add(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        acp.getPrivileges().getAccessControlRule().add(adminAccessControlRule);
        acp.setSelfPrivileges(new SetOfAcrs());
        acp.getSelfPrivileges().getAccessControlRule().add(adminAccessControlRule);
        request.setOperation(Operation.CREATE);
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo("/" + org.eclipse.om2m.commons.constants.Constants.CSE_ID + "/" + org.eclipse.om2m.commons.constants.Constants.CSE_NAME);
        request.setResourceType(1);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)acp);
        ResponsePrimitive response = this.cseService.doRequest(request);
        if (!ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            LOGGER.info((Object)("createACP KO " + response));
            return false;
        }
        try {
            this.registeredAcp = (AccessControlPolicy)response.getContent();
            LOGGER.info((Object)("createACP OK " + this.registeredAcp));
            return true;
        }
        catch (ClassCastException e) {
            LOGGER.info((Object)("createACP KO " + e));
            return false;
        }
    }

    public void deleteAcp() {
        if (this.registeredAcp == null) {
            return;
        }
        LOGGER.info((Object)("deleteAcp " + this.registeredAcp));
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.DELETE);
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(this.registeredAcp.getResourceID());
        this.cseService.doRequest(request);
    }

    private Container createContainer(String resourceID, String name) {
        Container container = new Container();
        container.setName(name);
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceID);
        request.setOperation(Operation.CREATE);
        request.setResourceType(3);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)container);
        ResponsePrimitive response = this.cseService.doRequest(request);
        return response.getResponseStatusCode().equals(ResponseStatusCode.CREATED) ? (Container)response.getContent() : null;
    }

    private void createContentInstance(Container iconContainer, String value) {
        ContentInstance contentInstance = new ContentInstance();
        contentInstance.setContentInfo("paint");
        contentInstance.setContent(value);
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(iconContainer.getResourceID());
        request.setOperation(Operation.CREATE);
        request.setResourceType(4);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        request.setContent((Object)contentInstance);
        this.cseService.doRequest(request);
    }

    public ResponsePrimitive doExecute(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        if (!request.getOperation().equals(Operation.NOTIFY)) {
            response.setResponseStatusCode(ResponseStatusCode.NOT_IMPLEMENTED);
            return response;
        }
        try {
            String content = (String)request.getContent();
            JSONObject notification = (JSONObject)new JSONParser().parse(content);
            LOGGER.info((Object)("Got notif: " + notification));
            this.addNotification(notification);
            response.setResponseStatusCode(ResponseStatusCode.OK);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error notif", (Throwable)e);
            response.setResponseStatusCode(ResponseStatusCode.BAD_REQUEST);
        }
        return response;
    }

    public String getAPOCPath() {
        return "HomeMonitoringPOA";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONObject> getNotificationsAndClears(String sessionId) {
        List<JSONObject> notifsPerSession;
        ArrayList<JSONObject> notificationsToBeReturned = new ArrayList<JSONObject>();
        Object object = this.notifications;
        synchronized (object) {
            notifsPerSession = this.notifications.get(sessionId);
        }
        if (notifsPerSession != null) {
            object = notifsPerSession;
            synchronized (object) {
                notificationsToBeReturned.addAll(notifsPerSession);
                notifsPerSession.clear();
            }
        }
        return notificationsToBeReturned;
    }

    private void addNotification(JSONObject notification) {
        LOGGER.debug((Object)"add notification from subscription ");
        String subscriptionId = (String)((JSONObject)notification.get((Object)"m2m:sgn")).get((Object)"m2m:sur");
        for (Map.Entry<String, Set<String>> entry : this.subscriptionsPerSessions.entrySet()) {
            if (!entry.getValue().contains(subscriptionId)) continue;
            this.addNotification(entry.getKey(), notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotification(String sessionId, JSONObject notification) {
        List<JSONObject> notifsPerSession = null;
        Object object = this.notifications;
        synchronized (object) {
            notifsPerSession = this.notifications.get(sessionId);
            if (notifsPerSession == null) {
                notifsPerSession = new ArrayList<JSONObject>();
                this.notifications.put(sessionId, notifsPerSession);
            }
        }
        object = notifsPerSession;
        synchronized (object) {
            notifsPerSession.add(notification);
        }
    }

    public boolean createSubscription(String resourceId, String sessionId) {
        if (resourceId == null || !SessionManager.getInstance().checkTokenExists(sessionId)) {
            return false;
        }
        String subscriptionId = null;
        subscriptionId = this.checkIfSubscriptionExists(resourceId);
        if (subscriptionId != null) {
            this.associateSubscriptionAndSession(subscriptionId, sessionId);
            return true;
        }
        Subscription subscription = new Subscription();
        subscription.setNotificationContentType(NotificationContentType.WHOLE_RESOURCE);
        subscription.getNotificationURI().add(this.registeredApplication.getResourceID());
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.CREATE);
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceId);
        request.setResourceType(23);
        request.setReturnContentType("application/json");
        request.setRequestContentType("application/obj");
        request.setContent((Object)subscription);
        ResponsePrimitive response = this.cseService.doRequest(request);
        if (!ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return false;
        }
        try {
            String content = (String)response.getContent();
            JSONObject createdSubscription = (JSONObject)new JSONParser().parse(content);
            subscriptionId = (String)((JSONObject)createdSubscription.get((Object)"m2m:sub")).get((Object)"ri");
            this.addSubscription(subscriptionId, resourceId);
            this.associateSubscriptionAndSession(subscriptionId, sessionId);
            return true;
        }
        catch (ParseException e) {
            LOGGER.error((Object)"unable to parse subscription json payload", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"unable to retrieve subscription object", (Throwable)e);
        }
        catch (ClassCastException e) {
            LOGGER.error((Object)"unable to cast subscription object", (Throwable)e);
        }
        return false;
    }

    private void deleteSubscription(String subscriptionId) {
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.DELETE);
        request.setFrom(org.eclipse.om2m.commons.constants.Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(subscriptionId);
        request.setResourceType(23);
        request.setReturnContentType("application/obj");
        request.setRequestContentType("application/obj");
        this.cseService.doRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubscription(String subscriptionId, String resourceId) {
        Map<String, String> map = this.subscriptions;
        synchronized (map) {
            this.subscriptions.put(subscriptionId, resourceId);
        }
        map = this.subscribedToResourcesSet;
        synchronized (map) {
            this.subscribedToResourcesSet.put(resourceId, subscriptionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllSubscriptions() {
        Map<String, String> map = this.subscriptions;
        synchronized (map) {
            for (String subId : this.subscriptions.keySet()) {
                this.deleteSubscription(subId);
            }
            this.subscriptions.clear();
        }
        map = this.subscribedToResourcesSet;
        synchronized (map) {
            this.subscribedToResourcesSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkIfSubscriptionExists(String subscribedToResourceId) {
        Map<String, String> map = this.subscribedToResourcesSet;
        synchronized (map) {
            return this.subscribedToResourcesSet.get(subscribedToResourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateSubscriptionAndSession(String subscriptionId, String sessionId) {
        Set<String> subscriptionIds = null;
        Object object = this.subscriptionsPerSessions;
        synchronized (object) {
            subscriptionIds = this.subscriptionsPerSessions.get(sessionId);
            if (subscriptionIds == null) {
                subscriptionIds = new HashSet<String>();
                this.subscriptionsPerSessions.put(sessionId, subscriptionIds);
            }
        }
        object = subscriptionIds;
        synchronized (object) {
            subscriptionIds.add(subscriptionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deassociateSubscriptionAndSessions(String sessionId) {
        Map<String, Set<String>> map = this.subscriptionsPerSessions;
        synchronized (map) {
            this.subscriptionsPerSessions.remove(sessionId);
        }
        List<JSONObject> notifsPerSession = null;
        Object object = this.notifications;
        synchronized (object) {
            notifsPerSession = this.notifications.remove(sessionId);
        }
        if (notifsPerSession != null) {
            object = notifsPerSession;
            synchronized (object) {
                notifsPerSession.clear();
            }
        }
    }
}

