/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;

public abstract class EntityMapper<E extends ResourceEntity, R extends Resource> {
    private void mapGenericAttributes(E entity, R resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        resource.setCreationTime(entity.getCreationTime());
        resource.setLastModifiedTime(entity.getLastModifiedTime());
        resource.setName(entity.getName());
        resource.setParentID(entity.getParentID());
        resource.setResourceID(entity.getResourceID());
        resource.setResourceType(entity.getResourceType());
        for (LabelEntity lbl : entity.getLabelsEntities()) {
            resource.getLabels().add(lbl.getLabel());
        }
    }

    public R mapEntityToResource(E entity, RequestPrimitive request) {
        BigInteger resultContent = request.getResultContent();
        BigInteger level = null;
        BigInteger offset = null;
        if (request.getFilterCriteria() != null) {
            level = request.getFilterCriteria().getLevel();
            offset = request.getFilterCriteria().getOffset();
        }
        int levelInt = 1000;
        int offsetInt = 0;
        if (level != null) {
            levelInt = level.intValue();
        }
        if (offset != null) {
            offsetInt = offset.intValue();
        }
        if (resultContent == null) {
            resultContent = ResultContent.ATTRIBUTES;
        } else if (request.getOperation().equals(Operation.CREATE)) {
            resultContent = ResultContent.ATTRIBUTES;
        }
        return this.mapEntityToResource(entity, resultContent, levelInt, offsetInt);
    }

    public R mapEntityToResource(E entity, BigInteger resultContent, int level, int offset) {
        R result = this.createResource(entity);
        if (resultContent.equals(ResultContent.ATTRIBUTES) || resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_REF) || resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_RES) || resultContent.equals(ResultContent.HIERARCHICAL_ADRESS) || resultContent.equals(ResultContent.HIERARCHICAL_AND_ATTRIBUTES) || resultContent.equals(ResultContent.ORIGINAL_RES)) {
            this.mapGenericAttributes(entity, result, level, offset);
            this.mapAttributes(entity, result, level, offset);
        }
        if (resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_REF) || resultContent.equals(ResultContent.CHILD_REF)) {
            this.mapChildResourceRef(entity, result, level, offset);
        }
        if (resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_RES)) {
            this.mapChildResources(entity, result, level, offset);
        }
        return result;
    }

    protected abstract void mapAttributes(E var1, R var2, int var3, int var4);

    protected abstract void mapChildResourceRef(E var1, R var2, int var3, int var4);

    protected abstract List<ChildResourceRef> getChildResourceRef(E var1, int var2, int var3);

    protected abstract void mapChildResources(E var1, R var2, int var3, int var4);

    protected R createResource(E entity) {
        return this.createResource();
    }

    protected abstract R createResource();
}

