/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.remotecse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class RemoteCseService
implements org.eclipse.om2m.core.service.RemoteCseService {
    private static final Log LOGGER = LogFactory.getLog(RemoteCseService.class);
    private static final RemoteCseService INSTANCE = new RemoteCseService();
    private final Map<String, RemoteCSEEntity> remoteCses = new HashMap<String, RemoteCSEEntity>(2);
    private EventAdmin eventAdmin;

    public static RemoteCseService getInstance() {
        return INSTANCE;
    }

    private RemoteCseService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteCSEEntity> getRemoteCses() {
        ArrayList<RemoteCSEEntity> toBeReturned = null;
        Map<String, RemoteCSEEntity> map = this.remoteCses;
        synchronized (map) {
            toBeReturned = new ArrayList<RemoteCSEEntity>(this.remoteCses.values());
        }
        return toBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCseAndPublish(RemoteCSEEntity toBeAdded) {
        LOGGER.info((Object)("addRemoteCseAndPublish(cseId=" + toBeAdded.getResourceID() + ", name=" + toBeAdded.getName() + ")"));
        Map<String, RemoteCSEEntity> map = this.remoteCses;
        synchronized (map) {
            this.remoteCses.put(toBeAdded.getName(), toBeAdded);
        }
        if (this.eventAdmin != null) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String cseId = toBeAdded.getRemoteCseId();
            if (cseId.startsWith("/")) {
                cseId = cseId.substring(1);
            }
            properties.put("remoteCseId", cseId);
            properties.put("remoteCseName", toBeAdded.getName());
            properties.put("operation", "add");
            properties.put("remoteCsePoa", toBeAdded.getPointOfAccess());
            Event event = new Event("org/eclipse/om2m/remoteCse", properties);
            this.eventAdmin.postEvent(event);
            LOGGER.info((Object)("post Event to inform about RemoteCSE creation (cseId=" + cseId + ", cseName=" + toBeAdded.getName() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteCseAndPublish(String cseName) {
        LOGGER.info((Object)("removeRemoteCseAndPublish(name=" + cseName + ")"));
        RemoteCSEEntity toBeRemoved = null;
        Map<String, RemoteCSEEntity> map = this.remoteCses;
        synchronized (map) {
            toBeRemoved = this.remoteCses.remove(cseName);
        }
        if (toBeRemoved != null && this.eventAdmin != null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("remoteCseId", toBeRemoved.getResourceID());
            properties.put("remoteCseName", toBeRemoved.getName());
            properties.put("operation", "remove");
            Event event = new Event("org/eclipse/om2m/remoteCse", properties);
            this.eventAdmin.postEvent(event);
            LOGGER.info((Object)("post Event to inform about RemoteCSE deletion (cseId=" + toBeRemoved.getRemoteCseId() + ", cseName=" + toBeRemoved.getName() + ")"));
        }
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }
}

