/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.dacis;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class DynamicAuthorizationConsultationDacisTest
extends Test {
    public DynamicAuthorizationConsultationDacisTest(CseService pCseService) {
        super("DynamicAuthorizationConsultation DACIs", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS();
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create DAC");
            return;
        }
        DynamicAuthorizationConsultation toBeCreatedDac = new DynamicAuthorizationConsultation();
        toBeCreatedDac.getDynamicAuthorizationConsultationIDs().add(dac.getResourceID());
        toBeCreatedDac.setDynamicAuthorizationEnabled(Boolean.FALSE);
        toBeCreatedDac.setName("DAC_" + UUID.randomUUID());
        RequestPrimitive createRequest = new RequestPrimitive();
        createRequest.setOperation(Operation.CREATE);
        createRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        createRequest.setTo("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        createRequest.setRequestContentType("application/obj");
        createRequest.setReturnContentType("application/obj");
        createRequest.setResourceType(34);
        createRequest.setContent((Object)toBeCreatedDac);
        ResponsePrimitive createResponse = this.getCseService().doRequest(createRequest);
        if (createResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create DynamicAuthorizationConsultation: expecting " + ResponseStatusCode.CREATED + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        DynamicAuthorizationConsultation createdDac = null;
        try {
            createdDac = (DynamicAuthorizationConsultation)createResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a DynamicAuthorizationConsultation");
            return;
        }
        if (!this.checkEquals(createdDac.getDynamicAuthorizationConsultationIDs(), toBeCreatedDac.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        ResponsePrimitive retrieveResponse = this.retrieveEntity(createdDac.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve DynamicAuthorizationConsultation: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        DynamicAuthorizationConsultation retrievedDac = null;
        try {
            retrievedDac = (DynamicAuthorizationConsultation)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a DynamicAuthorizationConsultation");
            return;
        }
        if (!this.checkEquals(retrievedDac.getDynamicAuthorizationConsultationIDs(), toBeCreatedDac.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setOperation(Operation.DELETE);
        deleteRequest.setTo(dac.getResourceID());
        deleteRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete DAC");
            return;
        }
        retrieveResponse = this.retrieveEntity(createdDac.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve DynamicAuthorizationConsultation: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        retrievedDac = null;
        try {
            retrievedDac = (DynamicAuthorizationConsultation)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a DynamicAuthorizationConsultation");
            return;
        }
        if (!this.checkEquals(retrievedDac.getDynamicAuthorizationConsultationIDs(), new ArrayList(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        this.setState(Test.State.OK);
    }
}

