/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.SwitchButton;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.modules.PushButton;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedSwitchButton
extends SwitchButton
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;
    private boolean running;
    private PushButton pushButton;
    private boolean pushed;

    public MockedSwitchButton(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.pushButton = new PushButton("pushButton_" + id, domain, new BooleanDataPoint((Identifiers)DatapointType.pushed){

            public Boolean doGetValue() throws DataPointException {
                return MockedSwitchButton.this.pushed;
            }
        });
        this.addModule(this.pushButton);
    }

    @Override
    public void registerDevice() {
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
        this.running = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("start thread " + MockedSwitchButton.this.pushButton);
                while (MockedSwitchButton.this.running) {
                    try {
                        Thread.sleep((int)(30000.0 + 5000.0 * Math.random()));
                        System.out.println("Generating Push Button event");
                        Event evt = new Event("PUSH");
                        MockedSwitchButton.this.pushed = !MockedSwitchButton.this.pushed;
                        evt.setValue((Object)MockedSwitchButton.this.pushed);
                        evt.addDataPoint(MockedSwitchButton.this.pushButton.getDataPointByShortName(DatapointType.pushed.getShortName()));
                        MockedSwitchButton.this.pushButton.addEvent(evt);
                    }
                    catch (Throwable e) {
                        System.out.println("Error generating event");
                        e.printStackTrace();
                        MockedSwitchButton.this.running = false;
                    }
                }
                System.out.println("stopped thread");
            }
        }).start();
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

