/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.modules;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.actions.DecrementNumberValue;
import org.eclipse.om2m.sdt.home.actions.IncrementNumberValue;
import org.eclipse.om2m.sdt.home.actions.ResetNumberValue;
import org.eclipse.om2m.sdt.home.modules.NumberValue;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class MockedNumberValue
extends NumberValue {
    private Thread t;

    public MockedNumberValue(String name, Domain domain) {
        super(name, domain, new FloatDataPoint((Identifiers)DatapointType.numberValue){
            private float innerValue = 0.0f;

            protected Float doGetValue() throws DataPointException {
                return Float.valueOf(this.innerValue);
            }

            protected void doSetValue(Float value) throws DataPointException {
                this.innerValue = value.floatValue();
            }
        });
        this.setDecrementNumberValue(new DecrementNumberValue("decrement"){

            protected void doDecrementNumberValue() throws ActionException {
                FloatDataPoint nv = (FloatDataPoint)MockedNumberValue.this.getDataPointByShortName(DatapointType.numberValue.getShortName());
                try {
                    nv.setValue((Object)Float.valueOf(((Float)nv.getValue()).floatValue() - 1.0f));
                }
                catch (DataPointException e) {
                    throw new ActionException((Throwable)e);
                }
                catch (AccessException e) {
                    throw new ActionException((Throwable)e);
                }
            }
        });
        this.setIncrementNumberValue(new IncrementNumberValue("increment"){

            protected void doIncrementNumberValue() throws ActionException {
                FloatDataPoint nv = (FloatDataPoint)MockedNumberValue.this.getDataPointByShortName(DatapointType.numberValue.getShortName());
                try {
                    nv.setValue((Object)Float.valueOf(((Float)nv.getValue()).floatValue() + 1.0f));
                }
                catch (DataPointException e) {
                    throw new ActionException((Throwable)e);
                }
                catch (AccessException e) {
                    throw new ActionException((Throwable)e);
                }
            }
        });
        this.resetNumberValue(new ResetNumberValue("reset"){

            protected void doResetNumberValue() throws ActionException {
                FloatDataPoint nv = (FloatDataPoint)MockedNumberValue.this.getDataPointByShortName(DatapointType.numberValue.getShortName());
                try {
                    nv.setValue((Object)Float.valueOf(0.0f));
                }
                catch (DataPointException e) {
                    throw new ActionException((Throwable)e);
                }
                catch (AccessException e) {
                    throw new ActionException((Throwable)e);
                }
            }
        });
    }
}

