/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.datapoints;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.ValuedDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.types.DataType;

public abstract class AbstractDateDataPoint
extends ValuedDataPoint<Date> {
    private static final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance();
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private static final DateFormat timeFormat = DateFormat.getTimeInstance();
    private DateFormat df;

    protected AbstractDateDataPoint(Identifiers name, DataType type) {
        super(name, type);
        if (type.equals(DataType.Date)) {
            this.df = dateFormat;
        } else if (type.equals(DataType.Datetime)) {
            this.df = dateTimeFormat;
        } else if (type.equals(DataType.Time)) {
            this.df = timeFormat;
        }
    }

    @Override
    public void setValue(String v) throws DataPointException, AccessException {
        try {
            this.setValue(this.df.parse(v));
        }
        catch (ParseException e) {
            throw new DataPointException("Incorrect value", e);
        }
    }

    @Override
    public void setValue(long value) throws DataPointException, AccessException {
        this.setValue(new Date(value));
    }

    public String getStringValue() throws DataPointException, AccessException {
        return this.df.format((Date)this.getValue());
    }
}

