/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.util;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.obix.Bool;
import org.eclipse.om2m.commons.obix.Contract;
import org.eclipse.om2m.commons.obix.Obj;
import org.eclipse.om2m.commons.obix.Op;
import org.eclipse.om2m.commons.obix.Str;
import org.eclipse.om2m.commons.obix.Uri;
import org.eclipse.om2m.commons.obix.io.ObixEncoder;
import org.eclipse.om2m.ipe.sample.constants.Operations;
import org.eclipse.om2m.ipe.sample.constants.SampleConstants;

public class ObixUtil {
    public static String getDescriptorRep(String cseId, String appId, String stateCont) {
        String prefix = String.valueOf(cseId) + "/" + Constants.CSE_NAME + "/" + appId;
        Obj obj = new Obj();
        obj.add((Object)new Str("type", "LAMP"));
        obj.add((Object)new Str("location", "Home"));
        obj.add((Object)new Str("appId", appId));
        Op opState = new Op();
        opState.setName("getState");
        opState.setHref(new Uri(String.valueOf(prefix) + "/" + stateCont + "/" + "la"));
        opState.setIs(new Contract("retrieve"));
        opState.setIn(new Contract("obix:Nil"));
        opState.setOut(new Contract("obix:Nil"));
        obj.add((Object)opState);
        Op opStateDirect = new Op();
        opStateDirect.setName("getState(Direct)");
        opStateDirect.setHref(new Uri(String.valueOf(prefix) + "?op=" + (Object)((Object)Operations.GET_STATE_DIRECT) + "&lampid=" + appId));
        opStateDirect.setIs(new Contract("execute"));
        opStateDirect.setIn(new Contract("obix:Nil"));
        opStateDirect.setOut(new Contract("obix:Nil"));
        obj.add((Object)opStateDirect);
        Op opON = new Op();
        opON.setName("switchON");
        opON.setHref(new Uri(String.valueOf(prefix) + "?op=" + (Object)((Object)Operations.SET_ON) + "&lampid=" + appId));
        opON.setIs(new Contract("execute"));
        opON.setIn(new Contract("obix:Nil"));
        opON.setOut(new Contract("obix:Nil"));
        obj.add((Object)opON);
        Op opOFF = new Op();
        opOFF.setName("switchOFF");
        opOFF.setHref(new Uri(String.valueOf(prefix) + "?op=" + (Object)((Object)Operations.SET_OFF) + "&lampid=" + appId));
        opOFF.setIs(new Contract("execute"));
        opOFF.setIn(new Contract("obix:Nil"));
        opOFF.setOut(new Contract("obix:Nil"));
        obj.add((Object)opOFF);
        Op opToggle = new Op();
        opToggle.setName("toggle");
        opToggle.setHref(new Uri(String.valueOf(prefix) + "?op=" + (Object)((Object)Operations.TOGGLE) + "&lampid=" + appId));
        opToggle.setIs(new Contract("execute"));
        opToggle.setIn(new Contract("obix:Nil"));
        opToggle.setOut(new Contract("obix:Nil"));
        obj.add((Object)opToggle);
        return ObixEncoder.toString((Obj)obj);
    }

    public static String getStateRep(String lampId, boolean value) {
        Obj obj = new Obj();
        obj.add((Object)new Str("type", "LAMP"));
        obj.add((Object)new Str("location", "Home"));
        obj.add((Object)new Str("lampId", lampId));
        obj.add((Object)new Bool("state", value));
        return ObixEncoder.toString((Obj)obj);
    }

    public static String createLampAllDescriptor() {
        String prefix = String.valueOf(SampleConstants.CSE_ID) + "/" + Constants.CSE_NAME + "/" + "LAMP_ALL";
        Obj descriptor = new Obj();
        Op opSwitchOn = new Op();
        opSwitchOn.setName(Operations.SET_ON.toString());
        opSwitchOn.setHref(String.valueOf(prefix) + "?op=" + (Object)((Object)Operations.ALL_ON));
        opSwitchOn.setIs(new Contract("execute"));
        descriptor.add((Object)opSwitchOn);
        Op opSwitchOff = new Op();
        opSwitchOff.setName(Operations.SET_OFF.toString());
        opSwitchOff.setHref(String.valueOf(prefix) + "?op=" + (Object)((Object)Operations.ALL_OFF));
        opSwitchOff.setIs(new Contract("execute"));
        descriptor.add((Object)opSwitchOff);
        Op opToggleAll = new Op();
        opToggleAll.setName(Operations.ALL_TOGGLE.toString());
        opToggleAll.setHref(String.valueOf(prefix) + "?op=" + (Object)((Object)Operations.ALL_TOGGLE));
        opToggleAll.setIs(new Contract("execute"));
        descriptor.add((Object)opToggleAll);
        return ObixEncoder.toString((Obj)descriptor);
    }
}

