/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.ColourFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.exception.FlexContainerNotFound;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class ColourModuleTest
extends AbstractModuleTest {
    public ColourModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
        Device device = this.getModule().getOwner();
        String binarySwitchModuleName = null;
        for (String moduleName : device.getModuleNames()) {
            if (!moduleName.toLowerCase().contains(ModuleType.binarySwitch.getShortName())) continue;
            binarySwitchModuleName = moduleName;
            break;
        }
        if (binarySwitchModuleName != null) {
            BooleanDataPoint powerStateDP = (BooleanDataPoint)this.getModule().getOwner().getModule(binarySwitchModuleName).getDataPoint(DatapointType.powerState.getShortName());
            try {
                powerStateDP.setValue((Object)Boolean.TRUE);
            }
            catch (AccessException | DataPointException throwable) {}
        }
    }

    public TestReport test() {
        TestReport report = new TestReport("Test module " + this.getModule().getName());
        String moduleUrl = null;
        try {
            moduleUrl = this.getModuleFlexContainerUrl();
        }
        catch (FlexContainerNotFound flexContainerNotFound) {
            report.setErrorMessage("unable to find out the FlexContainer of module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer :" + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        ColourFlexContainer retrievedFlexContainer = (ColourFlexContainer)response.getContent();
        CustomAttribute redCA = retrievedFlexContainer.getCustomAttribute(DatapointType.red.getShortName());
        CustomAttribute greenCA = retrievedFlexContainer.getCustomAttribute(DatapointType.green.getShortName());
        CustomAttribute blueCA = retrievedFlexContainer.getCustomAttribute(DatapointType.blue.getShortName());
        Integer redValueFromFlexContainer = Integer.valueOf(redCA.getCustomAttributeValue());
        Integer greenValueFromFlexContainer = Integer.valueOf(greenCA.getCustomAttributeValue());
        Integer blueValueFromFlexContainer = Integer.valueOf(blueCA.getCustomAttributeValue());
        IntegerDataPoint redDP = (IntegerDataPoint)this.getModule().getDataPoint(DatapointType.red.getShortName());
        IntegerDataPoint greenDP = (IntegerDataPoint)this.getModule().getDataPoint(DatapointType.green.getShortName());
        IntegerDataPoint blueDP = (IntegerDataPoint)this.getModule().getDataPoint(DatapointType.blue.getShortName());
        Integer redValueFromDP = null;
        Integer greenValueFromDP = null;
        Integer blueValueFromDP = null;
        try {
            redValueFromDP = (Integer)redDP.getValue();
            greenValueFromDP = (Integer)greenDP.getValue();
            blueValueFromDP = (Integer)blueDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve value from DataPoint:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!redValueFromDP.equals(redValueFromFlexContainer)) {
            report.setErrorMessage("red value from FlexContainer (" + redValueFromFlexContainer + ") is different of the value from red datapoint (" + redValueFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!greenValueFromDP.equals(greenValueFromFlexContainer)) {
            report.setErrorMessage("green value from FlexContainer (" + greenValueFromFlexContainer + ") is different of the value from green datapoint (" + greenValueFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!blueValueFromDP.equals(blueValueFromFlexContainer)) {
            report.setErrorMessage("blue value from FlexContainer (" + blueValueFromFlexContainer + ") is different of the value from blue datapoint (" + blueValueFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        Integer newRedValue = (int)(Math.random() * 255.0);
        Integer newGreenValue = (int)(Math.random() * 255.0);
        Integer newBlueValue = (int)(Math.random() * 255.0);
        ColourFlexContainer toBeUpdated = new ColourFlexContainer();
        redCA.setCustomAttributeValue(newRedValue.toString());
        greenCA.setCustomAttributeValue(newGreenValue.toString());
        blueCA.setCustomAttributeValue(newBlueValue.toString());
        toBeUpdated.getCustomAttributes().add(redCA);
        toBeUpdated.getCustomAttributes().add(greenCA);
        toBeUpdated.getCustomAttributes().add(blueCA);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to set red/green/blue customAttribute:" + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        try {
            redValueFromDP = (Integer)redDP.getValue();
            greenValueFromDP = (Integer)greenDP.getValue();
            blueValueFromDP = (Integer)blueDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve value from DataPoint:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (Math.abs(newRedValue - redValueFromDP) > 2) {
            report.setErrorMessage("new red value (" + newRedValue + ") is different of the value from red datapoint (" + redValueFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (Math.abs(newGreenValue - greenValueFromDP) > 2) {
            report.setErrorMessage("new green value (" + newGreenValue + ") is different of the value from green datapoint (" + greenValueFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (Math.abs(newBlueValue - blueValueFromDP) > 2) {
            report.setErrorMessage("new blue value (" + newBlueValue + ") is different of the value from blue datapoint (" + blueValueFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer :" + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        retrievedFlexContainer = (ColourFlexContainer)response.getContent();
        redCA = retrievedFlexContainer.getCustomAttribute(DatapointType.red.getShortName());
        greenCA = retrievedFlexContainer.getCustomAttribute(DatapointType.green.getShortName());
        blueCA = retrievedFlexContainer.getCustomAttribute(DatapointType.blue.getShortName());
        redValueFromFlexContainer = Integer.valueOf(redCA.getCustomAttributeValue());
        greenValueFromFlexContainer = Integer.valueOf(greenCA.getCustomAttributeValue());
        blueValueFromFlexContainer = Integer.valueOf(blueCA.getCustomAttributeValue());
        if (Math.abs(newRedValue - redValueFromFlexContainer) > 2) {
            report.setErrorMessage("new red value (" + newRedValue + ") is different of the value from red customAttribute (" + redValueFromFlexContainer + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (Math.abs(newGreenValue - greenValueFromFlexContainer) > 2) {
            report.setErrorMessage("new green value (" + newGreenValue + ") is different of the value from green customAttribute (" + greenValueFromFlexContainer + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (Math.abs(newBlueValue - blueValueFromFlexContainer) > 2) {
            report.setErrorMessage("new blue value (" + newBlueValue + ") is different of the value from blue customAttribute (" + blueValueFromFlexContainer + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }
}

