/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.SmokeSensorFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.exception.FlexContainerNotFound;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class SmokeSensorModuleTest
extends AbstractModuleTest {
    public SmokeSensorModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
    }

    public TestReport test() {
        TestReport report = new TestReport("Test for module " + this.getModule().getName());
        String moduleUrl = null;
        try {
            moduleUrl = this.getModuleFlexContainerUrl();
        }
        catch (FlexContainerNotFound flexContainerNotFound) {
            report.setErrorMessage("no FlexContainer for module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer for module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        SmokeSensorFlexContainer retrievedFlexContainer = (SmokeSensorFlexContainer)response.getContent();
        CustomAttribute alarmCA = retrievedFlexContainer.getCustomAttribute(DatapointType.alarm.getShortName());
        if (alarmCA == null) {
            report.setErrorMessage("ERROR : no alarm customAttribute");
            report.setState(TestReport.State.KO);
            return report;
        }
        Boolean alarm = Boolean.parseBoolean(alarmCA.getCustomAttributeValue());
        BooleanDataPoint alarmDP = (BooleanDataPoint)this.getModule().getDataPoint(DatapointType.alarm.getShortName());
        Boolean currentValueFromModule = null;
        try {
            currentValueFromModule = (Boolean)alarmDP.getValue();
        }
        catch (AccessException | DataPointException throwable) {
            report.setErrorMessage("unable to get alarm DP value from module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!alarm.equals(currentValueFromModule)) {
            report.setErrorMessage("invalid value between flexContainer(" + alarm + ") and module (" + currentValueFromModule + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        SmokeSensorFlexContainer toBeUpdated = new SmokeSensorFlexContainer();
        alarmCA.setCustomAttributeValue("true");
        toBeUpdated.getCustomAttributes().add(alarmCA);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("we should not be able to set alarm datapoint value from module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer for module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        retrievedFlexContainer = (SmokeSensorFlexContainer)response.getContent();
        CustomAttribute detectedTimeCA = retrievedFlexContainer.getCustomAttribute(DatapointType.detectedTime.getShortName());
        if (detectedTimeCA != null) {
            Integer detectedTime = new Integer(detectedTimeCA.getCustomAttributeValue());
            IntegerDataPoint detectedTimeDP = (IntegerDataPoint)this.getModule().getDataPoint(DatapointType.detectedTime.getShortName());
            Integer detectedTimeFromModule = null;
            try {
                detectedTimeFromModule = (Integer)detectedTimeDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve detectedTime datapoint value :" + e.getMessage());
                report.setState(TestReport.State.KO);
                return report;
            }
            if (detectedTime == null) {
                if (detectedTimeFromModule != null) {
                    report.setErrorMessage("expected non null detected time");
                    report.setState(TestReport.State.KO);
                    return report;
                }
            } else if (!detectedTime.equals(detectedTimeFromModule)) {
                report.setErrorMessage("detectedTime from IPE(" + detectedTime + ") is different of detectedTime from module (" + detectedTimeFromModule + ")");
                report.setState(TestReport.State.KO);
                return report;
            }
        }
        System.out.println("test module " + this.getModule().getName() + " __________________ OK ___________________________");
        report.setState(TestReport.State.OK);
        return report;
    }
}

