/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.SmartElectricMeter;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedBinarySwitch;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedClock;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedEnergyConsumption;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedEnergyGeneration;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedFaultDetection;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedRunMode;
import org.eclipse.om2m.sdt.home.modules.EnergyConsumption;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedSmartElectricMeter
extends SmartElectricMeter
implements MockedDevice {
    private boolean running;
    private float power = 0.0f;
    private List<ServiceRegistration> serviceRegistrations;
    private EnergyConsumption energyConsumption;

    public MockedSmartElectricMeter(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.addModule(new MockedBinarySwitch("binarySwitch_" + id, domain));
        this.energyConsumption = new MockedEnergyConsumption("energyConsumption_" + id, domain, new FloatDataPoint((Identifiers)DatapointType.power){

            public Float doGetValue() throws DataPointException {
                return Float.valueOf(MockedSmartElectricMeter.this.power);
            }
        });
        this.addModule(this.energyConsumption);
        this.addModule(new MockedFaultDetection("faultDetection_" + id, domain));
        this.addModule(new MockedClock("clock_" + id, domain));
        this.addModule(new MockedRunMode("runMode_" + id, domain));
        this.addModule(new MockedEnergyGeneration("energyGeneration_" + id, domain));
    }

    @Override
    public void registerDevice() {
        this.running = true;
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (MockedSmartElectricMeter.this.running) {
                    try {
                        Thread.sleep((long)(30000.0 * (1.0 + Math.random())));
                        Activator.logger.info("Generating Power event");
                        MockedSmartElectricMeter.this.power = (float)(100.0 * Math.random());
                        DataPoint dp = MockedSmartElectricMeter.this.energyConsumption.getDataPoint("power");
                        Event evt = new Event("power change");
                        evt.addDataPoint(dp);
                        evt.setValue((Object)Float.valueOf(MockedSmartElectricMeter.this.power));
                        MockedSmartElectricMeter.this.energyConsumption.addEvent(evt);
                    }
                    catch (Throwable e) {
                        Activator.logger.warning("Error generating event", e);
                    }
                }
            }
        }).start();
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

