/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.LocationCatalog;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.SetupUtil;
import org.eclipse.oomph.setup.util.OS;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.service.datalocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupContext {
    public static final String OOMPH_NODE = "org.eclipse.oomph.setup";
    public static final String LOG_FILE_NAME = "setup.log";
    public static final String USER_SCHEME = "user";
    public static final URI CONFIGURATION_LOCATION_URI = SetupContext.getStaticConfigurationLocation();
    public static final URI WORKSPACE_LOCATION_URI = CommonPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? WorkspaceUtil.access$0() : null;
    public static final URI PRODUCT_LOCATION = SetupContext.getStaticInstallLocation();
    public static final URI PRODUCT_ROOT_LOCATION = PRODUCT_LOCATION.trimSegments(1);
    public static final URI GLOBAL_STATE_LOCATION_URI = URI.createFileURI((String)PropertiesUtil.USER_HOME).appendSegments(new String[]{".eclipse", "org.eclipse.oomph.setup"});
    public static final URI GLOBAL_SETUPS_URI = URI.createURI((String)"user:/");
    public static final URI GLOBAL_SETUPS_LOCATION_URI = GLOBAL_STATE_LOCATION_URI.appendSegment("setups");
    public static final URI CONFIGURATION_STATE_LOCATION_URI = CONFIGURATION_LOCATION_URI.appendSegment("org.eclipse.oomph.setup");
    public static final URI WORKSPACE_STATE_LOCATION_URI = WORKSPACE_LOCATION_URI == null ? null : WORKSPACE_LOCATION_URI.appendSegments(new String[]{".metadata", ".plugins", "org.eclipse.oomph.setup"});
    public static final URI SETUP_LOG_URI = CONFIGURATION_STATE_LOCATION_URI.appendSegment("setup.log");
    public static final URI INDEX_SETUP_URI = URI.createURI((String)"index:/org.eclipse.setup");
    public static final URI INDEX_SETUP_LOCATION_URI = URI.createURI((String)"http://git.eclipse.org/c/oomph/org.eclipse.oomph.git/plain/setups/org.eclipse.setup");
    public static final URI INSTALLATION_SETUP_FILE_NAME_URI = URI.createURI((String)"installation.setup");
    public static final URI INSTALLATION_SETUP_URI = CONFIGURATION_STATE_LOCATION_URI.appendSegment(INSTALLATION_SETUP_FILE_NAME_URI.lastSegment());
    public static final URI WORKSPACE_SETUP_FILE_NAME_URI = URI.createURI((String)"workspace.setup");
    public static final URI WORKSPACE_SETUP_URI = WORKSPACE_STATE_LOCATION_URI == null ? null : WORKSPACE_STATE_LOCATION_URI.appendSegment(WORKSPACE_SETUP_FILE_NAME_URI.lastSegment());
    public static final URI WORKSPACE_SETUP_RELATIVE_URI = URI.createHierarchicalURI((String[])new String[]{".metadata", ".plugins", "org.eclipse.oomph.setup", WORKSPACE_SETUP_FILE_NAME_URI.lastSegment()}, null, null);
    public static final URI USER_SETUP_URI = GLOBAL_SETUPS_URI.appendSegment("user.setup");
    public static final URI USER_SETUP_LOCATION_URI = GLOBAL_SETUPS_LOCATION_URI.appendSegment("user.setup");
    public static final URI CATALOG_SELECTION_SETUP_URI = GLOBAL_SETUPS_URI.appendSegment("catalogs.setup");
    public static final URI CATALOG_SELECTION_SETUP_LOCATION_URI = GLOBAL_SETUPS_LOCATION_URI.appendSegment("catalogs.setup");
    public static final URI LOCATION_CATALOG_SETUP_URI = GLOBAL_SETUPS_URI.appendSegment("locations.setup");
    private static volatile SetupContext self = new SetupContext();
    private final Installation installation;
    private final Workspace workspace;
    private final User user;

    public static URI resolveUser(URI uri) {
        if (USER_SCHEME.equals(uri.scheme())) {
            return GLOBAL_SETUPS_LOCATION_URI.appendSegments(uri.segments());
        }
        return uri;
    }

    private SetupContext() {
        this.installation = SetupContext.createInstallation();
        ((InternalEObject)this.installation).eSetProxyURI(INSTALLATION_SETUP_URI.appendFragment("/"));
        this.workspace = SetupContext.createWorkspace();
        if (WORKSPACE_SETUP_URI != null) {
            ((InternalEObject)this.workspace).eSetProxyURI(WORKSPACE_SETUP_URI.appendFragment("/"));
        }
        this.user = SetupContext.createUser();
        ((InternalEObject)this.user).eSetProxyURI(USER_SETUP_URI.appendFragment("/"));
    }

    private SetupContext(Installation installation, Workspace workspace, User user) {
        this.installation = installation;
        this.workspace = workspace;
        this.user = user;
    }

    public Installation getInstallation() {
        return this.installation;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public User getUser() {
        return this.user;
    }

    public static SetupContext getSelf() {
        return self;
    }

    public static void setSelf(SetupContext setupContext) {
        self = setupContext;
    }

    public static SetupContext createSelf(Installation installation, Workspace workspace, User user) {
        return SetupContext.proxify(installation, workspace, user);
    }

    public static SetupContext createSelf(ResourceSet resourceSet) {
        Installation installation = SetupContext.getInstallation(resourceSet, true, Mode.CREATE_AND_SAVE);
        Workspace workspace = SetupContext.getWorkspace(resourceSet, true, Mode.CREATE_AND_SAVE);
        Installation effectiveInstallation = null;
        URI uri = installation.eResource().getURI();
        if (uri.segmentCount() > 3) {
            URI executable = uri.trimSegments(3).appendSegments(URI.createURI((String)OS.INSTANCE.getEclipseExecutable()).segments());
            if (resourceSet.getURIConverter().exists(executable, null)) {
                effectiveInstallation = installation;
            }
        }
        SetupContext.associate(effectiveInstallation, workspace);
        User user = SetupContext.getUser(resourceSet, false);
        return SetupContext.createSelf(installation, workspace, user);
    }

    public static SetupContext createInstallationAndUser(ResourceSet resourceSet) {
        return new SetupContext(SetupContext.getInstallation(resourceSet, true, Mode.CREATE), null, SetupContext.getUser(resourceSet, true));
    }

    public static SetupContext create(ResourceSet resourceSet) {
        return new SetupContext(SetupContext.getInstallation(resourceSet, true, Mode.CREATE), SetupContext.getWorkspace(resourceSet, true, Mode.CREATE), SetupContext.getUser(resourceSet, true));
    }

    public static SetupContext createUserOnly(ResourceSet resourceSet) {
        return new SetupContext(null, null, SetupContext.getUser(resourceSet, true));
    }

    public static SetupContext create(ResourceSet resourceSet, ProductVersion productVersion) {
        Installation installation = SetupContext.getInstallation(resourceSet, false, Mode.CREATE);
        installation.setProductVersion(productVersion);
        return new SetupContext(installation, SetupContext.getWorkspace(resourceSet, false, Mode.NONE), SetupContext.getUser(resourceSet, true));
    }

    public static SetupContext create(ProductVersion productVersion, Stream stream) {
        User user = SetupContext.createUser();
        Workspace workspace = SetupContext.createWorkspace();
        workspace.getStreams().add((Object)stream);
        Installation installation = SetupContext.createInstallation();
        installation.setProductVersion(productVersion);
        return new SetupContext(installation, workspace, user);
    }

    public static SetupContext create(Installation installation, Collection<? extends Stream> streams, User user) {
        Workspace workspace = SetupContext.createWorkspace();
        workspace.getStreams().addAll(streams);
        Resource workspaceResource = installation.eResource().getResourceSet().createResource(WORKSPACE_SETUP_FILE_NAME_URI);
        workspaceResource.getContents().add((Object)workspace);
        return new SetupContext(installation, workspace, user);
    }

    public static SetupContext create() {
        return new SetupContext();
    }

    public static SetupContext create(Installation installation, Workspace workspace, User user) {
        return new SetupContext(installation, workspace, user);
    }

    public static SetupContext create(Installation installation, Workspace workspace) {
        User user = SetupContext.createUser();
        Resource userResource = installation.eResource().getResourceSet().getResourceFactoryRegistry().getFactory(USER_SETUP_URI).createResource(USER_SETUP_URI);
        userResource.getContents().add((Object)user);
        return new SetupContext(installation, workspace, user);
    }

    public static SetupContext createCopy(Installation installation, Workspace workspace, User user) {
        Resource.Factory.Registry resourceFactoryRegistry = SetupUtil.createResourceSet().getResourceFactoryRegistry();
        Installation copiedInstallation = (Installation)EcoreUtil.copy((EObject)installation);
        Resource installationResource = resourceFactoryRegistry.getFactory(INSTALLATION_SETUP_FILE_NAME_URI).createResource(INSTALLATION_SETUP_FILE_NAME_URI);
        installationResource.getContents().add((Object)copiedInstallation);
        Workspace copiedWorkspace = (Workspace)EcoreUtil.copy((EObject)workspace);
        if (workspace != null) {
            Resource workResource = resourceFactoryRegistry.getFactory(WORKSPACE_SETUP_FILE_NAME_URI).createResource(WORKSPACE_SETUP_FILE_NAME_URI);
            workResource.getContents().add((Object)copiedWorkspace);
        }
        User copiedUser = (User)EcoreUtil.copy((EObject)user);
        Resource userResource = resourceFactoryRegistry.getFactory(USER_SETUP_URI).createResource(USER_SETUP_URI);
        userResource.getContents().add((Object)copiedUser);
        return new SetupContext(copiedInstallation, copiedWorkspace, copiedUser);
    }

    public static User createUser() {
        User user = SetupFactory.eINSTANCE.createUser();
        user.setName(PropertiesUtil.getProperty((String)"user.name", (String)USER_SCHEME));
        return user;
    }

    public static Workspace createWorkspace() {
        Workspace workspace = SetupFactory.eINSTANCE.createWorkspace();
        workspace.setName("workspace");
        return workspace;
    }

    public static Installation createInstallation() {
        Installation installation = SetupFactory.eINSTANCE.createInstallation();
        installation.setName("installation");
        return installation;
    }

    public static void associate(final Installation installation, final Workspace workspace) {
        final ResourceSet resourceSet = SetupUtil.createResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        BaseUtil.execute((long)5000L, (Runnable)new Runnable(){

            public void run() {
                SetupContext.associate(resourceSet, installation, workspace);
            }
        }, (URIConverter)uriConverter, (URI[])new URI[]{LOCATION_CATALOG_SETUP_URI, installation == null ? null : installation.eResource().getURI(), workspace == null ? null : workspace.eResource().getURI()});
    }

    private static void associate(ResourceSet resourceSet, Installation installation, Workspace workspace) {
        int position;
        Workspace localWorkspace;
        URIConverter uriConverter = resourceSet.getURIConverter();
        Object resource = uriConverter.exists(LOCATION_CATALOG_SETUP_URI, null) ? BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)LOCATION_CATALOG_SETUP_URI) : resourceSet.createResource(LOCATION_CATALOG_SETUP_URI);
        EList contents = resource.getContents();
        LocationCatalog locationCatalog = (LocationCatalog)EcoreUtil.getObjectByType((Collection)contents, (EClassifier)SetupPackage.Literals.LOCATION_CATALOG);
        if (locationCatalog == null) {
            locationCatalog = SetupFactory.eINSTANCE.createLocationCatalog();
            contents.add((Object)locationCatalog);
        }
        EMap installations = locationCatalog.getInstallations();
        SetupContext.removeProxies(installations);
        EMap workspaces = locationCatalog.getWorkspaces();
        SetupContext.removeProxies(workspaces);
        Installation localInstallation = installation == null ? null : (Installation)resourceSet.getEObject(EcoreUtil.getURI((EObject)installation), true);
        Workspace workspace2 = localWorkspace = workspace == null ? null : (Workspace)resourceSet.getEObject(EcoreUtil.getURI((EObject)workspace), true);
        if (installation != null) {
            int installationEntryIndex = installations.indexOfKey((Object)localInstallation);
            if (installationEntryIndex == -1) {
                installations.put((Object)localInstallation, (Object)(localWorkspace == null ? ECollections.emptyEList() : ECollections.singletonEList((Object)localWorkspace)));
                installations.move(0, installations.size() - 1);
            } else if (localWorkspace != null) {
                EList associatedWorkspaces = (EList)((Map.Entry)installations.get(installationEntryIndex)).getValue();
                position = associatedWorkspaces.indexOf((Object)localWorkspace);
                if (position == -1) {
                    associatedWorkspaces.add(0, (Object)localWorkspace);
                } else {
                    associatedWorkspaces.move(0, position);
                }
                installations.move(0, installationEntryIndex);
            }
        }
        if (localWorkspace != null) {
            int workspaceEntryIndex = workspaces.indexOfKey((Object)localWorkspace);
            if (workspaceEntryIndex == -1) {
                workspaces.put((Object)localWorkspace, (Object)(localInstallation == null ? ECollections.emptyEList() : ECollections.singletonEList((Object)localInstallation)));
                workspaces.move(0, workspaces.size() - 1);
            } else if (localInstallation != null) {
                EList associatedInstallations = (EList)((Map.Entry)workspaces.get(workspaceEntryIndex)).getValue();
                position = associatedInstallations.indexOf((Object)localInstallation);
                if (position == -1) {
                    associatedInstallations.add(0, (Object)localInstallation);
                } else {
                    associatedInstallations.move(0, position);
                }
                workspaces.move(0, workspaceEntryIndex);
            }
        }
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            SetupCorePlugin.INSTANCE.log(ex);
        }
    }

    private static <K extends EObject, V extends EObject> void removeProxies(EMap<K, EList<V>> map) {
        Iterator it = map.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            EObject key = (EObject)entry.getKey();
            if (key == null || key.eIsProxy()) {
                it.remove();
                continue;
            }
            Iterator it2 = ((EList)entry.getValue()).iterator();
            while (it2.hasNext()) {
                EObject value = (EObject)it2.next();
                if (!value.eIsProxy()) continue;
                it2.remove();
            }
        }
    }

    private static URI getStaticInstallLocation() {
        try {
            if (!Platform.isRunning()) {
                return URI.createFileURI((String)File.createTempFile("installation", "").toString());
            }
            Location location = Platform.getInstallLocation();
            URI result = URI.createURI((String)FileLocator.resolve((URL)location.getURL()).toString());
            return result.hasTrailingPathSeparator() ? result.trimSegments(1) : result;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static URI getStaticConfigurationLocation() {
        try {
            if (!Platform.isRunning()) {
                return URI.createFileURI((String)File.createTempFile("configuration", "").toString());
            }
            Location location = Platform.getConfigurationLocation();
            URI result = URI.createURI((String)FileLocator.resolve((URL)location.getURL()).toString());
            return result.hasTrailingPathSeparator() ? result.trimSegments(1) : result;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private static Installation getInstallation(ResourceSet resourceSet, boolean realInstallation, Mode mode) {
        Installation installation = null;
        Resource installationResource = null;
        if (realInstallation) {
            if (resourceSet.getURIConverter().exists(INSTALLATION_SETUP_URI, null)) {
                installationResource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)INSTALLATION_SETUP_URI);
                installation = (Installation)EcoreUtil.getObjectByType((Collection)installationResource.getContents(), (EClassifier)SetupPackage.Literals.INSTALLATION);
            }
        } else {
            installationResource = resourceSet.getResource(INSTALLATION_SETUP_FILE_NAME_URI, false);
            if (installationResource != null) {
                installation = (Installation)installationResource.getContents().get(0);
            }
        }
        boolean save = false;
        if (installation == null && mode != Mode.NONE) {
            if (installationResource == null) {
                installationResource = resourceSet.createResource(realInstallation ? INSTALLATION_SETUP_URI : INSTALLATION_SETUP_FILE_NAME_URI);
            } else {
                installationResource.unload();
            }
            installation = SetupContext.createInstallation();
            installationResource.getContents().add((Object)installation);
            boolean bl = save = mode == Mode.CREATE_AND_SAVE;
        }
        if (realInstallation && installation != null && installation.getProductVersion() == null) {
            BaseResource indexResource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)INDEX_SETUP_URI);
            Index index = (Index)EcoreUtil.getObjectByType((Collection)indexResource.getContents(), (EClassifier)SetupPackage.Literals.INDEX);
            if (index == null) {
                return null;
            }
            EList productCatalogs = index.getProductCatalogs();
            if (productCatalogs.isEmpty()) {
                return null;
            }
            ProductCatalog productCatalog = (ProductCatalog)productCatalogs.get(0);
            EList products = productCatalog.getProducts();
            if (products.isEmpty()) {
                return null;
            }
            Product product = (Product)products.get(0);
            EList versions = product.getVersions();
            if (versions.isEmpty()) {
                return null;
            }
            installation.setProductVersion((ProductVersion)versions.get(0));
            if (save) {
                BaseUtil.saveEObject((EObject)installation);
            }
        }
        return installation;
    }

    private static Workspace getWorkspace(ResourceSet resourceSet, boolean realWorkspace, Mode mode) {
        Resource workspaceResource = null;
        Workspace workspace = null;
        if (realWorkspace) {
            if (resourceSet.getURIConverter().exists(WORKSPACE_SETUP_URI, null)) {
                workspaceResource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)WORKSPACE_SETUP_URI);
                workspace = (Workspace)EcoreUtil.getObjectByType((Collection)workspaceResource.getContents(), (EClassifier)SetupPackage.Literals.WORKSPACE);
            }
        } else {
            workspaceResource = resourceSet.getResource(WORKSPACE_SETUP_FILE_NAME_URI, false);
            if (workspaceResource != null) {
                workspace = (Workspace)workspaceResource.getContents().get(0);
            }
        }
        if (workspace == null && mode != Mode.NONE) {
            if (workspaceResource == null) {
                workspaceResource = resourceSet.createResource(realWorkspace ? WORKSPACE_SETUP_URI : WORKSPACE_SETUP_FILE_NAME_URI);
            } else {
                workspaceResource.unload();
            }
            workspace = SetupContext.createWorkspace();
            workspaceResource.getContents().add((Object)workspace);
            if (mode == Mode.CREATE_AND_SAVE) {
                BaseUtil.saveEObject((EObject)workspace);
            }
        }
        return workspace;
    }

    private static User getUser(ResourceSet resourceSet, boolean demandCreate) {
        BaseResource userResource = null;
        User user = null;
        if (resourceSet.getURIConverter().exists(USER_SETUP_URI, null)) {
            userResource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)USER_SETUP_URI);
            user = (User)EcoreUtil.getObjectByType((Collection)userResource.getContents(), (EClassifier)SetupPackage.Literals.USER);
        }
        if (user == null && demandCreate) {
            if (userResource == null) {
                userResource = resourceSet.createResource(USER_SETUP_URI);
            } else {
                userResource.unload();
            }
            user = SetupContext.createUser();
            userResource.getContents().add((Object)user);
            try {
                userResource.save(null);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        return user;
    }

    private static SetupContext proxify(Installation installation, Workspace workspace, User user) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false, false){
            private static final long serialVersionUID = 1L;

            protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            }

            protected void copyProxyURI(EObject eObject, EObject copyEObject) {
                ((InternalEObject)copyEObject).eSetProxyURI(EcoreUtil.getURI((EObject)eObject));
            }
        };
        Installation installationCopy = (Installation)copier.copy((EObject)installation);
        if (installation != null) {
            copier.copy((EObject)installation.getProductVersion());
        }
        Workspace workspaceCopy = (Workspace)copier.copy((EObject)workspace);
        if (workspace != null) {
            copier.copyAll((Collection)workspace.getStreams());
        }
        User userCopy = (User)copier.copy((EObject)user);
        for (Map.Entry entry : new LinkedHashSet(copier.entrySet())) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            EObject eContainer = eObject.eContainer();
            while (eContainer != null) {
                EObject copyEContainer = (EObject)copier.get((Object)eContainer);
                if (copyEContainer == null) {
                    copyEContainer = copier.copy(eContainer);
                }
                InternalEList list = (InternalEList)copyEContainer.eGet((EStructuralFeature)eObject.eContainmentFeature());
                list.addUnique((Object)copyEObject);
                eObject = eContainer;
                copyEObject = copyEContainer;
                eContainer = eContainer.eContainer();
            }
        }
        copier.copyReferences();
        return new SetupContext(installationCopy, workspaceCopy, userCopy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        NONE,
        CREATE,
        CREATE_AND_SAVE;

    }

    private static class WorkspaceUtil {
        private WorkspaceUtil() {
        }

        private static URI getStaticWorkspaceLocationURI() {
            IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
            return URI.createFileURI((String)workspaceRoot.getLocation().toOSString());
        }

        static /* synthetic */ URI access$0() {
            return WorkspaceUtil.getStaticWorkspaceLocationURI();
        }
    }
}

