/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.ui.TaskItemDecorator;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupUtil;
import org.eclipse.oomph.setup.provider.SetupEditPlugin;
import org.eclipse.oomph.setup.ui.Questionnaire;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetupUIPlugin
extends OomphUIPlugin {
    public static final SetupUIPlugin INSTANCE = new SetupUIPlugin();
    public static final String PLUGIN_ID = INSTANCE.getSymbolicName();
    public static final String PRODUCT_ID = "org.eclipse.oomph.setup.installer.product";
    public static final String PREF_SKIP_STARTUP_TASKS = "skip.startup.tasks";
    public static final String PREF_ENABLE_PREFERENCE_RECORDER = "enable.preference.recorder";
    public static final boolean QUESTIONNAIRE_SKIP = PropertiesUtil.isProperty((String)"oomph.setup.questionnaire.skip");
    private static final String RESTARTING_FILE_NAME = "restarting";
    private static final String ANNOTATION_SOURCE_INITIAL = "initial";
    private static final String ANNOTATION_DETAILS_KEY_OFFLINE = "offline";
    private static final String ANNOTATION_DETAILS_KEY_MIRRORS = "mirrors";
    private static final boolean SETUP_SKIP = PropertiesUtil.isProperty((String)"oomph.setup.skip");
    private static Implementation plugin;

    public SetupUIPlugin() {
        super(new ResourceLocator[]{UIPlugin.INSTANCE, SetupEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static boolean isInstallerProduct() {
        String productID = PropertiesUtil.getProperty((String)"eclipse.product");
        return PRODUCT_ID.equals(productID);
    }

    public static void initialStart(File ws, boolean offline, boolean mirrors) {
        Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
        annotation.setSource(ANNOTATION_SOURCE_INITIAL);
        annotation.getDetails().put((Object)ANNOTATION_DETAILS_KEY_OFFLINE, (Object)Boolean.toString(offline));
        annotation.getDetails().put((Object)ANNOTATION_DETAILS_KEY_MIRRORS, (Object)Boolean.toString(mirrors));
        File file = new File(ws, ".metadata/.plugins/" + INSTANCE.getSymbolicName() + "/" + RESTARTING_FILE_NAME);
        SetupUIPlugin.saveRestartFile(file, annotation);
    }

    public static void restart(Trigger trigger, EList<SetupTask> setupTasks) {
        if (!setupTasks.isEmpty()) {
            Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
            annotation.setSource(trigger.toString());
            annotation.getReferences().addAll(setupTasks);
            SetupUIPlugin.saveRestartFile(SetupUIPlugin.getRestartingFile(), annotation);
        }
        PlatformUI.getWorkbench().restart();
    }

    private static void saveRestartFile(File file, Annotation annotation) {
        try {
            Resource resource = SetupUtil.createResourceSet().createResource(URI.createFileURI((String)file.toString()));
            resource.getContents().add((Object)annotation);
            resource.save(null);
        }
        catch (Exception exception) {}
    }

    public static boolean isSkipStartupTasks() {
        return plugin.getPreferenceStore().getBoolean(PREF_SKIP_STARTUP_TASKS);
    }

    private static File getRestartingFile() {
        return new File(INSTANCE.getStateLocation().toString(), RESTARTING_FILE_NAME);
    }

    private static void performStartup() {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                if (!SetupUIPlugin.isInstallerProduct()) {
                    SetupPropertyTester.setStarting(true);
                    final IWorkbench workbench = PlatformUI.getWorkbench();
                    IExtensionTracker extensionTracker = workbench.getExtensionTracker();
                    if (extensionTracker == null || workbench.getWorkbenchWindowCount() == 0) {
                        display.timerExec(1000, (Runnable)this);
                    } else {
                        if (SetupTaskPerformer.REMOTE_DEBUG) {
                            MessageDialog.openInformation((Shell)UIUtil.getShell(), (String)"Remote Debug Pause", (String)"The setup tasks are paused to allow you to attach a remote debugger");
                        }
                        if ("macosx".equals(Platform.getOS())) {
                            new TaskItemDecorator();
                        }
                        RecorderManager.Lifecycle.start(display);
                        if (!SETUP_SKIP && !SetupUIPlugin.isSkipStartupTasks()) {
                            new Job("Setup check..."){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        monitor.beginTask("Determining tasks to be performed", -1);
                                        SetupUIPlugin.performStartup(workbench, monitor);
                                        monitor.done();
                                        IStatus iStatus = Status.OK_STATUS;
                                        return iStatus;
                                    }
                                    finally {
                                        SetupPropertyTester.setStarting(false);
                                    }
                                }
                            }.schedule();
                        } else {
                            new Job("Refresh Setup Cache"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        ResourceMirror resourceMirror = new ResourceMirror();
                                        resourceMirror.perform(Arrays.asList(SetupContext.INSTALLATION_SETUP_URI, SetupContext.WORKSPACE_SETUP_URI, SetupContext.USER_SETUP_URI));
                                        ResourceSet resourceSet = resourceMirror.getResourceSet();
                                        resourceMirror.dispose();
                                        SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
                                        IStatus iStatus = Status.OK_STATUS;
                                        return iStatus;
                                    }
                                    finally {
                                        SetupPropertyTester.setStarting(false);
                                    }
                                }
                            }.schedule();
                        }
                    }
                }
            }
        });
    }

    private static void performStartup(IWorkbench workbench, IProgressMonitor monitor) {
        ResourceSet resourceSet;
        SetupTaskPerformer performer;
        HashSet<URI> neededRestartTasks;
        boolean restarting;
        block24: {
            Trigger trigger = Trigger.STARTUP;
            restarting = false;
            neededRestartTasks = new HashSet<URI>();
            try {
                File restartingFile = SetupUIPlugin.getRestartingFile();
                if (restartingFile.exists()) {
                    monitor.subTask("Reading restart tasks");
                    Resource resource = SetupUtil.createResourceSet().getResource(URI.createFileURI((String)restartingFile.toString()), true);
                    Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
                    resource.getContents().remove((Object)annotation);
                    if (ANNOTATION_SOURCE_INITIAL.equals(annotation.getSource())) {
                        if ("true".equals(annotation.getDetails().get((Object)ANNOTATION_DETAILS_KEY_OFFLINE))) {
                            System.setProperty("oomph.setup.offline.startup", "true");
                        }
                        if ("true".equals(annotation.getDetails().get((Object)ANNOTATION_DETAILS_KEY_MIRRORS))) {
                            System.setProperty("oomph.setup.mirrors.startup", "true");
                        }
                    } else {
                        for (EObject eObject : annotation.getReferences()) {
                            neededRestartTasks.add(EcoreUtil.getURI((EObject)eObject));
                        }
                        trigger = Trigger.get((String)annotation.getSource());
                        restarting = true;
                    }
                    IOUtil.deleteBestEffort((File)restartingFile);
                }
            }
            catch (Exception exception) {}
            if (!QUESTIONNAIRE_SKIP) {
                Questionnaire.perform(UIUtil.getShell(), false);
            }
            monitor.subTask("Creating a task performer");
            performer = null;
            resourceSet = SetupUtil.createResourceSet();
            try {
                performer = SetupTaskPerformer.createForIDE((ResourceSet)resourceSet, (SetupPrompter)SetupPrompter.CANCEL, (Trigger)trigger);
            }
            catch (OperationCanceledException operationCanceledException) {
                SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
                break block24;
            }
            catch (Throwable ex) {
                try {
                    INSTANCE.log(ex);
                    return;
                }
                catch (Throwable eObject) {
                    throw eObject;
                }
                finally {
                    SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
                }
            }
            SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
        }
        if (performer != null) {
            try {
                EList neededTasks = performer.initNeededSetupTasks();
                if (restarting) {
                    Iterator it = neededTasks.iterator();
                    while (it.hasNext()) {
                        SetupTask setupTask = (SetupTask)it.next();
                        if (setupTask.getPriority() != 200 && neededRestartTasks.contains(EcoreUtil.getURI((EObject)setupTask))) continue;
                        it.remove();
                    }
                }
                if (neededTasks.isEmpty()) {
                    return;
                }
            }
            catch (Throwable ex) {
                INSTANCE.log(ex);
                return;
            }
        }
        if (performer == null) {
            monitor.setTaskName("Performing tasks that need prompted variables");
        } else {
            monitor.setTaskName("Performing " + performer.getTriggeredSetupTasks().size() + " tasks");
        }
        final SetupTaskPerformer finalPerfomer = performer;
        UIUtil.syncExec((Runnable)new Runnable(){

            public void run() {
                if (finalPerfomer != null) {
                    resourceSet.getResources().add((Object)finalPerfomer.getUser().eResource());
                }
                SetupWizard.Updater updater = new SetupWizard.Updater(finalPerfomer);
                updater.openDialog(UIUtil.getShell());
            }
        });
    }

    public static class Implementation
    extends EclipseUIPlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            SetupUIPlugin.performStartup();
        }

        public void stop(BundleContext context) throws Exception {
            if (!SetupUIPlugin.isInstallerProduct()) {
                RecorderManager.Lifecycle.stop();
            }
            super.stop(context);
        }
    }
}

