/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.manifests;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractProjectHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IProject project = AbstractProjectHandler.getProject(page);
        if (project != null && this.executeWithProject(page, project)) {
            return null;
        }
        try {
            Object element = AbstractProjectHandler.getSelectedElement(page);
            this.executeWithElement(page, element);
        }
        catch (Exception exception) {}
        return null;
    }

    protected abstract boolean executeWithProject(IWorkbenchPage var1, IProject var2);

    protected void executeWithElement(IWorkbenchPage page, Object element) throws Exception {
    }

    private static Object getSelectedElement(IWorkbenchPage page) {
        IStructuredSelection ssel;
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1) {
            return ssel.getFirstElement();
        }
        return null;
    }

    private static IProject getProject(IWorkbenchPage page) {
        IEditorInput input;
        IEditorPart editor;
        Object element = AbstractProjectHandler.getSelectedElement(page);
        IResource resource = (IResource)ObjectUtil.adapt((Object)element, IResource.class);
        if (resource == null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)input).getFile();
        }
        if (resource == null) {
            return null;
        }
        return resource.getProject();
    }
}

