/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.GUID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.LongID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.NamespacePermission;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.identity.URIID;
import org.eclipse.ecf.core.identity.UuID;
import org.eclipse.ecf.internal.core.identity.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDFactory
implements IIDFactory {
    public static final String SECURITY_PROPERTY = String.valueOf(IDFactory.class.getName()) + ".security";
    private static Hashtable<String, Namespace> namespaces = new Hashtable();
    protected static IIDFactory instance = null;
    private static boolean initialized;

    static {
        instance = new IDFactory();
        IDFactory.addNamespace0(new StringID.StringIDNamespace());
        IDFactory.addNamespace0(new GUID.GUIDNamespace());
        IDFactory.addNamespace0(new LongID.LongNamespace());
        IDFactory.addNamespace0(new URIID.URIIDNamespace());
        IDFactory.addNamespace0(new UuID.UuIDNamespace());
        initialized = false;
    }

    private static synchronized void initialize() {
        if (!initialized) {
            Activator a = Activator.getDefault();
            if (a != null) {
                a.setupNamespaceExtensionPoint();
            }
            initialized = true;
        }
    }

    public static synchronized IIDFactory getDefault() {
        return instance;
    }

    private IDFactory() {
    }

    @Override
    public Namespace addNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return null;
        }
        IDFactory.initialize();
        return IDFactory.addNamespace0(namespace);
    }

    public static final Namespace addNamespace0(Namespace namespace) {
        if (namespace == null) {
            return null;
        }
        return namespaces.put(namespace.getName(), namespace);
    }

    protected static final void checkPermission(NamespacePermission namespacepermission) throws SecurityException {
    }

    @Override
    public boolean containsNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return false;
        }
        IDFactory.initialize();
        return IDFactory.containsNamespace0(namespace);
    }

    @Override
    public List<Namespace> getNamespaces() {
        IDFactory.initialize();
        return new ArrayList<Namespace>(namespaces.values());
    }

    public static final boolean containsNamespace0(Namespace n) {
        if (n == null) {
            return false;
        }
        return namespaces.containsKey(n.getName());
    }

    @Override
    public Namespace getNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return null;
        }
        IDFactory.initialize();
        return IDFactory.getNamespace0(namespace);
    }

    @Override
    public Namespace getNamespaceByName(String name) throws SecurityException {
        IDFactory.initialize();
        return IDFactory.getNamespace0(name);
    }

    protected static final Namespace getNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return namespaces.get(n.getName());
    }

    protected static final Namespace getNamespace0(String name) {
        if (name == null) {
            return null;
        }
        return namespaces.get(name);
    }

    @Override
    public ID createGUID() throws IDCreateException {
        return this.createGUID(20);
    }

    @Override
    public ID createGUID(int length) throws IDCreateException {
        return this.createID((Namespace)new GUID.GUIDNamespace(), (Object[])new Integer[]{new Integer(length)});
    }

    protected static void logAndThrow(String s, Throwable t) throws IDCreateException {
        IDCreateException e = null;
        e = t != null ? new IDCreateException(String.valueOf(s) + ": " + t.getClass().getName() + ": " + t.getMessage(), t) : new IDCreateException(s);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.identity", 4, s, (Throwable)e));
        throw e;
    }

    @Override
    public ID createID(Namespace n, Object[] args) throws IDCreateException {
        if (n == null) {
            IDFactory.logAndThrow("Namespace cannot be null", null);
        }
        IDFactory.initialize();
        Namespace ns = IDFactory.getNamespace0(n);
        if (ns == null) {
            IDFactory.logAndThrow("Namespace " + n.getName() + " not found", null);
        }
        return ns.createInstance(args);
    }

    @Override
    public ID createID(String namespaceName, Object[] args) throws IDCreateException {
        Namespace n = this.getNamespaceByName(namespaceName);
        if (n == null) {
            throw new IDCreateException("Namespace " + namespaceName + " not found");
        }
        return this.createID(n, args);
    }

    @Override
    public ID createID(Namespace namespace, String uri) throws IDCreateException {
        return this.createID(namespace, new Object[]{uri});
    }

    @Override
    public ID createID(String namespace, String uri) throws IDCreateException {
        return this.createID(namespace, new Object[]{uri});
    }

    @Override
    public ID createStringID(String idstring) throws IDCreateException {
        if (idstring == null) {
            throw new IDCreateException("StringID cannot be null");
        }
        return this.createID((Namespace)new StringID.StringIDNamespace(), (Object[])new String[]{idstring});
    }

    @Override
    public ID createLongID(long l) throws IDCreateException {
        return this.createID((Namespace)new LongID.LongNamespace(), (Object[])new Long[]{new Long(l)});
    }

    @Override
    public Namespace removeNamespace(Namespace n) throws SecurityException {
        if (n == null) {
            return null;
        }
        IDFactory.initialize();
        return IDFactory.removeNamespace0(n);
    }

    public static final Namespace removeNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return namespaces.remove(n.getName());
    }

    @Override
    public ID createUuID(String uuid) throws IDCreateException {
        return this.createID((Namespace)new UuID.UuIDNamespace(), new Object[]{uuid});
    }

    @Override
    public ID createUuID(UUID uuid) throws IDCreateException {
        return this.createID((Namespace)new UuID.UuIDNamespace(), new Object[]{uuid});
    }

    @Override
    public ID createUuID(URI uuidURI) throws IDCreateException {
        return this.createID((Namespace)new UuID.UuIDNamespace(), new Object[]{uuidURI});
    }

    @Override
    public ID createURIID(URI uri) throws IDCreateException {
        return this.createID((Namespace)new URIID.URIIDNamespace(), new Object[]{uri});
    }

    @Override
    public ID createURIID(String uri) throws IDCreateException {
        return this.createID((Namespace)new URIID.URIIDNamespace(), new Object[]{uri});
    }

    @Override
    public ID createUuID() throws IDCreateException {
        return this.createID((Namespace)new UuID.UuIDNamespace(), (Object[])null);
    }
}

