/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workbench.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.workbench.CommandParameter;
import org.eclipse.oomph.setup.workbench.KeyBindingContext;
import org.eclipse.oomph.setup.workbench.KeyBindingTask;
import org.eclipse.oomph.setup.workbench.WorkbenchPackage;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBindingTaskImpl
extends SetupTaskImpl
implements KeyBindingTask {
    protected static final String SCHEME_EDEFAULT = "org.eclipse.ui.defaultAcceleratorConfiguration";
    protected String scheme = "org.eclipse.ui.defaultAcceleratorConfiguration";
    protected EList<KeyBindingContext> contexts;
    protected static final String PLATFORM_EDEFAULT = null;
    protected String platform = PLATFORM_EDEFAULT;
    protected static final String LOCALE_EDEFAULT = null;
    protected String locale = LOCALE_EDEFAULT;
    protected static final String KEYS_EDEFAULT = null;
    protected String keys = KEYS_EDEFAULT;
    protected static final String COMMAND_EDEFAULT = null;
    protected String command = COMMAND_EDEFAULT;
    protected EList<CommandParameter> commandParameters;

    protected KeyBindingTaskImpl() {
    }

    protected EClass eStaticClass() {
        return WorkbenchPackage.Literals.KEY_BINDING_TASK;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String newScheme) {
        String oldScheme = this.scheme;
        this.scheme = newScheme;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldScheme, (Object)this.scheme));
        }
    }

    @Override
    public EList<KeyBindingContext> getContexts() {
        if (this.contexts == null) {
            this.contexts = new EObjectContainmentEList(KeyBindingContext.class, (InternalEObject)this, 11);
        }
        return this.contexts;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public void setPlatform(String newPlatform) {
        String oldPlatform = this.platform;
        this.platform = newPlatform;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldPlatform, (Object)this.platform));
        }
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String newLocale) {
        String oldLocale = this.locale;
        this.locale = newLocale;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldLocale, (Object)this.locale));
        }
    }

    @Override
    public String getKeys() {
        return this.keys;
    }

    @Override
    public void setKeys(String newKeys) {
        String oldKeys = this.keys;
        this.keys = newKeys;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldKeys, (Object)this.keys));
        }
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(String newCommand) {
        String oldCommand = this.command;
        this.command = newCommand;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldCommand, (Object)this.command));
        }
    }

    @Override
    public EList<CommandParameter> getCommandParameters() {
        if (this.commandParameters == null) {
            this.commandParameters = new EObjectContainmentEList(CommandParameter.class, (InternalEObject)this, 16);
        }
        return this.commandParameters;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getContexts()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getCommandParameters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getScheme();
            }
            case 11: {
                return this.getContexts();
            }
            case 12: {
                return this.getPlatform();
            }
            case 13: {
                return this.getLocale();
            }
            case 14: {
                return this.getKeys();
            }
            case 15: {
                return this.getCommand();
            }
            case 16: {
                return this.getCommandParameters();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setScheme((String)newValue);
                return;
            }
            case 11: {
                this.getContexts().clear();
                this.getContexts().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setPlatform((String)newValue);
                return;
            }
            case 13: {
                this.setLocale((String)newValue);
                return;
            }
            case 14: {
                this.setKeys((String)newValue);
                return;
            }
            case 15: {
                this.setCommand((String)newValue);
                return;
            }
            case 16: {
                this.getCommandParameters().clear();
                this.getCommandParameters().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setScheme(SCHEME_EDEFAULT);
                return;
            }
            case 11: {
                this.getContexts().clear();
                return;
            }
            case 12: {
                this.setPlatform(PLATFORM_EDEFAULT);
                return;
            }
            case 13: {
                this.setLocale(LOCALE_EDEFAULT);
                return;
            }
            case 14: {
                this.setKeys(KEYS_EDEFAULT);
                return;
            }
            case 15: {
                this.setCommand(COMMAND_EDEFAULT);
                return;
            }
            case 16: {
                this.getCommandParameters().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return SCHEME_EDEFAULT == null ? this.scheme != null : !SCHEME_EDEFAULT.equals(this.scheme);
            }
            case 11: {
                return this.contexts != null && !this.contexts.isEmpty();
            }
            case 12: {
                return PLATFORM_EDEFAULT == null ? this.platform != null : !PLATFORM_EDEFAULT.equals(this.platform);
            }
            case 13: {
                return LOCALE_EDEFAULT == null ? this.locale != null : !LOCALE_EDEFAULT.equals(this.locale);
            }
            case 14: {
                return KEYS_EDEFAULT == null ? this.keys != null : !KEYS_EDEFAULT.equals(this.keys);
            }
            case 15: {
                return COMMAND_EDEFAULT == null ? this.command != null : !COMMAND_EDEFAULT.equals(this.command);
            }
            case 16: {
                return this.commandParameters != null && !this.commandParameters.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (scheme: ");
        result.append(this.scheme);
        result.append(", platform: ");
        result.append(this.platform);
        result.append(", locale: ");
        result.append(this.locale);
        result.append(", keys: ");
        result.append(this.keys);
        result.append(", command: ");
        result.append(this.command);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        IBindingService bindingService = (IBindingService)UIUtil.getService((IServiceLocator)PlatformUI.getWorkbench(), IBindingService.class);
        Binding[] bindings = bindingService.getBindings();
        for (KeyBindingContext keyBindingContext : this.getContexts()) {
            if (!this.isNeeded(keyBindingContext, bindings)) continue;
            return true;
        }
        return false;
    }

    private boolean isNeeded(KeyBindingContext keyBindingContext, Binding[] bindings) throws Exception {
        int i = 0;
        while (i < bindings.length) {
            KeyBinding keyBinding;
            Binding binding = bindings[i];
            if (binding instanceof KeyBinding && this.isEqual(keyBindingContext, keyBinding = (KeyBinding)binding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEqual(KeyBindingContext keyBindingContext, KeyBinding keyBinding) throws Exception {
        if (!ObjectUtil.equals((Object)keyBinding.getSchemeId(), (Object)this.getScheme())) {
            return false;
        }
        if (!ObjectUtil.equals((Object)keyBinding.getContextId(), (Object)keyBindingContext.getID())) {
            return false;
        }
        if (!ObjectUtil.equals((Object)keyBinding.getPlatform(), (Object)this.getPlatform())) {
            return false;
        }
        if (!ObjectUtil.equals((Object)keyBinding.getLocale(), (Object)this.getLocale())) {
            return false;
        }
        KeySequence keySequence = KeySequence.getInstance((String)this.getKeys());
        if (!ObjectUtil.equals((Object)keyBinding.getKeySequence(), (Object)keySequence)) {
            return false;
        }
        ParameterizedCommand parameterizedCommand = keyBinding.getParameterizedCommand();
        if (parameterizedCommand == null || !ObjectUtil.equals((Object)parameterizedCommand.getId(), (Object)this.getCommand())) {
            return false;
        }
        return ObjectUtil.equals((Object)parameterizedCommand.getParameterMap(), (Object)this.getCommandParameterMap());
    }

    public void perform(SetupTaskContext context) throws Exception {
        final IBindingService bindingService = (IBindingService)UIUtil.getService((IServiceLocator)PlatformUI.getWorkbench(), IBindingService.class);
        final ArrayList<Binding> bindings = new ArrayList<Binding>(Arrays.asList(bindingService.getBindings()));
        for (KeyBindingContext keyBindingContext : this.getContexts()) {
            KeyBinding binding = new KeyBinding(KeySequence.getInstance((String)this.getKeys()), this.getParameterizedCommand(), this.getScheme(), keyBindingContext.getID(), this.getLocale(), this.getPlatform(), null, 1);
            bindings.add((Binding)binding);
        }
        final Exception[] exception = new Exception[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Scheme activeScheme = bindingService.getActiveScheme();
                    bindingService.savePreferences(activeScheme, bindings.toArray(new Binding[bindings.size()]));
                }
                catch (IOException ex) {
                    exception[0] = ex;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    private ParameterizedCommand getParameterizedCommand() throws NotDefinedException {
        ICommandService commandService = (ICommandService)UIUtil.getService((IServiceLocator)PlatformUI.getWorkbench(), ICommandService.class);
        Command command = commandService.getCommand(this.getCommand());
        Map params = this.getCommandParameterMap();
        return ParameterizedCommand.generateCommand((Command)command, (Map)params);
    }

    private Map getCommandParameterMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        for (CommandParameter commandParameter : this.getCommandParameters()) {
            params.put(commandParameter.getID(), commandParameter.getValue());
        }
        return params;
    }
}

