/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.IOException;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;

public class LocalDataProvider
implements DataProvider {
    private final File localFile;

    public LocalDataProvider(File locaFile) {
        this.localFile = locaFile;
    }

    public DataProvider.Location getLocation() {
        return DataProvider.Location.LOCAL;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public boolean update(File file) throws IOException, DataProvider.NotFoundException {
        String localVersion = SyncUtil.getDigest(this.localFile);
        if (StringUtil.isEmpty((String)localVersion)) {
            throw new DataProvider.NotFoundException(this.localFile.toURI());
        }
        String version = SyncUtil.getDigest(file);
        if (!ObjectUtil.equals((Object)version, (Object)localVersion)) {
            IOUtil.copyFile((File)this.localFile, (File)file);
            return true;
        }
        return false;
    }

    public void post(File file, String baseVersion) throws IOException, DataProvider.NotCurrentException {
        String localVersion = SyncUtil.getDigest(this.localFile);
        if (!StringUtil.isEmpty((String)localVersion) && !ObjectUtil.equals((Object)localVersion, (Object)baseVersion)) {
            IOUtil.copyFile((File)this.localFile, (File)file);
            throw new DataProvider.NotCurrentException(this.localFile.toURI());
        }
        IOUtil.copyFile((File)file, (File)this.localFile);
    }

    public boolean delete() throws IOException {
        if (!this.localFile.exists()) {
            return false;
        }
        SyncUtil.deleteFile(this.localFile);
        return true;
    }
}

