/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync.tests;

import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.eclipse.oomph.setup.internal.sync.RemoteDataProvider;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;

public class TestServer {
    private static final boolean LOCALHOST = false;
    private static RemoteDataProvider remoteDataProvider;

    public static synchronized RemoteDataProvider getRemoteDataProvider() throws Exception {
        if (remoteDataProvider == null) {
            remoteDataProvider = TestServer.createRemoteDataProvider();
        }
        return remoteDataProvider;
    }

    private static RemoteDataProvider createRemoteDataProvider() throws Exception {
        Credentials credentials;
        File file = new File(PropertiesUtil.getUserHome(), "oomph.test.credentials");
        if (file.exists()) {
            System.out.println("Reading credentials from file " + file);
            credentials = (Credentials)IOUtil.readObject((File)file, (ClassLoader)UsernamePasswordCredentials.class.getClassLoader());
        } else {
            credentials = new LoginDialog().getCredentials();
            if (credentials == null) {
                System.exit(0);
            }
            System.out.println("Storing credentials in file " + file);
            IOUtil.writeObject((File)file, (Object)credentials);
        }
        return new RemoteDataProvider(new URI("https://dev.eclipse.org/oomph/"), credentials);
    }

    private static class LoginDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private Credentials credentials;

        public LoginDialog() {
            this.setTitle("Login");
            this.setModal(true);
            final JTextField userField = new JTextField(15);
            final JPasswordField passwordField = new JPasswordField(15);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new GridLayout(3, 2));
            contentPane.add(new JLabel("Username:"));
            contentPane.add(userField);
            contentPane.add(new JLabel("Password:"));
            contentPane.add(passwordField);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String username = userField.getText();
                    String password = new String(passwordField.getPassword());
                    if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                        LoginDialog.this.credentials = (Credentials)new UsernamePasswordCredentials(username, password);
                    }
                    LoginDialog.this.close();
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LoginDialog.this.close();
                }
            });
            contentPane.add(okButton);
            contentPane.add(cancelButton);
            userField.setText("stepper@esc-net.de");
            this.pack();
            this.setCenterLocation();
            this.setVisible(true);
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        private void setCenterLocation() {
            try {
                Point mousePoint = MouseInfo.getPointerInfo().getLocation();
                GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                int n = graphicsDeviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GraphicsDevice device = graphicsDeviceArray[n2];
                    Rectangle bounds = device.getDefaultConfiguration().getBounds();
                    if (bounds.contains(mousePoint)) {
                        this.setLocation((bounds.width - this.getWidth()) / 2 + bounds.x, (bounds.height - this.getHeight()) / 2 + bounds.y);
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }

        private void close() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

