/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.operations.ResolutionResult;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ILayoutConstants;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUDetailsGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.AvailableUpdateElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;

public abstract class ResolutionStatusPage
extends ProvisioningWizardPage {
    private static final String LIST_WEIGHT = "ListSashWeight";
    private static final String DETAILS_WEIGHT = "DetailsSashWeight";
    private static final String NAME_COLUMN_WIDTH = "NameColumnWidth";
    private static final String VERSION_COLUMN_WIDTH = "VersionColumnWidth";
    private static final String ID_COLUMN_WIDTH = "IDColumnWidth";
    private IUColumnConfig nameColumn;
    private IUColumnConfig versionColumn;
    private IUColumnConfig idColumn;

    protected ResolutionStatusPage(String pageName, ProvisioningUI ui, ProvisioningOperationWizard wizard) {
        super(pageName, ui, wizard);
    }

    protected abstract void updateCaches(IUElementListRoot var1, ProfileChangeOperation var2);

    protected abstract boolean isCreated();

    protected abstract IUDetailsGroup getDetailsGroup();

    protected abstract IInstallableUnit getSelectedIU();

    protected abstract Object[] getSelectedElements();

    public void updateStatus(IUElementListRoot newRoot, ProfileChangeOperation op) {
        boolean pageComplete;
        IStatus currentStatus = this.getProvisioningWizard().getCurrentStatus();
        this.updateCaches(newRoot, op);
        int messageType = 0;
        boolean bl = pageComplete = op != null;
        if (currentStatus != null && !currentStatus.isOK()) {
            messageType = 1;
            int severity = currentStatus.getSeverity();
            if (severity == 4) {
                messageType = 3;
                pageComplete = false;
                ProvUI.reportStatus(currentStatus, 1);
            } else if (severity == 2) {
                messageType = 2;
                ProvUI.reportStatus(currentStatus, 1);
            } else if (severity == 8) {
                pageComplete = this.shouldCompleteOnCancel();
            }
        }
        this.setPageComplete(pageComplete);
        if (!this.isCreated()) {
            return;
        }
        this.setMessage(this.getMessageText(currentStatus), messageType);
        this.setDetailText(op);
    }

    protected boolean shouldCompleteOnCancel() {
        return true;
    }

    protected String getIUDescription(IInstallableUnit iu) {
        String description = iu.getProperty("org.eclipse.equinox.p2.description", null);
        if (description == null) {
            description = "";
        }
        return description;
    }

    protected String getIUDescription(AvailableIUElement element) {
        IInstallableUnit iu = element.getIU();
        String description = this.getIUDescription(iu);
        if (this.isLocked(element)) {
            description = NLS.bind((String)ProvUIMessages.ResolutionStatusPage_ErrorIULocked, (Object)description);
        }
        return description;
    }

    protected String getIUDescription(Object element) {
        if (element instanceof AvailableIUElement) {
            return this.getIUDescription((AvailableIUElement)element);
        }
        IInstallableUnit selectedIU = ElementUtils.elementToIU(element);
        if (selectedIU != null) {
            return this.getIUDescription(selectedIU);
        }
        return "";
    }

    String getMessageText(IStatus currentStatus) {
        if (currentStatus == null || currentStatus.isOK()) {
            return this.getDescription();
        }
        if (currentStatus.getSeverity() == 8) {
            return ProvUIMessages.ResolutionWizardPage_Canceled;
        }
        if (currentStatus.getSeverity() == 4) {
            return ProvUIMessages.ResolutionWizardPage_ErrorStatus;
        }
        return ProvUIMessages.ResolutionWizardPage_WarningInfoStatus;
    }

    void setDetailText(ProfileChangeOperation resolvedOperation) {
        String detail = null;
        Object selectedElement = this.getSelectedElement();
        IInstallableUnit selectedIU = ElementUtils.elementToIU(selectedElement);
        IUDetailsGroup detailsGroup = this.getDetailsGroup();
        if (resolvedOperation == null || !resolvedOperation.hasResolved() || this.getProvisioningWizard().statusOverridesOperation()) {
            IStatus currentStatus = this.getProvisioningWizard().getCurrentStatus();
            if (!currentStatus.isOK()) {
                ResolutionResult result = new ResolutionResult();
                result.addSummaryStatus(currentStatus);
                detail = result.getSummaryReport();
                detailsGroup.enablePropertyLink(false);
            } else if (selectedIU != null) {
                detail = this.getIUDescription(selectedElement);
                detailsGroup.enablePropertyLink(true);
            } else {
                detail = "";
                detailsGroup.enablePropertyLink(false);
            }
            detailsGroup.setDetailText(detail);
            return;
        }
        if (selectedIU != null) {
            detail = resolvedOperation.getResolutionDetails(selectedIU);
            if (detail != null) {
                detailsGroup.enablePropertyLink(false);
                detailsGroup.setDetailText(detail);
                return;
            }
            if (resolvedOperation.getResolutionResult().getSeverity() == 4 && (detail = resolvedOperation.getResolutionDetails()) != null) {
                detailsGroup.enablePropertyLink(false);
                detailsGroup.setDetailText(detail);
                return;
            }
            detailsGroup.enablePropertyLink(true);
            detailsGroup.setDetailText(this.getIUDescription(selectedElement));
            return;
        }
        detail = resolvedOperation.getResolutionDetails();
        detailsGroup.enablePropertyLink(false);
        if (detail == null) {
            detail = "";
        }
        detailsGroup.setDetailText(detail);
    }

    private Object getSelectedElement() {
        Object[] elements = this.getSelectedElements();
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    protected abstract String getDialogSettingsName();

    protected abstract SashForm getSashForm();

    private IUColumnConfig getNameColumn() {
        return this.nameColumn;
    }

    private IUColumnConfig getVersionColumn() {
        return this.versionColumn;
    }

    private IUColumnConfig getIdColumn() {
        return this.idColumn;
    }

    protected abstract int getColumnWidth(int var1);

    private int getNameColumnWidth() {
        return this.getColumnWidth(0);
    }

    private int getVersionColumnWidth() {
        return this.getColumnWidth(1);
    }

    private int getIdColumnWidth() {
        return this.getColumnWidth(2);
    }

    protected int[] getSashWeights() {
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section != null) {
            try {
                int[] weights = new int[2];
                if (section.get(LIST_WEIGHT) != null) {
                    weights[0] = section.getInt(LIST_WEIGHT);
                    if (section.get(DETAILS_WEIGHT) != null) {
                        weights[1] = section.getInt(DETAILS_WEIGHT);
                        return weights;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ILayoutConstants.IUS_TO_DETAILS_WEIGHTS;
    }

    protected void getColumnWidthsFromSettings() {
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section != null) {
            try {
                if (section.get(NAME_COLUMN_WIDTH) != null) {
                    this.getNameColumn().setWidthInPixels(section.getInt(NAME_COLUMN_WIDTH));
                }
                if (section.get(VERSION_COLUMN_WIDTH) != null) {
                    this.getVersionColumn().setWidthInPixels(section.getInt(VERSION_COLUMN_WIDTH));
                }
                if (section.get(ID_COLUMN_WIDTH) != null) {
                    this.getIdColumn().setWidthInPixels(section.getInt(ID_COLUMN_WIDTH));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void saveBoundsRelatedSettings() {
        if (!this.isCreated()) {
            return;
        }
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsName());
        }
        section.put(NAME_COLUMN_WIDTH, this.getNameColumnWidth());
        section.put(VERSION_COLUMN_WIDTH, this.getVersionColumnWidth());
        section.put(ID_COLUMN_WIDTH, this.getIdColumnWidth());
        int[] weights = this.getSashForm().getWeights();
        section.put(LIST_WEIGHT, weights[0]);
        section.put(DETAILS_WEIGHT, weights[1]);
    }

    protected IUColumnConfig[] getColumnConfig() {
        this.nameColumn = new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 60);
        this.versionColumn = new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 20);
        this.idColumn = new IUColumnConfig(ProvUIMessages.ProvUI_IdColumnTitle, 0, 40);
        this.getColumnWidthsFromSettings();
        return new IUColumnConfig[]{this.nameColumn, this.versionColumn, this.idColumn};
    }

    private boolean isLocked(AvailableIUElement elementToBeUpdated) {
        if (elementToBeUpdated instanceof AvailableUpdateElement) {
            return ((AvailableUpdateElement)elementToBeUpdated).isLockedForUpdate();
        }
        return false;
    }
}

