/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import org.eclipse.oomph.util.Messages;

public interface Confirmer {
    public static final Confirmer ACCEPT = new Confirmer(){

        @Override
        public Confirmation confirm(boolean defaultConfirmed, Object info) {
            return new Confirmation(true, false);
        }
    };
    public static final Confirmer DECLINE = new Confirmer(){

        @Override
        public Confirmation confirm(boolean defaultConfirmed, Object info) {
            return new Confirmation(false, false);
        }
    };
    public static final Confirmer DEFAULT = new Confirmer(){

        @Override
        public Confirmation confirm(boolean defaultConfirmed, Object info) {
            return new Confirmation(defaultConfirmed, false);
        }
    };

    public Confirmation confirm(boolean var1, Object var2);

    public static final class Confirmation {
        private final boolean confirmed;
        private final boolean remember;

        public Confirmation(boolean confirmed, boolean remember) {
            this.confirmed = confirmed;
            this.remember = remember;
        }

        public boolean isConfirmed() {
            return this.confirmed;
        }

        public boolean isRemember() {
            return this.remember;
        }

        public String toString() {
            return String.valueOf(this.confirmed ? Messages.Confirmer_Accept_label : Messages.Confirmer_Decline_label) + (this.remember ? " " + Messages.Confirmer_Remember_label : "");
        }
    }
}

