/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.UnsignedPolicy;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.ui.AbstractConfirmDialog;
import org.eclipse.oomph.setup.ui.AbstractDialogConfirmer;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class UnsignedContentDialog
extends AbstractConfirmDialog {
    private final String[] unsignedContent;

    public UnsignedContentDialog(String[] unsignedContent) {
        super("Unsigned Content", 600, 400, "Remember choice");
        this.unsignedContent = unsignedContent;
    }

    protected String getShellText() {
        return "Ooomph Unsigned Content Confirmation";
    }

    protected String getDefaultMessage() {
        return "Accept unsigned content before the software can be installed.";
    }

    protected void createUI(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        TreeViewer viewer = new TreeViewer(parent, 65536);
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object element) {
                return this.getChildren(element);
            }

            public Object[] getChildren(Object element) {
                if (element == UnsignedContentDialog.this) {
                    return UnsignedContentDialog.this.unsignedContent;
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return element == UnsignedContentDialog.this;
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new UnsignedContentLabelProvider());
        viewer.setComparator(new ViewerComparator());
        viewer.setInput((Object)this);
        Control control = viewer.getControl();
        control.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)control);
    }

    public static Confirmer createUnsignedContentConfirmer(final User user, final boolean saveChangedUser) {
        Boolean propPolicy = PropertiesUtil.getBoolean((String)"eclipse.p2.unsignedPolicy");
        if (propPolicy != null) {
            return propPolicy != false ? Confirmer.ACCEPT : Confirmer.DECLINE;
        }
        if (user != null) {
            UnsignedPolicy userPolicy = user.getUnsignedPolicy();
            if (userPolicy == UnsignedPolicy.ACCEPT) {
                return Confirmer.ACCEPT;
            }
            if (userPolicy == UnsignedPolicy.DECLINE) {
                return Confirmer.DECLINE;
            }
        }
        return new AbstractDialogConfirmer(){

            public Confirmer.Confirmation confirm(boolean defaultConfirmed, Object info) {
                Confirmer.Confirmation confirmation = super.confirm(defaultConfirmed, info);
                if (user != null && confirmation.isRemember()) {
                    UnsignedPolicy unsignedPolicy = confirmation.isConfirmed() ? UnsignedPolicy.ACCEPT : UnsignedPolicy.DECLINE;
                    user.setUnsignedPolicy(unsignedPolicy);
                    if (saveChangedUser) {
                        BaseUtil.saveEObject((EObject)user);
                    }
                }
                return confirmation;
            }

            protected AbstractConfirmDialog createDialog(boolean defaultConfirmed, Object info) {
                String[] unsignedContent = (String[])info;
                return new UnsignedContentDialog(unsignedContent);
            }
        };
    }

    private final class UnsignedContentLabelProvider
    extends LabelProvider {
        private UnsignedContentLabelProvider() {
        }

        public Image getImage(Object element) {
            File file = new File((String)element);
            if (file.isDirectory()) {
                return SetupUIPlugin.INSTANCE.getSWTImage("unsigned-directory");
            }
            if (file.isFile()) {
                return SetupUIPlugin.INSTANCE.getSWTImage("unsigned-file");
            }
            return null;
        }

        public String getText(Object element) {
            return (String)element;
        }
    }
}

