/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ILineTrackerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ListLineTracker;
import org.eclipse.jface.text.TreeLineTracker;

public abstract class AbstractLineTracker
implements ILineTracker,
ILineTrackerExtension {
    private static final boolean DEBUG = false;
    private volatile SessionData sessionData;
    private final Object sessionLock = new Object();
    private volatile ILineTracker fDelegate = new ListLineTracker(){

        @Override
        public String[] getLegalLineDelimiters() {
            return AbstractLineTracker.this.getLegalLineDelimiters();
        }

        @Override
        protected DelimiterInfo nextDelimiterInfo(String text, int offset) {
            return AbstractLineTracker.this.nextDelimiterInfo(text, offset);
        }
    };
    private boolean fNeedsConversion = true;

    protected AbstractLineTracker() {
        this.sessionData = new SessionData(null);
    }

    @Override
    public int computeNumberOfLines(String text) {
        return this.fDelegate.computeNumberOfLines(text);
    }

    @Override
    public String getLineDelimiter(int line) throws BadLocationException {
        this.checkRewriteSession();
        return this.fDelegate.getLineDelimiter(line);
    }

    @Override
    public IRegion getLineInformation(int line) throws BadLocationException {
        this.checkRewriteSession();
        return this.fDelegate.getLineInformation(line);
    }

    @Override
    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        this.checkRewriteSession();
        return this.fDelegate.getLineInformationOfOffset(offset);
    }

    @Override
    public int getLineLength(int line) throws BadLocationException {
        this.checkRewriteSession();
        return this.fDelegate.getLineLength(line);
    }

    @Override
    public int getLineNumberOfOffset(int offset) throws BadLocationException {
        this.checkRewriteSession();
        return this.fDelegate.getLineNumberOfOffset(offset);
    }

    @Override
    public int getLineOffset(int line) throws BadLocationException {
        this.checkRewriteSession();
        return this.fDelegate.getLineOffset(line);
    }

    @Override
    public int getNumberOfLines() {
        try {
            this.checkRewriteSession();
        }
        catch (BadLocationException badLocationException) {}
        return this.fDelegate.getNumberOfLines();
    }

    @Override
    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        this.checkRewriteSession();
        return this.fDelegate.getNumberOfLines(offset, length);
    }

    @Override
    public void set(String text) {
        boolean hasActiveRewriteSession = this.sessionData.setIfActive(text);
        if (hasActiveRewriteSession) {
            return;
        }
        this.fDelegate.set(text);
    }

    @Override
    public void replace(int offset, int length, String text) throws BadLocationException {
        boolean hasActiveRewriteSession = this.sessionData.addIfActive(offset, length, text);
        if (hasActiveRewriteSession) {
            return;
        }
        this.checkImplementation();
        this.fDelegate.replace(offset, length, text);
    }

    private synchronized void checkImplementation() {
        if (this.fNeedsConversion) {
            this.fNeedsConversion = false;
            this.fDelegate = new TreeLineTracker((ListLineTracker)this.fDelegate){

                @Override
                protected DelimiterInfo nextDelimiterInfo(String text, int offset) {
                    return AbstractLineTracker.this.nextDelimiterInfo(text, offset);
                }

                @Override
                public String[] getLegalLineDelimiters() {
                    return AbstractLineTracker.this.getLegalLineDelimiters();
                }
            };
        }
    }

    protected abstract DelimiterInfo nextDelimiterInfo(String var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startRewriteSession(DocumentRewriteSession session) {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.sessionData.isSessionActive()) {
                throw new IllegalStateException("Rewrite session is already active: " + String.valueOf(this.sessionData));
            }
            this.sessionData = new SessionData(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopRewriteSession(DocumentRewriteSession session, String text) {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.sessionData.sameSession(session)) {
                this.sessionData = new SessionData(null);
                this.set(text);
            }
        }
    }

    protected final boolean hasActiveRewriteSession() {
        return this.sessionData.isSessionActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flushRewriteSession() throws BadLocationException {
        SessionData sessionData = this.sessionData;
        synchronized (sessionData) {
            Iterator<Request> e = this.sessionData.flush();
            while (e.hasNext()) {
                Request request = e.next();
                if (request.isReplaceRequest()) {
                    this.replace(request.offset, request.length, request.text);
                    continue;
                }
                this.set(request.text);
            }
        }
    }

    protected final void checkRewriteSession() throws BadLocationException {
        if (this.hasActiveRewriteSession()) {
            this.flushRewriteSession();
        }
    }

    public static class DelimiterInfo {
        public int delimiterIndex;
        public int delimiterLength;
        public String delimiter;
    }

    protected static class Request {
        public final int offset;
        public final int length;
        public final String text;

        public Request(int offset, int length, String text) {
            this.offset = offset;
            this.length = length;
            this.text = text;
        }

        public Request(String text) {
            this.offset = -1;
            this.length = -1;
            this.text = text;
        }

        public boolean isReplaceRequest() {
            return this.offset > -1 && this.length > -1;
        }
    }

    private static class SessionData {
        private volatile DocumentRewriteSession fActiveRewriteSession;
        private List<Request> fPendingRequests;

        SessionData(DocumentRewriteSession activeRewriteSession) {
            this.fActiveRewriteSession = activeRewriteSession;
            this.fPendingRequests = activeRewriteSession != null ? new ArrayList<Request>(20) : Collections.emptyList();
        }

        boolean isSessionActive() {
            return this.fActiveRewriteSession != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setIfActive(String text) {
            if (this.isSessionActive()) {
                SessionData sessionData = this;
                synchronized (sessionData) {
                    block5: {
                        if (this.isSessionActive()) break block5;
                        return false;
                    }
                    this.fPendingRequests.clear();
                    this.fPendingRequests.add(new Request(text));
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addIfActive(int offset, int length, String text) {
            if (this.isSessionActive()) {
                SessionData sessionData = this;
                synchronized (sessionData) {
                    block5: {
                        if (this.isSessionActive()) break block5;
                        return false;
                    }
                    this.fPendingRequests.add(new Request(offset, length, text));
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator<Request> flush() {
            SessionData sessionData = this;
            synchronized (sessionData) {
                this.fActiveRewriteSession = null;
                Iterator<Request> requests = this.fPendingRequests.iterator();
                this.fPendingRequests = Collections.emptyList();
                return requests;
            }
        }

        boolean sameSession(DocumentRewriteSession session) {
            return this.fActiveRewriteSession == session;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SessionData [");
            builder.append("activeRewriteSession=");
            builder.append(this.fActiveRewriteSession);
            builder.append(", ");
            builder.append("pendingRequests=");
            builder.append(this.fPendingRequests);
            builder.append("]");
            return builder.toString();
        }
    }
}

