/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.equinox.internal.p2.core.helpers.SecureXMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class InfoPListEditor {
    public static final String MARKER_KEY = "CFBundleExecutable";
    public static final String BUNDLE_KEY = "CFBundleName";
    public static final String BUNDLE_ID_KEY = "CFBundleIdentifier";
    public static final String BUNDLE_DISPLAYNAME_KEY = "CFBundleDisplayName";
    public static final String BUNDLE_INFO_KEY = "CFBundleGetInfoString";
    public static final String BUNDLE_VERSION_KEY = "CFBundleVersion";
    public static final String BUNDLE_SHORT_VERSION_KEY = "CFBundleShortVersionString";
    public static final String ICON_KEY = "CFBundleIconFile";
    private final Element infoPList;
    private XPath xPathTool;
    private final Document document;

    private InfoPListEditor(Document doc) {
        this.document = doc;
        this.infoPList = this.document.getDocumentElement();
    }

    public static InfoPListEditor loadPListEditor(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("No file at " + String.valueOf(file.getAbsoluteFile()));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return new InfoPListEditor(builder.parse(file));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Exception exception = e;
            throw new IOException("Problem parsing " + file.getAbsolutePath(), exception);
        }
    }

    public void save(File file) throws TransformerException {
        TransformerFactory transformerFactory = SecureXMLUtil.createTransformerFactoryWithErrorOnDOCTYPE();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource toSerialize = new DOMSource(this.document);
        StreamResult output = new StreamResult(file);
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(toSerialize, output);
    }

    private Node getNode(Node node, String expression) throws XPathExpressionException {
        return (Node)this.getXPathTool().evaluate(expression, node, XPathConstants.NODE);
    }

    public void setKey(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key can't be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        String expression = String.format("/plist/dict/key[text() = '%s']/following-sibling::string[1]", key);
        try {
            Node node = this.getNode(this.infoPList, expression);
            if (node != null) {
                node.getFirstChild().setNodeValue(value);
            } else {
                this.addKey(key, value);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    private void addKey(String key, String value) throws DOMException, XPathExpressionException {
        Element keyNode = this.document.createElement("key");
        Text keyName = this.document.createTextNode(key);
        keyNode.appendChild(keyName);
        Element stringNode = this.document.createElement("string");
        Text stringValue = this.document.createTextNode(value);
        stringNode.appendChild(stringValue);
        this.getNode(this.infoPList, "/plist/dict").appendChild(keyNode);
        this.getNode(this.infoPList, "/plist/dict").appendChild(stringNode);
    }

    private XPath getXPathTool() {
        if (this.xPathTool == null) {
            this.xPathTool = XPathFactory.newInstance().newXPath();
        }
        return this.xPathTool;
    }

    public void setEclipseArgument(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key can't be null");
        }
        String expression = "/plist/dict/key[text() = 'Eclipse']/following-sibling::array[1]/string[text() = -keyring'";
        try {
            Node node = this.getNode(this.infoPList, expression);
            if (node != null) {
                node.getFirstChild().setNodeValue(value);
            } else {
                this.addKey(key, value);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    private List<String> getValues(Object startingPoint, String expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.getXPathTool().evaluate(expression, startingPoint, XPathConstants.NODESET);
        ArrayList<String> result = new ArrayList<String>(nodeList.getLength());
        int ix = 0;
        while (ix < nodeList.getLength()) {
            result.add(nodeList.item(ix).getNodeValue());
            ++ix;
        }
        return result;
    }

    private List<Node> removeNodes(Object startingPoint, String expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.getXPathTool().evaluate(expression, startingPoint, XPathConstants.NODESET);
        ArrayList<Node> result = new ArrayList<Node>(nodeList.getLength());
        int ix = 0;
        while (ix < nodeList.getLength()) {
            result.add(nodeList.item(ix).getParentNode().removeChild(nodeList.item(ix)));
            ++ix;
        }
        return result;
    }

    public List<String> getEclipseArguments() {
        try {
            return this.getValues(this.infoPList, "/plist/dict/key[text() = 'Eclipse']/following-sibling::array[1]/string/text()");
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public void setEclipseArguments(List<String> arguments) {
        try {
            this.removeNodes(this.infoPList, "/plist/dict/key[text() = 'Eclipse']/following-sibling::array[1]/string");
            for (String arg : arguments) {
                Element stringNode = this.document.createElement("string");
                Text stringName = this.document.createTextNode(arg);
                stringNode.appendChild(stringName);
                Node toAppendTo = this.getNode(this.infoPList, "/plist/dict/key[text() = 'Eclipse']/following-sibling::array[1]");
                toAppendTo.appendChild(stringNode);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }
}

