/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class StringLiteralConcatenation
extends StringLiteral {
    public StringLiteralConcatenation(StringLiteral str1, StringLiteral lit) {
        super(str1, lit, str1.sourceStart, lit.sourceEnd, str1.getLineNumber());
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        output.append("StringLiteralConcatenation{");
        StringLiteral[] stringLiteralArray = this.getLiterals();
        int n = stringLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            StringLiteral lit = stringLiteralArray[n2];
            lit.printExpression(indent, output);
            output.append("+\n");
            ++n2;
        }
        return output.append('}');
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            StringLiteral[] stringLiteralArray = this.getLiterals();
            int n = stringLiteralArray.length;
            int n2 = 0;
            while (n2 < n) {
                StringLiteral lit = stringLiteralArray[n2];
                lit.traverse(visitor, scope);
                ++n2;
            }
        }
        visitor.endVisit(this, scope);
    }

    public StringLiteral[] getLiterals() {
        int size = StringLiteralConcatenation.append(null, 0, this);
        StringLiteral[] result = new StringLiteral[size];
        StringLiteralConcatenation.append(result, 0, this);
        return result;
    }

    private static int append(StringLiteral[] result, int length, StringLiteral o) {
        do {
            if (o.tail instanceof StringLiteral) {
                StringLiteral l = (StringLiteral)o.tail;
                if (result != null) {
                    result[result.length - 1 - length] = l;
                }
                ++length;
                continue;
            }
            if (result != null) {
                result[result.length - 1 - length] = o;
            }
            ++length;
        } while ((o = o.optionalHead) != null);
        return length;
    }

    @Override
    protected void flatten(char[] result) {
    }

    @Override
    public void setSource(char[] source) {
        throw new UnsupportedOperationException();
    }
}

