/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.tool.Util;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;

public class PathFileObject
implements JavaFileObject {
    Path path;
    private final Charset charset;
    private final JavaFileObject.Kind kind;

    public PathFileObject(Path path, JavaFileObject.Kind kind, Charset charset) {
        this.path = path;
        this.kind = kind;
        this.charset = charset;
    }

    @Override
    public Modifier getAccessLevel() {
        if (this.getKind() != JavaFileObject.Kind.CLASS) {
            return null;
        }
        ClassFileReader reader = null;
        try {
            reader = this.readFromPath(this.path);
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException e) {
            String error = "Failed to read access level from " + String.valueOf(this.path);
            if (JRTUtil.PROPAGATE_IO_ERRORS) {
                throw new IllegalStateException(error, e);
            }
            System.err.println(error);
            e.printStackTrace();
        }
        if (reader == null) {
            return null;
        }
        int accessFlags = reader.accessFlags();
        if ((accessFlags & 1) != 0) {
            return Modifier.PUBLIC;
        }
        if ((accessFlags & 0x400) != 0) {
            return Modifier.ABSTRACT;
        }
        if ((accessFlags & 0x10) != 0) {
            return Modifier.FINAL;
        }
        return null;
    }

    private ClassFileReader readFromPath(Path p) throws ClassFormatException, IOException {
        return new ClassFileReader(this.path.toUri(), Files.readAllBytes(this.path), this.path.getFileName().toString().toCharArray());
    }

    @Override
    public NestingKind getNestingKind() {
        switch (this.kind) {
            case SOURCE: {
                return NestingKind.TOP_LEVEL;
            }
            case CLASS: {
                ClassFileReader reader = null;
                try {
                    reader = this.readFromPath(this.path);
                }
                catch (ClassFormatException classFormatException) {
                }
                catch (IOException e) {
                    String error = "Failed to read access nesting kind from " + String.valueOf(this.path);
                    if (JRTUtil.PROPAGATE_IO_ERRORS) {
                        throw new IllegalStateException(error, e);
                    }
                    System.err.println(error);
                    e.printStackTrace();
                }
                if (reader == null) {
                    return null;
                }
                if (reader.isAnonymous()) {
                    return NestingKind.ANONYMOUS;
                }
                if (reader.isLocal()) {
                    return NestingKind.LOCAL;
                }
                if (reader.isMember()) {
                    return NestingKind.MEMBER;
                }
                return NestingKind.TOP_LEVEL;
            }
        }
        return null;
    }

    @Override
    public boolean delete() {
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathFileObject)) {
            return false;
        }
        PathFileObject PathFileObject2 = (PathFileObject)o;
        return PathFileObject2.toUri().equals(this.path.toUri());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return Util.getCharContents(this, ignoreEncodingErrors, org.eclipse.jdt.internal.compiler.util.Util.getFileByteContent(this.path.toFile()), this.charset.name());
    }

    @Override
    public long getLastModified() {
        return this.path.toFile().lastModified();
    }

    @Override
    public String getName() {
        return this.path.toString();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return Files.newBufferedReader(this.path);
    }

    @Override
    public Writer openWriter() throws IOException {
        return Files.newBufferedWriter(this.path, new OpenOption[0]);
    }

    public String toString() {
        return this.path.toString();
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind k) {
        String fileName = this.path.getFileName().toString();
        return fileName.endsWith(simpleName + k.extension);
    }
}

