/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.security;

import java.io.IOException;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.PassphraseCallback;
import org.eclipse.ecf.core.security.PasswordCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;

public class ConnectContextFactory {
    private ConnectContextFactory() {
    }

    public static IConnectContext createUsernamePasswordConnectContext(final String username, final Object password) {
        return new IConnectContext(){

            @Override
            public CallbackHandler getCallbackHandler() {
                return new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        if (callbacks == null) {
                            return;
                        }
                        int i = 0;
                        while (i < callbacks.length) {
                            if (callbacks[i] instanceof NameCallback) {
                                NameCallback ncb = (NameCallback)callbacks[i];
                                ncb.setName(username);
                            } else if (callbacks[i] instanceof ObjectCallback) {
                                ObjectCallback ocb = (ObjectCallback)callbacks[i];
                                ocb.setObject(password);
                            } else if (callbacks[i] instanceof PasswordCallback && password instanceof String) {
                                pc = (PasswordCallback)callbacks[i];
                                ((PasswordCallback)pc).setPassword((String)password);
                            } else if (callbacks[i] instanceof PassphraseCallback && password instanceof String) {
                                pc = (PassphraseCallback)callbacks[i];
                                ((PassphraseCallback)pc).setPassphrase((String)password);
                            }
                            ++i;
                        }
                    }
                };
            }
        };
    }

    public static IConnectContext createPasswordConnectContext(final String password) {
        return new IConnectContext(){

            @Override
            public CallbackHandler getCallbackHandler() {
                return new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        if (callbacks == null) {
                            return;
                        }
                        int i = 0;
                        while (i < callbacks.length) {
                            if (callbacks[i] instanceof ObjectCallback) {
                                ObjectCallback ocb = (ObjectCallback)callbacks[i];
                                ocb.setObject(password);
                            } else if (callbacks[i] instanceof PasswordCallback) {
                                pc = (PasswordCallback)callbacks[i];
                                ((PasswordCallback)pc).setPassword(password);
                            } else if (callbacks[i] instanceof PassphraseCallback) {
                                pc = (PassphraseCallback)callbacks[i];
                                ((PassphraseCallback)pc).setPassphrase(password);
                            }
                            ++i;
                        }
                    }
                };
            }
        };
    }
}

