/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.IOException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.JSON;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2AcceleratorKeyPressedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2BasicAuthenticationRequestedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2BasicAuthenticationResponse;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2ContextMenuRequestedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Controller;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Cookie;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2CookieList;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2CookieManager;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2DOMContentLoadedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Deferral;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Environment;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Environment2;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2EnvironmentOptions;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2MoveFocusRequestedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2NavigationCompletedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2NavigationStartingEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2NewWindowRequestedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Profile;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Settings;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2SourceChangedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2SwtCallback;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2SwtHost;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2WindowFeatures;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2_10;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2_11;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2_12;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2_13;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2_2;
import org.eclipse.swt.internal.ole.win32.IStream;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

class Edge
extends WebBrowser {
    static final String SDK_TARGET_VERSION = "99.0.1150.38";
    static final String APPLOCAL_DIR_KEY = "org.eclipse.swt.internal.win32.appLocalDir";
    static final String EDGE_USER_DATA_FOLDER = "org.eclipse.swt.internal.win32.Edge.userDataFolder";
    static final String EDGE_USE_DARK_PREFERED_COLOR_SCHEME = "org.eclipse.swt.internal.win32.Edge.useDarkPreferedColorScheme";
    static final String WEB_VIEW_OPERATION_TIMEOUT = "org.eclipse.swt.internal.win32.Edge.timeout";
    static final String BROWSER_DIR_PROP = "org.eclipse.swt.browser.EdgeDir";
    static final String BROWSER_ARGS_PROP = "org.eclipse.swt.browser.EdgeArgs";
    static final String ALLOW_SINGLE_SIGN_ON_USING_OS_PRIMARY_ACCOUNT_PROP = "org.eclipse.swt.browser.Edge.allowSingleSignOnUsingOSPrimaryAccount";
    static final String DATA_DIR_PROP = "org.eclipse.swt.browser.EdgeDataDir";
    static final String LANGUAGE_PROP = "org.eclipse.swt.browser.EdgeLanguage";
    static final String VERSIONT_PROP = "org.eclipse.swt.browser.EdgeVersion";
    static URI URI_FOR_CUSTOM_TEXT_PAGE;
    private static final String ABOUT_BLANK = "about:blank";
    private static final int MAXIMUM_CREATION_RETRIES = 5;
    private static final Duration MAXIMUM_OPERATION_TIME;
    private static Map<Display, WebViewEnvironment> webViewEnvironments;
    ICoreWebView2Controller controller;
    ICoreWebView2Settings settings;
    ICoreWebView2Profile profile;
    ICoreWebView2Environment2 environment2;
    private final WebViewProvider webViewProvider = new WebViewProvider();
    WebViewEnvironment containingEnvironment;
    static int inCallback;
    boolean inNewWindow;
    private boolean inEvaluate;
    HashMap<Long, LocationEvent> navigations = new HashMap();
    private boolean ignoreGotFocus;
    private boolean ignoreFocusIn;
    private String lastCustomText;
    private CursorPosition previousCursorPosition = new CursorPosition(new Point(0, 0), false);

    static {
        Library.loadLibrary("WebView2Loader");
        Edge.setupLocationForCustomTextPage();
        MAXIMUM_OPERATION_TIME = Duration.ofMillis(Integer.getInteger(WEB_VIEW_OPERATION_TIMEOUT, 5000).intValue());
        webViewEnvironments = new HashMap<Display, WebViewEnvironment>();
        NativeClearSessions = () -> {
            ICoreWebView2CookieManager manager = Edge.getCookieManager();
            if (manager == null) {
                return;
            }
            long[] ppv = new long[1];
            int hr = Edge.callAndWait(ppv, completion -> manager.GetCookies(null, (IUnknown)completion));
            if (hr != 0) {
                Edge.error(2, hr);
            }
            ICoreWebView2CookieList cookieList = new ICoreWebView2CookieList(ppv[0]);
            int[] count = new int[1];
            int[] isSession = new int[1];
            cookieList.get_Count(count);
            int i = 0;
            while (i < count[0]) {
                hr = cookieList.GetValueAtIndex(i, ppv);
                if (hr != 0) {
                    Edge.error(2, hr);
                }
                ICoreWebView2Cookie cookie = new ICoreWebView2Cookie(ppv[0]);
                cookie.get_IsSession(isSession);
                if (isSession[0] != 0) {
                    manager.DeleteCookie(cookie);
                }
                cookie.Release();
                ++i;
            }
            cookieList.Release();
            manager.Release();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        NativeGetCookie = () -> {
            ICoreWebView2CookieManager manager = Edge.getCookieManager();
            if (manager == null) {
                return;
            }
            long[] ppv = new long[1];
            char[] uri = Edge.stringToWstr(CookieUrl);
            int hr = Edge.callAndWait(ppv, completion -> manager.GetCookies(uri, (IUnknown)completion));
            if (hr != 0) {
                Edge.error(2, hr);
            }
            ICoreWebView2CookieList cookieList = new ICoreWebView2CookieList(ppv[0]);
            int[] count = new int[1];
            cookieList.get_Count(count);
            int i = 0;
            while (i < count[0]) {
                hr = cookieList.GetValueAtIndex(i, ppv);
                if (hr != 0) {
                    Edge.error(2, hr);
                }
                ICoreWebView2Cookie cookie = new ICoreWebView2Cookie(ppv[0]);
                cookie.get_Name(ppv);
                String name = Edge.wstrToString(ppv[0], true);
                if (CookieName.equals(name)) {
                    cookie.get_Value(ppv);
                    CookieValue = Edge.wstrToString(ppv[0], true);
                }
                cookie.Release();
                if (CookieValue != null) break;
                ++i;
            }
            cookieList.Release();
            manager.Release();
        };
        NativeSetCookie = () -> {
            long[] ppv;
            char[] path;
            char[] domain;
            char[] value;
            ICoreWebView2CookieManager manager;
            URL origin;
            HttpCookie parser = HttpCookie.parse(CookieValue).get(0);
            try {
                origin = new URL(CookieUrl);
            }
            catch (MalformedURLException e) {
                return;
            }
            if (parser.getDomain() == null) {
                parser.setDomain(origin.getHost());
            }
            if (parser.getPath() == null) {
                parser.setPath(origin.getPath());
            }
            if ((manager = Edge.getCookieManager()) == null) {
                return;
            }
            char[] name = Edge.stringToWstr(parser.getName());
            int hr = manager.CreateCookie(name, value = Edge.stringToWstr(parser.getValue()), domain = Edge.stringToWstr(parser.getDomain()), path = Edge.stringToWstr(parser.getPath()), ppv = new long[1]);
            if (hr != 0) {
                manager.Release();
                return;
            }
            ICoreWebView2Cookie cookie = new ICoreWebView2Cookie(ppv[0]);
            if (parser.getMaxAge() != -1L) {
                cookie.put_Expires(Instant.now().getEpochSecond() + parser.getMaxAge());
            }
            cookie.put_IsSecure(parser.getSecure());
            cookie.put_IsHttpOnly(parser.isHttpOnly());
            hr = manager.AddOrUpdateCookie(cookie);
            cookie.Release();
            manager.Release();
            CookieResult = hr >= 0;
        };
    }

    Edge() {
    }

    static void setupLocationForCustomTextPage() {
        try {
            Path tempFile = Files.createTempFile(Path.of(System.getProperty("java.io.tmpdir"), new String[0]), "base", ".html", new FileAttribute[0]);
            URI_FOR_CUSTOM_TEXT_PAGE = URI.create(tempFile.toUri().toASCIIString());
            tempFile.toFile().deleteOnExit();
        }
        catch (IOException e) {
            URI_FOR_CUSTOM_TEXT_PAGE = URI.create(ABOUT_BLANK);
        }
    }

    static String wstrToString(long psz, boolean free) {
        if (psz == 0L) {
            return "";
        }
        int len = OS.wcslen(psz);
        char[] data = new char[len];
        OS.MoveMemory(data, psz, len * 2);
        if (free) {
            OS.CoTaskMemFree(psz);
        }
        return String.valueOf(data);
    }

    static String bstrToString(long bstr) {
        if (bstr == 0L) {
            return "";
        }
        int len = COM.SysStringLen(bstr);
        char[] data = new char[len];
        OS.MoveMemory(data, bstr, len * 2);
        return String.valueOf(data);
    }

    static char[] stringToWstr(String s) {
        return s != null ? (s + "\u0000").toCharArray() : null;
    }

    static void error(int code, int hr) {
        SWT.error(code, null, String.format(" [0x%08x]", hr));
    }

    static IUnknown newCallback(ICoreWebView2SwtCallback handler) {
        long punk = COM.CreateSwtWebView2Callback(new HandleCoreWebView2SwtCallback(handler));
        if (punk == 0L) {
            Edge.error(2, -2147024882);
        }
        return new IUnknown(punk);
    }

    IUnknown newHostObject(ICoreWebView2SwtHost handler) {
        long pdisp = COM.CreateSwtWebView2Host(handler);
        if (pdisp == 0L) {
            Edge.error(2, -2147024882);
        }
        return new IUnknown(pdisp);
    }

    static int callAndWait(long[] ppv, ToIntFunction<IUnknown> callable) {
        int[] phr = new int[1];
        IUnknown completion = Edge.newCallback((result, pv) -> {
            nArray[0] = (int)result;
            if ((int)result == 0) {
                lArray[0] = pv;
                new IUnknown(pv).AddRef();
            }
            return 0;
        });
        ppv[0] = 0L;
        phr[0] = callable.applyAsInt(completion);
        Edge.processOSMessagesUntil(() -> phr[0] != 0 || ppv[0] != 0L, exception -> {
            throw exception;
        }, Display.getCurrent());
        completion.Release();
        return phr[0];
    }

    int callAndWait(String[] pstr, ToIntFunction<IUnknown> callable) {
        int[] phr = new int[1];
        IUnknown completion = Edge.newCallback((result, pszJson) -> {
            nArray[0] = (int)result;
            if ((int)result == 0) {
                stringArray[0] = Edge.wstrToString(pszJson, false);
            }
            return 0;
        });
        pstr[0] = null;
        phr[0] = callable.applyAsInt(completion);
        Edge.processOSMessagesUntil(() -> phr[0] != 0 || pstr[0] != null, exception -> {
            throw exception;
        }, this.browser.getDisplay());
        completion.Release();
        return phr[0];
    }

    private static void processOSMessagesUntil(Supplier<Boolean> condition, Consumer<SWTException> timeoutHandler, Display display) {
        MSG msg = new MSG();
        AtomicBoolean timeoutOccurred = new AtomicBoolean();
        display.timerExec((int)MAXIMUM_OPERATION_TIME.toMillis(), () -> timeoutOccurred.set(true));
        while (!(display.isDisposed() || condition.get().booleanValue() || timeoutOccurred.get())) {
            if (OS.PeekMessage(msg, 0L, 0, 0, 0x980000)) {
                display.readAndDispatch();
                continue;
            }
            display.sleep();
        }
        if (!condition.get().booleanValue()) {
            timeoutHandler.accept(Edge.createTimeOutException());
        }
    }

    private static SWTException createTimeOutException() {
        return new SWTException(1, "Waiting for Edge operation to terminate timed out");
    }

    static ICoreWebView2CookieManager getCookieManager() {
        WebViewEnvironment environmentWrapper = webViewEnvironments.get(Display.getCurrent());
        if (environmentWrapper == null) {
            SWT.error(5, null, " [WebView2: environment not initialized for current display]");
        }
        if (environmentWrapper.instances().isEmpty()) {
            SWT.error(20, null, " [WebView2: cookie access requires a Browser instance]");
        }
        Edge instance = environmentWrapper.instances().get(0);
        if (!instance.webViewProvider.isWebView_2Available()) {
            SWT.error(20, null, " [WebView2 version 88+ is required to access cookies]");
        }
        long[] ppv = new long[1];
        int hr = instance.webViewProvider.getWebView_2(true).get_CookieManager(ppv);
        if (hr != 0) {
            Edge.error(2, hr);
        }
        return new ICoreWebView2CookieManager(ppv[0]);
    }

    void checkDeadlock() {
        if (inCallback > 0 || this.inNewWindow) {
            SWT.error(50, null, " [WebView2: deadlock detected]");
        }
    }

    WebViewEnvironment createEnvironment() {
        Display display = Display.getCurrent();
        WebViewEnvironment existingEnvironment = webViewEnvironments.get(display);
        if (existingEnvironment != null) {
            return existingEnvironment;
        }
        String browserDir = System.getProperty(BROWSER_DIR_PROP);
        String browserArgs = System.getProperty(BROWSER_ARGS_PROP);
        String language = System.getProperty(LANGUAGE_PROP);
        boolean allowSSO = Boolean.getBoolean(ALLOW_SINGLE_SIGN_ON_USING_OS_PRIMARY_ACCOUNT_PROP);
        String dataDir = this.getDataDir(display);
        long pOpts = COM.CreateSwtWebView2Options();
        if (pOpts == 0L) {
            Edge.error(2, -2147024882);
        }
        ICoreWebView2EnvironmentOptions options = new ICoreWebView2EnvironmentOptions(pOpts);
        char[] pVersion = Edge.stringToWstr(SDK_TARGET_VERSION);
        options.put_TargetCompatibleBrowserVersion(pVersion);
        if (browserArgs != null) {
            char[] pBrowserArgs = Edge.stringToWstr(browserArgs);
            options.put_AdditionalBrowserArguments(pBrowserArgs);
        }
        if (language != null) {
            char[] pLanguage = Edge.stringToWstr(language);
            options.put_Language(pLanguage);
        }
        if (allowSSO) {
            int[] pAllowSSO = new int[]{1};
            options.put_AllowSingleSignOnUsingOSPrimaryAccount(pAllowSSO);
        }
        char[] pBrowserDir = Edge.stringToWstr(browserDir);
        char[] pDataDir = Edge.stringToWstr(dataDir);
        long[] ppv = new long[1];
        int hr = Edge.callAndWait(ppv, completion -> COM.CreateCoreWebView2EnvironmentWithOptions(pBrowserDir, pDataDir, options.getAddress(), completion.getAddress()));
        options.Release();
        if (hr == OS.HRESULT_FROM_WIN32(2)) {
            SWT.error(20, null, " [WebView2 runtime not found]");
        }
        if (hr != 0) {
            Edge.error(2, hr);
        }
        ICoreWebView2Environment environment = new ICoreWebView2Environment(ppv[0]);
        WebViewEnvironment environmentWrapper = new WebViewEnvironment(environment);
        long[] ppVersion = new long[1];
        environment.get_BrowserVersionString(ppVersion);
        String version = Edge.wstrToString(ppVersion[0], true);
        System.setProperty(VERSIONT_PROP, version);
        display.disposeExec(() -> {
            for (Edge instance : environmentWrapper.instances()) {
                instance.browserDispose(null);
            }
            environment.Release();
            webViewEnvironments.remove(display);
        });
        webViewEnvironments.put(display, environmentWrapper);
        return environmentWrapper;
    }

    private String getDataDir(Display display) {
        String dataDir = System.getProperty(DATA_DIR_PROP);
        if (dataDir == null) {
            dataDir = (String)display.getData(EDGE_USER_DATA_FOLDER);
        }
        if (dataDir == null) {
            dataDir = (String)display.getData(APPLOCAL_DIR_KEY);
        }
        return dataDir;
    }

    @Override
    public void create(Composite parent, int style) {
        this.createInstance(0);
    }

    private void createInstance(int previousAttempts) {
        this.containingEnvironment = this.createEnvironment();
        this.containingEnvironment.instances().add(this);
        long[] ppv = new long[1];
        int hr = this.containingEnvironment.environment().QueryInterface(COM.IID_ICoreWebView2Environment2, ppv);
        if (hr == 0) {
            this.environment2 = new ICoreWebView2Environment2(ppv[0]);
        }
        this.containingEnvironment.environment().CreateCoreWebView2Controller(this.browser.handle, this.createControllerInitializationCallback(previousAttempts));
    }

    private IUnknown createControllerInitializationCallback(int previousAttempts) {
        Runnable initializationAbortion = () -> {
            this.webViewProvider.abortInitialization();
            this.releaseEnvironment();
        };
        return Edge.newCallback((resultAsLong, pv) -> {
            int result = (int)resultAsLong;
            if (this.browser.isDisposed()) {
                initializationAbortion.run();
                return 0;
            }
            if (result == OS.HRESULT_FROM_WIN32(5023)) {
                initializationAbortion.run();
                SWT.error(5, null, " Edge instance with same data folder but different environment options already exists");
            }
            switch (result) {
                case 0: {
                    new IUnknown(pv).AddRef();
                    this.setupBrowser(result, pv);
                    break;
                }
                case -2144731124: {
                    initializationAbortion.run();
                    Edge.error(22, result);
                    break;
                }
                case -2147467260: {
                    initializationAbortion.run();
                    break;
                }
                default: {
                    this.releaseEnvironment();
                    if (previousAttempts < 5) {
                        System.err.println(String.format("Edge initialization failed, retrying (attempt %d / %d)", previousAttempts + 1, 5));
                        this.createInstance(previousAttempts + 1);
                        break;
                    }
                    SWT.error(1, null, String.format(" Aborting Edge initialiation after %d retries with result %d", 5, result));
                }
            }
            return 0;
        });
    }

    private void releaseEnvironment() {
        if (this.environment2 != null) {
            this.environment2.Release();
            this.environment2 = null;
        }
        this.containingEnvironment.instances().remove(this);
    }

    void setupBrowser(int hr, long pv) {
        long[] ppv = new long[]{pv};
        this.controller = new ICoreWebView2Controller(ppv[0]);
        ICoreWebView2 webView = this.webViewProvider.initializeWebView(this.controller);
        if (webView == null) {
            this.controller.Release();
            this.releaseEnvironment();
            return;
        }
        webView.get_Settings(ppv);
        this.settings = new ICoreWebView2Settings(ppv[0]);
        if (this.webViewProvider.isWebView_12Available()) {
            this.settings.put_IsStatusBarEnabled(false);
        }
        if (this.webViewProvider.isWebView_13Available()) {
            this.webViewProvider.getWebView_13(false).get_Profile(ppv);
            this.profile = new ICoreWebView2Profile(ppv[0]);
            if (Boolean.TRUE.equals(this.browser.getDisplay().getData(EDGE_USE_DARK_PREFERED_COLOR_SCHEME))) {
                this.profile.put_PreferredColorScheme(2L);
            } else {
                this.profile.put_PreferredColorScheme(1L);
            }
        }
        long[] token = new long[1];
        IUnknown handler = Edge.newCallback(this::handleCloseRequested);
        webView.add_WindowCloseRequested(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleNavigationStarting);
        webView.add_NavigationStarting(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleFrameNavigationStarting);
        webView.add_FrameNavigationStarting(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleNavigationCompleted);
        webView.add_NavigationCompleted(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleFrameNavigationCompleted);
        webView.add_FrameNavigationCompleted(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleDocumentTitleChanged);
        webView.add_DocumentTitleChanged(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleNewWindowRequested);
        webView.add_NewWindowRequested(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleSourceChanged);
        webView.add_SourceChanged(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleMoveFocusRequested);
        this.controller.add_MoveFocusRequested(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleGotFocus);
        this.controller.add_GotFocus(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleAcceleratorKeyPressed);
        this.controller.add_AcceleratorKeyPressed(handler, token);
        handler.Release();
        if (this.webViewProvider.isWebView_2Available()) {
            handler = Edge.newCallback(this::handleDOMContentLoaded);
            this.webViewProvider.getWebView_2(false).add_DOMContentLoaded(handler, token);
            handler.Release();
        }
        if (this.webViewProvider.isWebView_10Available()) {
            handler = Edge.newCallback(this::handleBasicAuthenticationRequested);
            this.webViewProvider.getWebView_10(false).add_BasicAuthenticationRequested(handler, token);
            handler.Release();
        }
        if (this.webViewProvider.isWebView_11Available()) {
            handler = Edge.newCallback(this::handleContextMenuRequested);
            this.webViewProvider.getWebView_11(false).add_ContextMenuRequested(handler, token);
            handler.Release();
        }
        if (this.webViewProvider.isWebView_12Available()) {
            handler = Edge.newCallback(this::handleStatusBarTextChanged);
            this.webViewProvider.getWebView_12(false).add_StatusBarTextChanged(handler, token);
            handler.Release();
        }
        IUnknown hostDisp = this.newHostObject(new HandleCoreWebView2SwtHost(this.functions));
        long[] lArray = new long[3];
        lArray[0] = 9L;
        lArray[1] = hostDisp.getAddress();
        long[] hostObj = lArray;
        webView.AddHostObjectToScript("swt\u0000".toCharArray(), hostObj);
        hostDisp.Release();
        this.browser.addListener(12, this::browserDispose);
        this.browser.addListener(15, this::browserFocusIn);
        this.browser.addListener(11, this::browserResize);
        this.browser.addListener(10, this::browserMove);
        this.scheduleMouseMovementHandling();
        this.browserResize(new Event());
        if (this.browser.isFocusControl()) {
            this.browserFocusIn(new Event());
        }
    }

    void browserDispose(Event event) {
        this.containingEnvironment.instances.remove(this);
        this.webViewProvider.scheduleWebViewTask(() -> {
            this.webViewProvider.releaseWebView();
            if (this.environment2 != null) {
                this.environment2.Release();
            }
            if (this.settings != null) {
                this.settings.Release();
            }
            if (this.controller != null) {
                if (inCallback > 0) {
                    ICoreWebView2Controller controller1 = this.controller;
                    this.controller.put_IsVisible(false);
                    this.browser.getDisplay().asyncExec(() -> {
                        controller1.Close();
                        controller1.Release();
                    });
                } else {
                    this.controller.Close();
                    this.controller.Release();
                }
                this.controller = null;
            }
            this.environment2 = null;
            this.settings = null;
        });
    }

    void browserFocusIn(Event event) {
        if (this.ignoreFocusIn) {
            return;
        }
        this.ignoreGotFocus = true;
        this.controller.MoveFocus(0);
    }

    void browserMove(Event event) {
        this.controller.NotifyParentWindowPositionChanged();
    }

    void browserResize(Event event) {
        RECT rect = new RECT();
        OS.GetClientRect(this.browser.handle, rect);
        this.controller.put_Bounds(rect);
        this.controller.put_IsVisible(true);
    }

    private void scheduleMouseMovementHandling() {
        this.browser.getDisplay().timerExec(100, () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            if (this.browser.isVisible() && this.hasDisplayFocus()) {
                this.handleMouseMovement();
            }
            this.scheduleMouseMovementHandling();
        });
    }

    private void handleMouseMovement() {
        boolean mouseMovedInsideBrowser;
        Point currentCursorLocation = this.browser.getDisplay().getCursorLocation();
        Point cursorLocationInControlCoordinate = this.browser.toControl(currentCursorLocation);
        boolean isCursorInsideBrowser = this.browser.getBounds().contains(cursorLocationInControlCoordinate);
        boolean hasCursorLocationChanged = !currentCursorLocation.equals(this.previousCursorPosition.location);
        boolean mousePassedBrowserBorder = this.previousCursorPosition.isInsideBrowser ^ isCursorInsideBrowser;
        boolean bl = mouseMovedInsideBrowser = isCursorInsideBrowser && hasCursorLocationChanged;
        if (mousePassedBrowserBorder) {
            if (isCursorInsideBrowser) {
                this.sendMouseEvent(cursorLocationInControlCoordinate, 6);
            } else {
                this.sendMouseEvent(cursorLocationInControlCoordinate, 7);
            }
        } else if (mouseMovedInsideBrowser) {
            this.sendMouseEvent(cursorLocationInControlCoordinate, 5);
        }
        this.previousCursorPosition = new CursorPosition(currentCursorLocation, isCursorInsideBrowser);
    }

    private void sendMouseEvent(Point cursorLocationInControlCoordinate, int mouseEvent) {
        Event newEvent = new Event();
        newEvent.widget = this.browser;
        Point position = cursorLocationInControlCoordinate;
        newEvent.x = position.x;
        newEvent.y = position.y;
        newEvent.type = mouseEvent;
        this.browser.notifyListeners(newEvent.type, newEvent);
    }

    private boolean hasDisplayFocus() {
        return this.browser.getDisplay().getFocusControl() != null;
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        if (!this.jsEnabled) {
            return null;
        }
        return this.evaluateInternal(script);
    }

    private Object evaluateInternal(String script) throws SWTException {
        if (inCallback > 0) {
            this.execute(script);
            return null;
        }
        String script2 = "(function() {try { " + script + " } catch (e) { return 'org.eclipse.swt.browser.error' + e.message; } })();\u0000";
        String[] pJson = new String[1];
        this.inEvaluate = true;
        try {
            int hr = this.callAndWait(pJson, completion -> this.webViewProvider.getWebView(true).ExecuteScript(script2.toCharArray(), (IUnknown)completion));
            if (hr != 0) {
                Edge.error(50, hr);
            }
        }
        finally {
            this.inEvaluate = false;
        }
        Object data = JSON.parse(pJson[0]);
        if (data instanceof String && ((String)data).startsWith("org.eclipse.swt.browser.error")) {
            String errorMessage = ((String)data).substring("org.eclipse.swt.browser.error".length());
            throw new SWTException(50, errorMessage);
        }
        return data;
    }

    @Override
    public boolean execute(String script) {
        if (!this.jsEnabled) {
            return false;
        }
        IUnknown completion = Edge.newCallback((result, json) -> 0);
        int hr = this.webViewProvider.getWebView(true).ExecuteScript(Edge.stringToWstr(script), completion);
        completion.Release();
        return hr == 0;
    }

    @Override
    public String getBrowserType() {
        return "edge";
    }

    @Override
    String getJavaCallDeclaration() {
        return "if (!window.callJava) { window.callJava = function(index, token, args) {\nreturn JSON.parse(window.chrome.webview.hostObjects.sync.swt.CallJava(index, token, JSON.stringify(args)));\n}};\n";
    }

    @Override
    public String getText() {
        return (String)this.evaluateInternal("return document.documentElement.outerHTML;");
    }

    @Override
    public String getUrl() {
        long[] ppsz = new long[1];
        this.webViewProvider.getWebView(true).get_Source(ppsz);
        return this.getExposedUrl(Edge.wstrToString(ppsz[0], true));
    }

    private String getExposedUrl(String url) {
        return Edge.isLocationForCustomText(url) ? ABOUT_BLANK : url;
    }

    int handleCloseRequested(long pView, long pArgs) {
        this.browser.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            WindowEvent event = new WindowEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
            int n = this.closeWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                CloseWindowListener listener = closeWindowListenerArray[n2];
                listener.close(event);
                if (this.browser.isDisposed()) {
                    return;
                }
                ++n2;
            }
            this.browser.dispose();
        });
        return 0;
    }

    int handleDocumentTitleChanged(long pView, long pArgs) {
        long[] ppsz = new long[1];
        this.webViewProvider.getWebView(false).get_DocumentTitle(ppsz);
        String title = Edge.wstrToString(ppsz[0], true);
        this.browser.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            TitleEvent event = new TitleEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            event.title = title;
            TitleListener[] titleListenerArray = this.titleListeners;
            int n = this.titleListeners.length;
            int n2 = 0;
            while (n2 < n) {
                TitleListener listener = titleListenerArray[n2];
                listener.changed(event);
                if (this.browser.isDisposed()) {
                    return;
                }
                ++n2;
            }
        });
        return 0;
    }

    int handleFrameNavigationStarting(long pView, long pArgs) {
        return this.handleNavigationStarting(pView, pArgs, false);
    }

    int handleNavigationStarting(long pView, long pArgs) {
        return this.handleNavigationStarting(pView, pArgs, true);
    }

    int handleNavigationStarting(long pView, long pArgs, boolean top) {
        ICoreWebView2NavigationStartingEventArgs args = new ICoreWebView2NavigationStartingEventArgs(pArgs);
        long[] ppszUrl = new long[1];
        int hr = args.get_Uri(ppszUrl);
        if (hr != 0) {
            return hr;
        }
        String url = this.getExposedUrl(Edge.wstrToString(ppszUrl[0], true));
        long[] pNavId = new long[1];
        args.get_NavigationId(pNavId);
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = url;
        event.top = top;
        event.doit = true;
        LocationListener[] locationListenerArray = this.locationListeners;
        int n = this.locationListeners.length;
        int n2 = 0;
        while (n2 < n) {
            LocationListener listener = locationListenerArray[n2];
            listener.changing(event);
            if (this.browser.isDisposed()) {
                return 0;
            }
            ++n2;
        }
        this.navigations.put(pNavId[0], event);
        if (event.doit) {
            this.jsEnabled = this.jsEnabledOnNextPage;
            this.settings.put_IsScriptEnabled(this.jsEnabled);
            if (!this.functions.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (BrowserFunction function : this.functions.values()) {
                    sb.append(function.functionString);
                }
                this.execute(sb.toString());
            }
        } else {
            args.put_Cancel(true);
        }
        return 0;
    }

    int handleSourceChanged(long pView, long pArgs) {
        int[] isNewDocument = new int[1];
        ICoreWebView2SourceChangedEventArgs args = new ICoreWebView2SourceChangedEventArgs(pArgs);
        args.get_IsNewDocument(isNewDocument);
        if (isNewDocument[0] == 0) {
            String urlWithoutFragment;
            long[] ppsz = new long[1];
            int hr = this.webViewProvider.getWebView(true).get_Source(ppsz);
            if (hr != 0) {
                return hr;
            }
            String url = Edge.wstrToString(ppsz[0], true);
            int fragmentIndex = url.indexOf(35);
            String string = urlWithoutFragment = fragmentIndex == -1 ? url : url.substring(0, fragmentIndex);
            Object location = Edge.isLocationForCustomText(urlWithoutFragment) ? (fragmentIndex != -1 ? ABOUT_BLANK.toString() + url.substring(fragmentIndex) : ABOUT_BLANK.toString()) : url;
            this.browser.getDisplay().asyncExec(() -> this.lambda$42((String)location));
        }
        return 0;
    }

    void sendProgressCompleted() {
        this.browser.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            ProgressEvent event = new ProgressEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            ProgressListener[] progressListenerArray = this.progressListeners;
            int n = this.progressListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressListener listener = progressListenerArray[n2];
                listener.completed(event);
                if (this.browser.isDisposed()) {
                    return;
                }
                ++n2;
            }
        });
    }

    int handleDOMContentLoaded(long pView, long pArgs) {
        ICoreWebView2DOMContentLoadedEventArgs args = new ICoreWebView2DOMContentLoadedEventArgs(pArgs);
        long[] pNavId = new long[1];
        args.get_NavigationId(pNavId);
        LocationEvent startEvent = this.navigations.get(pNavId[0]);
        if (startEvent != null && startEvent.top) {
            if (this.lastCustomText != null && this.getUrl().equals(ABOUT_BLANK)) {
                IUnknown postExecute = Edge.newCallback((result, json) -> {
                    this.sendProgressCompleted();
                    return 0;
                });
                this.webViewProvider.getWebView(true).ExecuteScript(Edge.stringToWstr("document.open(); document.write('" + Edge.escapeForSingleQuotedJSString(this.lastCustomText) + "'); document.close();"), postExecute);
                postExecute.Release();
                this.lastCustomText = null;
            } else {
                this.sendProgressCompleted();
            }
        }
        return 0;
    }

    private static String escapeForSingleQuotedJSString(String str) {
        return str.replace("\\", "\\\\").replace("'", "\\'").replace("\r", "\\r").replace("\n", "\\n");
    }

    int handleBasicAuthenticationRequested(long pView, long pArgs) {
        ICoreWebView2BasicAuthenticationRequestedEventArgs args = new ICoreWebView2BasicAuthenticationRequestedEventArgs(pArgs);
        long[] ppv = new long[1];
        args.get_Uri(ppv);
        String uri = Edge.wstrToString(ppv[0], true);
        AuthenticationListener[] authenticationListenerArray = this.authenticationListeners;
        int n = this.authenticationListeners.length;
        int n2 = 0;
        while (n2 < n) {
            AuthenticationListener authenticationListener = authenticationListenerArray[n2];
            AuthenticationEvent event = new AuthenticationEvent(this.browser);
            event.location = uri;
            authenticationListener.authenticate(event);
            if (!event.doit) {
                args.put_Cancel(true);
                return 0;
            }
            if (event.user != null && event.password != null) {
                args.get_Response(ppv);
                ICoreWebView2BasicAuthenticationResponse response = new ICoreWebView2BasicAuthenticationResponse(ppv[0]);
                response.put_UserName(Edge.stringToWstr(event.user));
                response.put_Password(Edge.stringToWstr(event.password));
                return 0;
            }
            ++n2;
        }
        return 0;
    }

    int handleContextMenuRequested(long pView, long pArgs) {
        ICoreWebView2ContextMenuRequestedEventArgs args = new ICoreWebView2ContextMenuRequestedEventArgs(pArgs);
        long[] locationPointer = new long[1];
        args.get_Location(locationPointer);
        POINT win32Point = new POINT();
        OS.MoveMemory(win32Point, locationPointer, POINT.sizeof);
        Point pt = new Point(DPIUtil.scaleUp(win32Point.x, DPIUtil.getNativeDeviceZoom()), DPIUtil.scaleUp(win32Point.y, DPIUtil.getNativeDeviceZoom()));
        pt = new Point(DPIUtil.scaleDown(pt.x, DPIUtil.getZoomForAutoscaleProperty(this.browser.getShell().nativeZoom)), DPIUtil.scaleDown(pt.y, DPIUtil.getZoomForAutoscaleProperty(this.browser.getShell().nativeZoom)));
        pt = this.browser.toDisplay(pt.x, pt.y);
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            args.put_Handled(true);
        } else {
            Menu menu = this.browser.getMenu();
            if (menu != null && !menu.isDisposed()) {
                args.put_Handled(true);
                if (pt.x != event.x || pt.y != event.y) {
                    menu.setLocation(event.x, event.y);
                }
                menu.setVisible(true);
            }
        }
        return 0;
    }

    int handleStatusBarTextChanged(long pView, long pArgs) {
        long[] ppsz = new long[1];
        this.webViewProvider.getWebView_12(true).get_StatusBarText(ppsz);
        String text = Edge.wstrToString(ppsz[0], true);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = text;
        StatusTextListener[] statusTextListenerArray = this.statusTextListeners;
        int n = this.statusTextListeners.length;
        int n2 = 0;
        while (n2 < n) {
            StatusTextListener statusTextListener = statusTextListenerArray[n2];
            statusTextListener.changed(statusTextEvent);
            ++n2;
        }
        return 0;
    }

    int handleNavigationCompleted(long pView, long pArgs) {
        return this.handleNavigationCompleted(pView, pArgs, true);
    }

    int handleFrameNavigationCompleted(long pView, long pArgs) {
        return this.handleNavigationCompleted(pView, pArgs, false);
    }

    int handleNavigationCompleted(long pView, long pArgs, boolean top) {
        ICoreWebView2NavigationCompletedEventArgs args = new ICoreWebView2NavigationCompletedEventArgs(pArgs);
        long[] pNavId = new long[1];
        args.get_NavigationId(pNavId);
        LocationEvent startEvent = this.navigations.remove(pNavId[0]);
        if (startEvent == null) {
            return 0;
        }
        if (!this.webViewProvider.isWebView_2Available() && startEvent.top) {
            this.sendProgressCompleted();
        }
        int[] pIsSuccess = new int[1];
        args.get_IsSuccess(pIsSuccess);
        if (pIsSuccess[0] != 0) {
            this.browser.getDisplay().asyncExec(() -> {
                if (this.browser.isDisposed()) {
                    return;
                }
                LocationEvent event = new LocationEvent(this.browser);
                event.display = this.browser.getDisplay();
                event.widget = this.browser;
                event.location = locationEvent.location;
                event.top = locationEvent.top;
                LocationListener[] locationListenerArray = this.locationListeners;
                int n = this.locationListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    LocationListener listener = locationListenerArray[n2];
                    listener.changed(event);
                    if (this.browser.isDisposed()) {
                        return;
                    }
                    ++n2;
                }
            });
        }
        return 0;
    }

    void updateWindowFeatures(ICoreWebView2NewWindowRequestedEventArgs args, WindowEvent event) {
        long[] ppv = new long[1];
        int hr = args.get_WindowFeatures(ppv);
        if (hr != 0) {
            return;
        }
        ICoreWebView2WindowFeatures features = new ICoreWebView2WindowFeatures(ppv[0]);
        int[] px = new int[1];
        int[] py = new int[1];
        features.get_HasPosition(px);
        if (px[0] != 0) {
            features.get_Left(px);
            features.get_Top(py);
            event.location = new Point(px[0], py[0]);
        }
        features.get_HasSize(px);
        if (px[0] != 0) {
            features.get_Width(px);
            features.get_Height(py);
            event.size = new Point(px[0], py[0]);
        }
        features.get_ShouldDisplayMenuBar(px);
        event.menuBar = px[0] != 0;
        features.get_ShouldDisplayStatus(px);
        event.statusBar = px[0] != 0;
        features.get_ShouldDisplayToolbar(px);
        event.toolBar = px[0] != 0;
    }

    int handleNewWindowRequested(long pView, long pArgs) {
        ICoreWebView2NewWindowRequestedEventArgs args = new ICoreWebView2NewWindowRequestedEventArgs(pArgs);
        args.AddRef();
        long[] ppv = new long[1];
        args.GetDeferral(ppv);
        ICoreWebView2Deferral deferral = new ICoreWebView2Deferral(ppv[0]);
        this.inNewWindow = true;
        Runnable openWindowHandler = () -> {
            try {
                if (this.browser.isDisposed()) {
                    return;
                }
                WindowEvent openEvent = new WindowEvent(this.browser);
                openEvent.display = this.browser.getDisplay();
                openEvent.widget = this.browser;
                openEvent.required = false;
                OpenWindowListener[] openWindowListenerArray = this.openWindowListeners;
                int n = this.openWindowListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    OpenWindowListener openListener = openWindowListenerArray[n2];
                    openListener.open(openEvent);
                    if (this.browser.isDisposed()) {
                        return;
                    }
                    ++n2;
                }
                if (openEvent.browser != null && !openEvent.browser.isDisposed()) {
                    WebBrowser other = openEvent.browser.webBrowser;
                    args.put_Handled(true);
                    if (other instanceof Edge) {
                        Edge otherEdge = (Edge)other;
                        args.put_NewWindow(otherEdge.webViewProvider.getWebView(true).getAddress());
                        WindowEvent showEvent = new WindowEvent(other.browser);
                        showEvent.display = this.browser.getDisplay();
                        showEvent.widget = other.browser;
                        this.updateWindowFeatures(args, showEvent);
                        VisibilityWindowListener[] visibilityWindowListenerArray = other.visibilityWindowListeners;
                        int n3 = other.visibilityWindowListeners.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            VisibilityWindowListener showListener = visibilityWindowListenerArray[n4];
                            showListener.show(showEvent);
                            if (other.browser.isDisposed()) {
                                return;
                            }
                            ++n4;
                        }
                    }
                } else if (openEvent.required) {
                    args.put_Handled(true);
                }
            }
            finally {
                deferral.Complete();
                deferral.Release();
                args.Release();
                this.inNewWindow = false;
            }
        };
        if (this.inEvaluate) {
            openWindowHandler.run();
        } else {
            this.browser.getDisplay().asyncExec(openWindowHandler);
        }
        return 0;
    }

    int handleGotFocus(long pView, long pArg) {
        if (this.ignoreGotFocus) {
            this.ignoreGotFocus = false;
            return 0;
        }
        this.ignoreFocusIn = true;
        OS.SendMessage(this.browser.handle, 7, 0L, 0L);
        this.ignoreFocusIn = false;
        return 0;
    }

    int handleAcceleratorKeyPressed(long pView, long pArgs) {
        boolean isDown;
        ICoreWebView2AcceleratorKeyPressedEventArgs args = new ICoreWebView2AcceleratorKeyPressedEventArgs(pArgs);
        int[] virtualKey = new int[1];
        args.get_VirtualKey(virtualKey);
        int[] lparam = new int[1];
        args.get_KeyEventLParam(lparam);
        long flags = Integer.toUnsignedLong(lparam[0]) >> 16;
        boolean bl = isDown = (flags & 0x8000L) == 0L;
        if (virtualKey[0] == 16 || virtualKey[0] == 17 || virtualKey[0] == 18) {
            return 0;
        }
        Event keyEvent = new Event();
        keyEvent.widget = this.browser;
        keyEvent.keyCode = this.translateKey(virtualKey[0]);
        if (OS.GetKeyState(18) < 0) {
            keyEvent.stateMask |= 0x10000;
        }
        if (OS.GetKeyState(16) < 0) {
            keyEvent.stateMask |= 0x20000;
        }
        if (OS.GetKeyState(17) < 0) {
            keyEvent.stateMask |= 0x40000;
        }
        if (isDown) {
            boolean isRepeat;
            keyEvent.type = 1;
            boolean bl2 = isRepeat = (flags & 0x4000L) != 0L;
            if (isRepeat) {
                return 0;
            }
            if (!this.sendKeyEvent(keyEvent)) {
                args.put_Handled(true);
            }
        } else {
            keyEvent.type = 2;
            this.browser.notifyListeners(keyEvent.type, keyEvent);
            if (!keyEvent.doit) {
                args.put_Handled(true);
            }
        }
        return 0;
    }

    int handleMoveFocusRequested(long pView, long pArgs) {
        ICoreWebView2MoveFocusRequestedEventArgs args = new ICoreWebView2MoveFocusRequestedEventArgs(pArgs);
        int[] pReason = new int[1];
        args.get_Reason(pReason);
        args.put_Handled(true);
        switch (pReason[0]) {
            case 1: {
                this.browser.traverse(16);
                break;
            }
            case 2: {
                this.browser.traverse(8);
            }
        }
        return 0;
    }

    @Override
    public boolean isBackEnabled() {
        int[] pval = new int[1];
        this.webViewProvider.getWebView(true).get_CanGoBack(pval);
        return pval[0] != 0;
    }

    @Override
    public boolean isForwardEnabled() {
        int[] pval = new int[1];
        this.webViewProvider.getWebView(true).get_CanGoForward(pval);
        return pval[0] != 0;
    }

    @Override
    public boolean back() {
        return this.isBackEnabled() && this.webViewProvider.getWebView(true).GoBack() == 0;
    }

    @Override
    public boolean forward() {
        return this.isForwardEnabled() && this.webViewProvider.getWebView(true).GoForward() == 0;
    }

    @Override
    public void refresh() {
        this.webViewProvider.scheduleWebViewTask(() -> {
            int n = this.webViewProvider.getWebView(false).Reload();
        });
    }

    @Override
    public void stop() {
        this.webViewProvider.scheduleWebViewTask(() -> {
            int n = this.webViewProvider.getWebView(false).Stop();
        });
    }

    static boolean isLocationForCustomText(String location) {
        try {
            URI locationUri = new URI(location);
            return "file".equals(locationUri.getScheme()) && Path.of(URI_FOR_CUSTOM_TEXT_PAGE).equals(Path.of(locationUri));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return false;
        }
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        return this.setWebpageData(URI_FOR_CUSTOM_TEXT_PAGE.toString(), null, null, html);
    }

    private boolean setWebpageData(String url, String postData, String[] headers, String html) {
        if (!((String)url).matches("[a-z][a-z0-9+.-]*:.*")) {
            url = "http://" + (String)url;
        }
        char[] pszUrl = Edge.stringToWstr((String)url);
        if (Edge.isLocationForCustomText((String)url)) {
            this.lastCustomText = html;
        }
        if (postData != null || headers != null) {
            if (this.environment2 == null || !this.webViewProvider.isWebView_2Available()) {
                SWT.error(20, null, " [WebView2 version 88+ is required to set postData and headers]");
            }
            long[] ppRequest = new long[1];
            char[] pszMethod = null;
            char[] pszHeaders = null;
            IUnknown stream = null;
            if (postData != null) {
                pszMethod = "POST\u0000".toCharArray();
                byte[] postDataBytes = postData.getBytes(StandardCharsets.UTF_8);
                long pStream = COM.SHCreateMemStream(postDataBytes, postData.length());
                if (pStream == 0L) {
                    Edge.error(2, -2147024882);
                }
                stream = new IStream(pStream);
            } else {
                pszMethod = "GET\u0000".toCharArray();
            }
            if (headers != null) {
                String hblock = String.join((CharSequence)"\r\n", Arrays.asList(headers));
                pszHeaders = new char[hblock.length() + 1];
                hblock.getChars(0, hblock.length(), pszHeaders, 0);
            }
            int hr = this.environment2.CreateWebResourceRequest(pszUrl, pszMethod, (IStream)stream, pszHeaders, ppRequest);
            if (stream != null) {
                stream.Release();
            }
            if (hr != 0) {
                Edge.error(2, hr);
            }
            IUnknown request = new IUnknown(ppRequest[0]);
            this.webViewProvider.scheduleWebViewTask(() -> {
                this.webViewProvider.getWebView_2(false).NavigateWithWebResourceRequest(request);
                request.Release();
            });
        } else {
            this.webViewProvider.scheduleWebViewTask(() -> {
                int n = this.webViewProvider.getWebView(false).Navigate(pszUrl);
            });
        }
        return true;
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        return this.setWebpageData(url, postData, headers, null);
    }

    private /* synthetic */ void lambda$42(String string) {
        if (this.browser.isDisposed()) {
            return;
        }
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = string;
        event.top = true;
        LocationListener[] locationListenerArray = this.locationListeners;
        int n = this.locationListeners.length;
        int n2 = 0;
        while (n2 < n) {
            LocationListener listener = locationListenerArray[n2];
            listener.changed(event);
            if (this.browser.isDisposed()) {
                return;
            }
            ++n2;
        }
    }

    private record CursorPosition(Point location, boolean isInsideBrowser) {
    }

    static class HandleCoreWebView2SwtCallback
    implements ICoreWebView2SwtCallback {
        private final ICoreWebView2SwtCallback handler;

        public HandleCoreWebView2SwtCallback(ICoreWebView2SwtCallback handler) {
            this.handler = handler;
        }

        @Override
        public int Invoke(long arg0, long arg1) {
            ++inCallback;
            try {
                int n = this.handler.Invoke(arg0, arg1);
                return n;
            }
            finally {
                --inCallback;
            }
        }
    }

    static class HandleCoreWebView2SwtHost
    implements ICoreWebView2SwtHost {
        private final Map<Integer, BrowserFunction> functions;

        public HandleCoreWebView2SwtHost(Map<Integer, BrowserFunction> functions) {
            this.functions = functions;
        }

        @Override
        public long CallJava(int index, long bstrToken, long bstrArgsJson) {
            Object result;
            block6: {
                result = null;
                String token = Edge.bstrToString(bstrToken);
                BrowserFunction function = this.functions.get(index);
                if (function != null && token.equals(function.token)) {
                    ++inCallback;
                    try {
                        try {
                            String argsJson = Edge.bstrToString(bstrArgsJson);
                            Object args = JSON.parse(argsJson.toCharArray());
                            result = function.function((Object[])args);
                        }
                        catch (Throwable e) {
                            result = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                            --inCallback;
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        --inCallback;
                        throw throwable;
                    }
                    --inCallback;
                }
            }
            String json = JSON.stringify(result);
            return COM.SysAllocStringLen(json.toCharArray(), json.length());
        }
    }

    private record WebViewEnvironment(ICoreWebView2Environment environment, List<Edge> instances) {
        public WebViewEnvironment(ICoreWebView2Environment environment) {
            this(environment, new CopyOnWriteArrayList<Edge>());
        }
    }

    class WebViewProvider {
        private CompletableFuture<WebViewWrapper> webViewWrapperFuture = this.wakeDisplayAfterFuture(new CompletableFuture());
        private CompletableFuture<Void> lastWebViewTask = this.webViewWrapperFuture.thenRun(() -> {});

        WebViewProvider() {
        }

        ICoreWebView2 initializeWebView(ICoreWebView2Controller controller) {
            long[] ppv = new long[1];
            controller.get_CoreWebView2(ppv);
            ICoreWebView2 webView = new ICoreWebView2(ppv[0]);
            WebViewWrapper webViewWrapper = new WebViewWrapper();
            webViewWrapper.webView = webView;
            webViewWrapper.webView_2 = this.initializeWebView_2(webView);
            webViewWrapper.webView_10 = this.initializeWebView_10(webView);
            webViewWrapper.webView_11 = this.initializeWebView_11(webView);
            webViewWrapper.webView_12 = this.initializeWebView_12(webView);
            webViewWrapper.webView_13 = this.initializeWebView_13(webView);
            boolean success = this.webViewWrapperFuture.complete(webViewWrapper);
            if (!success && this.webViewWrapperFuture.isCompletedExceptionally()) {
                webViewWrapper.releaseWebViews();
                return null;
            }
            return webView;
        }

        private void abortInitialization() {
            this.webViewWrapperFuture.cancel(true);
        }

        void releaseWebView() {
            this.getWebViewWrapper().releaseWebViews();
        }

        private ICoreWebView2_2 initializeWebView_2(ICoreWebView2 webView) {
            long[] ppv = new long[1];
            int hr = webView.QueryInterface(COM.IID_ICoreWebView2_2, ppv);
            if (hr == 0) {
                return new ICoreWebView2_2(ppv[0]);
            }
            return null;
        }

        private ICoreWebView2_10 initializeWebView_10(ICoreWebView2 webView) {
            long[] ppv = new long[1];
            int hr = webView.QueryInterface(COM.IID_ICoreWebView2_10, ppv);
            if (hr == 0) {
                return new ICoreWebView2_10(ppv[0]);
            }
            return null;
        }

        private ICoreWebView2_11 initializeWebView_11(ICoreWebView2 webView) {
            long[] ppv = new long[1];
            int hr = webView.QueryInterface(COM.IID_ICoreWebView2_11, ppv);
            if (hr == 0) {
                return new ICoreWebView2_11(ppv[0]);
            }
            return null;
        }

        private ICoreWebView2_12 initializeWebView_12(ICoreWebView2 webView) {
            long[] ppv = new long[1];
            int hr = webView.QueryInterface(COM.IID_ICoreWebView2_12, ppv);
            if (hr == 0) {
                return new ICoreWebView2_12(ppv[0]);
            }
            return null;
        }

        private ICoreWebView2_13 initializeWebView_13(ICoreWebView2 webView) {
            long[] ppv = new long[1];
            int hr = webView.QueryInterface(COM.IID_ICoreWebView2_13, ppv);
            if (hr == 0) {
                return new ICoreWebView2_13(ppv[0]);
            }
            return null;
        }

        private WebViewWrapper getWebViewWrapper(boolean waitForPendingWebviewTasksToFinish) {
            WebViewWrapper webViewWrapper = this.getWebViewWrapper();
            if (waitForPendingWebviewTasksToFinish) {
                Edge.processOSMessagesUntil(this.lastWebViewTask::isDone, exception -> {
                    this.lastWebViewTask.completeExceptionally((Throwable)exception);
                    throw exception;
                }, Edge.this.browser.getDisplay());
            }
            return webViewWrapper;
        }

        private WebViewWrapper getWebViewWrapper() {
            Edge.processOSMessagesUntil(this.webViewWrapperFuture::isDone, exception -> {
                this.webViewWrapperFuture.completeExceptionally((Throwable)exception);
                throw exception;
            }, Edge.this.browser.getDisplay());
            return this.webViewWrapperFuture.join();
        }

        ICoreWebView2 getWebView(boolean waitForPendingWebviewTasksToFinish) {
            return this.getWebViewWrapper((boolean)waitForPendingWebviewTasksToFinish).webView;
        }

        ICoreWebView2_2 getWebView_2(boolean waitForPendingWebviewTasksToFinish) {
            return this.getWebViewWrapper((boolean)waitForPendingWebviewTasksToFinish).webView_2;
        }

        boolean isWebView_2Available() {
            return this.getWebViewWrapper().webView_2 != null;
        }

        ICoreWebView2_10 getWebView_10(boolean waitForPendingWebviewTasksToFinish) {
            return this.getWebViewWrapper((boolean)waitForPendingWebviewTasksToFinish).webView_10;
        }

        boolean isWebView_10Available() {
            return this.getWebViewWrapper().webView_10 != null;
        }

        ICoreWebView2_11 getWebView_11(boolean waitForPendingWebviewTasksToFinish) {
            return this.getWebViewWrapper((boolean)waitForPendingWebviewTasksToFinish).webView_11;
        }

        boolean isWebView_11Available() {
            return this.getWebViewWrapper().webView_11 != null;
        }

        ICoreWebView2_12 getWebView_12(boolean waitForPendingWebviewTasksToFinish) {
            return this.getWebViewWrapper((boolean)waitForPendingWebviewTasksToFinish).webView_12;
        }

        boolean isWebView_12Available() {
            return this.getWebViewWrapper().webView_12 != null;
        }

        ICoreWebView2_13 getWebView_13(boolean waitForPendingWebviewTasksToFinish) {
            return this.getWebViewWrapper((boolean)waitForPendingWebviewTasksToFinish).webView_13;
        }

        boolean isWebView_13Available() {
            return this.getWebViewWrapper().webView_13 != null;
        }

        void scheduleWebViewTask(Runnable action) {
            this.lastWebViewTask = this.wakeDisplayAfterFuture((CompletableFuture)this.lastWebViewTask.thenRun(action::run));
        }

        private <T> CompletableFuture<T> wakeDisplayAfterFuture(CompletableFuture<T> future) {
            return future.handle((nil1, nil2) -> {
                Display display = Edge.this.browser.getDisplay();
                if (!display.isDisposed()) {
                    try {
                        display.wake();
                    }
                    catch (SWTException sWTException) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
    }

    class WebViewWrapper {
        private ICoreWebView2 webView;
        private ICoreWebView2_2 webView_2;
        private ICoreWebView2_10 webView_10;
        private ICoreWebView2_11 webView_11;
        private ICoreWebView2_12 webView_12;
        private ICoreWebView2_13 webView_13;

        WebViewWrapper() {
        }

        void releaseWebViews() {
            if (this.webView != null) {
                this.webView.Release();
                this.webView = null;
            }
            if (this.webView_2 != null) {
                this.webView_2.Release();
                this.webView_2 = null;
            }
            if (this.webView_10 != null) {
                this.webView_10.Release();
                this.webView_10 = null;
            }
            if (this.webView_11 != null) {
                this.webView_11.Release();
                this.webView_11 = null;
            }
            if (this.webView_12 != null) {
                this.webView_12.Release();
                this.webView_12 = null;
            }
            if (this.webView_13 != null) {
                this.webView_13.Release();
                this.webView_13 = null;
            }
        }
    }
}

