/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.api;

import com.sun.messaging.bridge.api.StompConnection;
import com.sun.messaging.bridge.api.StompDestination;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompFrameMessageFactory;
import com.sun.messaging.bridge.api.StompMessage;
import com.sun.messaging.bridge.api.StompNotConnectedException;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompSession;
import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.bridge.api.StompUnrecoverableAckException;
import com.sun.messaging.jmq.util.LoggerWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class StompProtocolHandler {
    protected LoggerWrapper logger = null;
    private static final String DEFAULT_SUBID_PREFIX = "/subscription-to/";
    private Map<String, StompDestination> tempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, StompDestination> tempTopics = Collections.synchronizedMap(new HashMap());
    private Map<String, StompDestination> mqtempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, StompDestination> mqtempTopics = Collections.synchronizedMap(new HashMap());
    protected List<String> subids = Collections.synchronizedList(new ArrayList());
    private String version = "1.0";
    protected StompConnection stompConnection = null;

    public final String getProtocolVersion() {
        return this.version;
    }

    protected StompProtocolHandler(LoggerWrapper loggerw) {
        this.logger = loggerw;
    }

    public boolean getDEBUG() {
        return false;
    }

    public void close(boolean spawnthread) {
        this.logger.logInfo(this.getKStringI_CLOSE_STOMP_CONN(this.stompConnection.toString()) + "(" + spawnthread + ")", null);
        if (!spawnthread) {
            try {
                this.stompConnection.disconnect(false);
                return;
            }
            catch (Throwable t) {
                this.logger.logWarn(this.getKStringW_CLOSE_STOMP_CONN_FAILED(this.stompConnection.toString(), t.getMessage()), null);
            }
        }
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StompProtocolHandler.this.logger.logInfo(StompProtocolHandler.this.getKStringI_CLOSE_STOMP_CONN(StompProtocolHandler.this.stompConnection.toString()), null);
                    StompProtocolHandler.this.stompConnection.disconnect(false);
                }
                catch (Throwable t) {
                    StompProtocolHandler.this.logger.logWarn(StompProtocolHandler.this.getKStringW_CLOSE_STOMP_CONN_FAILED(StompProtocolHandler.this.stompConnection.toString(), t.getMessage()), null);
                }
            }
        });
        thr.setName("SpawnedClosingThread");
        thr.setDaemon(true);
        thr.start();
    }

    public abstract StompFrameMessageFactory getStompFrameMessageFactory();

    public abstract String getTemporaryQueuePrefix();

    public abstract String getTemporaryTopicPrefix();

    public abstract String negotiateVersion(String var1) throws StompProtocolException;

    public abstract String getSupportedVersions();

    public abstract String getServerName();

    public void onCONNECT(StompFrameMessage message, StompOutputHandler out, Object ctx) {
        StompFrameMessage reply = null;
        String supportedVersions = null;
        try {
            String acceptversions = message.getHeader("accept-version");
            try {
                this.version = this.negotiateVersion(acceptversions);
            }
            catch (StompProtocolException e) {
                supportedVersions = this.getSupportedVersions();
                throw e;
            }
            String login = message.getHeader("login");
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", login=" + login, null);
            }
            String passcode = message.getHeader("passcode");
            String clientid = message.getHeader("client-id");
            String id = this.stompConnection.connect(login, passcode, clientid);
            reply = this.getStompFrameMessageFactory().newStompFrameMessage(StompFrameMessage.Command.CONNECTED, this.logger);
            reply.addHeader("session", id);
            reply.addHeader("version", this.version);
            reply.addHeader("heart-beat", "0,0");
            reply.addHeader("server", this.getServerName());
            String requestid = message.getHeader("receipt");
            if (requestid != null) {
                reply.addHeader("receipt-id", requestid);
            }
            out.sendToClient(reply, this, ctx);
        }
        catch (Exception e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                reply = this.toStompErrorMessage(message.getCommand().toString(), e);
                if (supportedVersions != null) {
                    reply.addHeader("version", supportedVersions);
                }
                out.sendToClient(reply, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
                return;
            }
        }
    }

    public void onDISCONNECT(StompFrameMessage message, StompOutputHandler out, Object ctx) {
        try {
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand(), null);
            }
            this.stompConnection.disconnect(true);
            StompFrameMessage reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
        }
        catch (Exception e) {
            if (e instanceof StompNotConnectedException) {
                this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), null);
                return;
            }
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                StompFrameMessage err = this.toStompErrorMessage(StompFrameMessage.Command.DISCONNECT.toString(), e);
                out.sendToClient(err, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
                return;
            }
        }
    }

    public void onSEND(StompFrameMessage message, StompOutputHandler out, Object ctx) {
        StompFrameMessage reply = null;
        try {
            String stompdest;
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            headers.putAll(message.getHeaders());
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", headers=" + headers, null);
            }
            if ((stompdest = (String)headers.get("destination")) == null) {
                throw new StompProtocolException("SEND without destination header!");
            }
            String tid = (String)headers.remove("transaction");
            this.stompConnection.sendMessage(message, tid);
            reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
        }
        catch (Throwable e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                reply = this.toStompErrorMessage(StompFrameMessage.Command.SEND.toString(), e);
                out.sendToClient(reply, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSUBSCRIBE(StompFrameMessage message, StompOutputHandler out, StompOutputHandler aout, Object ctx) throws Exception {
        StompFrameMessage reply = null;
        String subid = null;
        String duraname = null;
        boolean create = false;
        try {
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", headers=" + headers, null);
            }
            String tid = (String)((HashMap)headers).get("transaction");
            subid = (String)((HashMap)headers).get("id");
            String ack = (String)((HashMap)headers).get("ack");
            StompAckMode ackMode = StompAckMode.AUTO_ACK;
            if (ack != null) {
                if (ack.equals("client")) {
                    ackMode = StompAckMode.CLIENT_ACK;
                } else if (ack.equals("client-individual")) {
                    ackMode = StompAckMode.CLIENT_INDIVIDUAL_ACK;
                } else if (!ack.equals("auto")) {
                    throw new StompProtocolException("Invalid ack header value [" + ack + "]");
                }
            }
            String selector = (String)((HashMap)headers).get("selector");
            String stompdest = (String)((HashMap)headers).get("destination");
            if (stompdest == null) {
                throw new StompProtocolException("SUBSCRIBE without destination header!");
            }
            if (subid == null) {
                if (this.version.equals("1.0")) {
                    subid = StompProtocolHandler.makeDefaultSubscriberId(stompdest);
                } else {
                    throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("id", message.getCommand().toString()));
                }
            }
            if (this.subids.contains(subid)) {
                throw new StompProtocolException(this.getKStringX_SUBID_ALREADY_EXISTS(subid));
            }
            create = true;
            boolean nolocal = false;
            String val = (String)((HashMap)headers).get("no-local");
            if (val != null && val.equalsIgnoreCase("true")) {
                nolocal = true;
            }
            duraname = (String)((HashMap)headers).get("durable-subscriber-name");
            StompSubscriber sub = this.stompConnection.createSubscriber(subid, stompdest, ackMode, selector, duraname, nolocal, tid, aout);
            this.subids.add(subid);
            reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
            sub.startDelivery();
        }
        catch (Exception e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                if (create) {
                    this.stompConnection.closeSubscriber(subid, null);
                    this.subids.remove(subid);
                }
            }
            catch (Exception e1) {
                this.logger.logFinest(message.getCommand() + ": Unable to close subscriber (subid=" + subid + ", duraname=" + duraname + "): " + e1.getMessage() + " after creation failure: " + e.getMessage(), e1);
            }
            finally {
                try {
                    reply = this.toStompErrorMessage(StompFrameMessage.Command.SUBSCRIBE.toString(), e);
                    out.sendToClient(reply, this, ctx);
                }
                catch (Exception ee) {
                    this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
                }
            }
            return;
        }
    }

    public void onUNSUBSCRIBE(StompFrameMessage message, StompOutputHandler out, Object ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", headers=" + headers, null);
            }
            String subid = (String)((HashMap)headers).get("id");
            String stompdest = (String)((HashMap)headers).get("destination");
            String duraname = (String)((HashMap)headers).get("durable-subscriber-name");
            if (subid == null && !this.version.equals("1.0")) {
                throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("id", message.getCommand().toString()));
            }
            if (subid == null && duraname == null && this.version.equals("1.0")) {
                if (stompdest == null) {
                    throw new StompProtocolException(this.getKStringX_UNSUBSCRIBE_WITHOUT_HEADER("destination", "id"));
                }
                subid = StompProtocolHandler.makeDefaultSubscriberId(stompdest);
            }
            String id = this.stompConnection.closeSubscriber(subid, duraname);
            if (duraname == null) {
                this.subids.remove(subid);
            } else if (id != null) {
                this.subids.remove(id);
            }
            reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
        }
        catch (Exception e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                reply = this.toStompErrorMessage(StompFrameMessage.Command.UNSUBSCRIBE.toString(), e);
                out.sendToClient(reply, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onBEGIN(StompFrameMessage message, StompOutputHandler out, Object ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            String tid;
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", headers=" + headers, null);
            }
            if ((tid = (String)((HashMap)headers).get("transaction")) == null) {
                throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("transaction", StompFrameMessage.Command.BEGIN.toString()));
            }
            this.stompConnection.beginTransactedSession(tid);
            reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
        }
        catch (Exception e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                reply = this.toStompErrorMessage(StompFrameMessage.Command.BEGIN.toString(), e);
                out.sendToClient(reply, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onCOMMIT(StompFrameMessage message, StompOutputHandler out, Object ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            String tid;
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", headers=" + headers, null);
            }
            if ((tid = (String)((HashMap)headers).get("transaction")) == null) {
                throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("transaction", StompFrameMessage.Command.COMMIT.toString()));
            }
            this.stompConnection.commitTransactedSession(tid);
            reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
        }
        catch (Exception e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                reply = this.toStompErrorMessage(StompFrameMessage.Command.COMMIT.toString(), e);
                out.sendToClient(reply, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onABORT(StompFrameMessage message, StompOutputHandler out, Object ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            String tid;
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", headers=" + headers, null);
            }
            if ((tid = (String)((HashMap)headers).get("transaction")) == null) {
                throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("transaction", StompFrameMessage.Command.ABORT.toString()));
            }
            this.stompConnection.abortTransactedSession(tid);
            reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
        }
        catch (Exception e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                reply = this.toStompErrorMessage(StompFrameMessage.Command.ABORT.toString(), e);
                out.sendToClient(reply, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onNACK(StompFrameMessage message, StompOutputHandler out, Object ctx) throws Exception {
        this.doACK(message, out, ctx, true);
    }

    public void onACK(StompFrameMessage message, StompOutputHandler out, Object ctx) throws Exception {
        this.doACK(message, out, ctx, false);
    }

    public void doACK(StompFrameMessage message, StompOutputHandler out, Object ctx, boolean nack) throws Exception {
        StompFrameMessage reply = null;
        try {
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("on" + message.getCommand() + ", headers=" + headers, null);
            }
            if (nack && (this.version.equals("1.0") || this.version.equals("1.1"))) {
                throw new StompProtocolException(message.getKStringX_UNKNOWN_STOMP_CMD(StompFrameMessage.Command.NACK.toString()));
            }
            String msgid = (String)((HashMap)headers).get("message-id");
            if (msgid == null && (this.version.equals("1.0") || this.version.equals("1.1"))) {
                throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("message-id", StompFrameMessage.Command.ACK.toString()));
            }
            String subid = (String)((HashMap)headers).get("subscription");
            String subidPrefix = null;
            if (subid == null) {
                if (this.version.equals("1.1")) {
                    throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("subscription", StompFrameMessage.Command.ACK.toString()));
                }
                if (this.version.equals("1.0")) {
                    subidPrefix = DEFAULT_SUBID_PREFIX;
                }
            }
            if (subid != null && !this.subids.contains(subid)) {
                throw new StompProtocolException(this.getKStringX_SUBSCRIBER_ID_NOT_FOUND(subid));
            }
            String id = (String)((HashMap)headers).get("id");
            if (id == null) {
                if (!this.version.equals("1.0") && !this.version.equals("1.1")) {
                    throw new StompProtocolException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR("id", StompFrameMessage.Command.ACK.toString()));
                }
            } else {
                int ind = id.lastIndexOf("ID:");
                if (ind < 0) {
                    throw new StompProtocolException(this.getKStringX_INVALID_HEADER_VALUE("id", id));
                }
                String subidSave = subid;
                String msgidSave = msgid;
                msgid = id.substring(ind);
                subid = id.substring(0, ind);
                if (subidSave != null || msgidSave != null) {
                    this.logger.logWarn(this.getKStringI_USE_HEADER_IGNORE_OBSOLETE_HEADER_FOR("id=" + id, "subscription=" + subidSave + ",message-id=" + msgidSave, StompFrameMessage.Command.ACK.toString()), null);
                }
            }
            String tid = (String)((HashMap)headers).get("transaction");
            if (subidPrefix != null) {
                if (nack) {
                    throw new StompProtocolException(message.getKStringX_UNKNOWN_STOMP_CMD(StompFrameMessage.Command.NACK.toString()));
                }
                if (tid != null) {
                    this.logger.logWarn(this.getKStringW_NO_SUBID_TXNACK("subscription", tid, subidPrefix, msgid), null);
                } else {
                    this.logger.logWarn(this.getKStringW_NO_SUBID_NONTXNACK("subscription", subidPrefix, msgid), null);
                }
                this.stompConnection.ack10(subidPrefix, msgid, tid);
            } else {
                this.stompConnection.ack(id, tid, subid, msgid, nack);
            }
            reply = this.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, this, ctx);
            }
        }
        catch (Exception e) {
            this.logger.logSevere(this.getKStringE_COMMAND_FAILED(message.getCommand().toString(), e.getMessage(), this.stompConnection.toString()), e);
            try {
                reply = this.toStompErrorMessage(StompFrameMessage.Command.ACK.toString(), e, e instanceof StompUnrecoverableAckException);
                out.sendToClient(reply, this, ctx);
            }
            catch (Exception ee) {
                this.logger.logWarn(this.getKStringE_UNABLE_SEND_ERROR_MSG(e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    private StompFrameMessage getStompReceiptMessage(StompFrameMessage message) throws Exception {
        StompFrameMessage reply = null;
        String requestid = message.getHeader("receipt");
        if (requestid != null) {
            reply = this.getStompFrameMessageFactory().newStompFrameMessage(StompFrameMessage.Command.RECEIPT, this.logger);
            reply.addHeader("receipt-id", requestid);
        }
        return reply;
    }

    public StompFrameMessage toStompErrorMessage(String where, Throwable e) throws Exception {
        return this.toStompErrorMessage(where, e, false);
    }

    public StompFrameMessage toStompErrorMessage(String where, Throwable e, boolean fatal) throws Exception {
        StompFrameMessage err = this.getStompFrameMessageFactory().newStompFrameMessage(StompFrameMessage.Command.ERROR, this.logger);
        err.addHeader("message", where + ": " + (e == null ? "" : e.getMessage()) + (fatal ? ", STOMP connection will be closed" : ""));
        if (e != null) {
            err.writeExceptionToBody(e);
        }
        if (fatal) {
            err.setFatalERROR();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StompDestination getMQTempStompDestination(String stompdest, boolean isQueue) throws Exception {
        if (isQueue) {
            Map<String, StompDestination> map = this.mqtempQueues;
            synchronized (map) {
                StompDestination d = this.mqtempQueues.get(stompdest);
                if (d == null) {
                    throw new StompProtocolException("MQ TemporaryQueue not found: " + stompdest);
                }
                return d;
            }
        }
        Map<String, StompDestination> map = this.mqtempTopics;
        synchronized (map) {
            StompDestination d = this.mqtempTopics.get(stompdest);
            if (d == null) {
                throw new StompProtocolException("MQ TemporaryTopic not found: " + stompdest);
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StompDestination getTempStompDestination(String stompdest, boolean isQueue, StompSession ss) throws Exception {
        if (isQueue) {
            Map<String, StompDestination> map = this.tempQueues;
            synchronized (map) {
                StompDestination d = this.tempQueues.get(stompdest);
                if (d == null) {
                    d = ss.createTempStompDestination(true);
                    this.tempQueues.put(stompdest, d);
                }
                return d;
            }
        }
        Map<String, StompDestination> map = this.tempTopics;
        synchronized (map) {
            StompDestination d = this.tempTopics.get(stompdest);
            if (d == null) {
                d = ss.createTempStompDestination(false);
                this.tempTopics.put(stompdest, d);
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMQTempStompDestination(StompDestination d, boolean isQueue) throws Exception {
        if (isQueue) {
            Map<String, StompDestination> map = this.mqtempQueues;
            synchronized (map) {
                if (this.mqtempQueues.get(d.getName()) == null) {
                    this.mqtempQueues.put(d.getName(), d);
                }
            }
        }
        Map<String, StompDestination> map = this.mqtempTopics;
        synchronized (map) {
            if (this.mqtempTopics.get(d.getName()) == null) {
                this.mqtempTopics.put(d.getName(), d);
            }
        }
    }

    public StompDestination toStompDestination(String stompdest, StompSession ss, boolean sub) throws Exception {
        if (stompdest.startsWith("/queue/")) {
            String name = stompdest.substring("/queue/".length(), stompdest.length()).trim();
            return ss.createStompDestination(name, true);
        }
        if (stompdest.startsWith("/topic/")) {
            String name = stompdest.substring("/topic/".length(), stompdest.length()).trim();
            return ss.createStompDestination(name, false);
        }
        if (stompdest.startsWith("/temp-queue/")) {
            String name = stompdest.substring("/temp-queue/".length(), stompdest.length()).trim();
            if (name.startsWith(this.getTemporaryQueuePrefix())) {
                if (sub) {
                    throw new StompProtocolException("Can't subscribe " + stompdest);
                }
                return this.getMQTempStompDestination(name, true);
            }
            return this.getTempStompDestination(name, true, ss);
        }
        if (stompdest.startsWith("/temp-topic/")) {
            String name = stompdest.substring("/temp-topic/".length(), stompdest.length()).trim();
            if (name.startsWith(this.getTemporaryTopicPrefix())) {
                if (sub) {
                    throw new StompProtocolException("Can't subscribe " + stompdest);
                }
                return this.getMQTempStompDestination(name, false);
            }
            return this.getTempStompDestination(name, false, ss);
        }
        throw new StompProtocolException("Invalid header destination value:" + stompdest);
    }

    public String toStompFrameDestination(StompDestination destination, boolean cache) throws Exception {
        if (destination == null) {
            throw new StompProtocolException("StompDestination is null !");
        }
        StringBuilder buf = new StringBuilder();
        if (destination.isTemporary()) {
            if (destination.isQueue()) {
                String d = destination.getName();
                buf.append("/temp-queue/").append(d);
                if (cache) {
                    this.cacheMQTempStompDestination(destination, true);
                }
                return buf.toString();
            }
            String d = destination.getName();
            buf.append("/temp-topic/").append(d);
            if (cache) {
                this.cacheMQTempStompDestination(destination, false);
            }
            return buf.toString();
        }
        if (destination.isQueue()) {
            buf.append("/queue/").append(destination.getName());
            return buf.toString();
        }
        buf.append("/topic/").append(destination.getName());
        return buf.toString();
    }

    private static String makeDefaultSubscriberId(String stompdest) {
        return DEFAULT_SUBID_PREFIX + stompdest;
    }

    public void fromStompFrameMessage(StompFrameMessage message, StompMessage msg) throws Exception {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.putAll(message.getHeaders());
        if (message.getContentLength() != -1) {
            headers.remove("content-length");
            msg.setBytes(message);
        } else {
            msg.setText(message);
        }
        String stompdest = (String)headers.remove("destination");
        msg.setDestination(stompdest);
        String v = (String)headers.remove("priority");
        if (v != null) {
            msg.setJMSPriority(v);
        }
        if ((v = (String)headers.remove("persistent")) != null) {
            msg.setPersistent(v);
        }
        if ((v = (String)headers.remove("expires")) != null) {
            msg.setJMSExpiration(v);
        }
        if ((v = (String)headers.remove("correlation-id")) != null) {
            msg.setJMSCorrelationID(v);
        }
        if ((v = (String)headers.remove("type")) != null) {
            msg.setJMSType(v);
        }
        if ((v = (String)headers.remove("reply-to")) != null) {
            msg.setReplyTo(v);
        }
        v = (String)headers.remove("receipt");
        String k = null;
        String h = null;
        Iterator itr = headers.entrySet().iterator();
        Map.Entry e = null;
        while (itr.hasNext()) {
            e = itr.next();
            k = (String)e.getKey();
            v = (String)e.getValue();
            h = k + ":" + v;
            if (this.logger.isFineLoggable()) {
                this.logger.logFine("Setting header " + h + " as JMS message property", null);
            }
            msg.setProperty(k, v);
            itr.remove();
        }
    }

    public StompFrameMessage toStompFrameMessage(StompMessage msg, boolean needAck) throws Exception {
        String val;
        String replyto;
        StompFrameMessage message = this.getStompFrameMessageFactory().newStompFrameMessage(StompFrameMessage.Command.MESSAGE, this.logger);
        LinkedHashMap<String, String> headers = message.getHeaders();
        String subid = msg.getSubscriptionID();
        headers.put("subscription", subid);
        headers.put("destination", msg.getDestination());
        String msgid = msg.getJMSMessageID();
        headers.put("message-id", msgid);
        if (needAck) {
            headers.put("ack", subid + msgid);
        }
        if ((replyto = msg.getReplyTo()) != null) {
            headers.put("reply-to", replyto);
        }
        if ((val = msg.getJMSCorrelationID()) != null) {
            headers.put("correlation-id", val);
        }
        headers.put("expires", String.valueOf(msg.getJMSExpiration()));
        headers.put("redelivered", String.valueOf(msg.getJMSRedelivered()));
        headers.put("priority", String.valueOf(msg.getJMSPriority()));
        headers.put("timestamp", String.valueOf(msg.getJMSTimestamp()));
        val = msg.getJMSType();
        if (val != null) {
            headers.put("type", val);
        }
        Enumeration en = msg.getPropertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = msg.getProperty(name);
            headers.put(name, value);
        }
        if (msg.isTextMessage()) {
            String text = msg.getText();
            if (text != null) {
                byte[] data = text.getBytes("UTF-8");
                message.setBody(data);
                headers.put("content-length", String.valueOf(data.length));
            } else {
                headers.put("content-length", String.valueOf(0));
            }
            message.setTextMessageFlag();
        } else if (msg.isBytesMessage()) {
            byte[] data = msg.getBytes();
            message.setBody(data);
            headers.put("content-length", String.valueOf(data.length));
        } else {
            throw new StompProtocolException("Message type is not supported: " + msg);
        }
        return message;
    }

    public void checkValidMessagePropertyName(String name) throws StompProtocolException {
        if (name == null || "".equals(name) || "NULL".equalsIgnoreCase(name) || "TRUE".equalsIgnoreCase(name) || "FALSE".equalsIgnoreCase(name) || "NOT".equalsIgnoreCase(name) || "AND".equalsIgnoreCase(name) || "OR".equalsIgnoreCase(name) || "BETWEEN".equalsIgnoreCase(name) || "LIKE".equalsIgnoreCase(name) || "IN".equalsIgnoreCase(name) || "IS".equalsIgnoreCase(name)) {
            throw new StompProtocolException(this.getKStringX_INVALID_MESSAGE_PROP_NAME(name));
        }
        char[] namechars = name.toCharArray();
        if (Character.isJavaIdentifierStart(namechars[0])) {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i])) continue;
                throw new StompProtocolException(this.getKStringX_INVALID_MESSAGE_PROP_NAME(name));
            }
        } else {
            throw new StompProtocolException(this.getKStringX_INVALID_MESSAGE_PROP_NAME(name));
        }
    }

    protected abstract String getKStringI_CLOSE_STOMP_CONN(String var1);

    protected abstract String getKStringW_CLOSE_STOMP_CONN_FAILED(String var1, String var2);

    protected abstract String getKStringE_COMMAND_FAILED(String var1, String var2, String var3);

    protected abstract String getKStringE_UNABLE_SEND_ERROR_MSG(String var1, String var2);

    protected abstract String getKStringX_SUBID_ALREADY_EXISTS(String var1);

    protected abstract String getKStringX_UNSUBSCRIBE_WITHOUT_HEADER(String var1, String var2);

    protected abstract String getKStringX_HEADER_NOT_SPECIFIED_FOR(String var1, String var2);

    protected abstract String getKStringX_SUBSCRIBER_ID_NOT_FOUND(String var1);

    protected abstract String getKStringW_NO_SUBID_TXNACK(String var1, String var2, String var3, String var4);

    protected abstract String getKStringW_NO_SUBID_NONTXNACK(String var1, String var2, String var3);

    protected abstract String getKStringX_INVALID_MESSAGE_PROP_NAME(String var1);

    protected abstract String getKStringX_INVALID_HEADER_VALUE(String var1, String var2);

    protected abstract String getKStringI_USE_HEADER_IGNORE_OBSOLETE_HEADER_FOR(String var1, String var2, String var3);

    public static enum StompAckMode {
        AUTO_ACK,
        CLIENT_ACK,
        CLIENT_INDIVIDUAL_ACK;

    }
}

