/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.net.IPAddress;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Hashtable;

public abstract class IMQBasicConnection
extends IMQConnection {
    String remoteConString = null;
    String remoteHostString = null;
    PacketRouter router = null;
    protected int[] pktsOut = new int[80];
    protected int[] pktsIn = new int[80];
    protected static final int NO_VERSION = 0;
    public static final int CURVERSION = 301;
    public static final String CLIENT_ID = "client id";
    public static final String TRANSACTION_LIST = "transaction";
    public static final String TRANSACTION_IDMAP = "tidmap";
    public static final String TRANSACTION_CACHE = "txncache";
    public static final String USER_AGENT = "useragent";
    protected static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.packet.debug.info");
    static boolean DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.all");
    static boolean OUT_DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.out");
    static boolean IN_DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.in");
    static final byte[] ipAddress;
    public boolean METRICS_ON = MetricManager.isEnabled();
    String localsvcstring = null;

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public static boolean getDumpPacket() {
        return DUMP_PACKET;
    }

    public static boolean getDumpInPacket() {
        return IN_DUMP_PACKET;
    }

    public static boolean getDumpOutPacket() {
        return OUT_DUMP_PACKET;
    }

    public static void dumpPacket(boolean on) {
        DUMP_PACKET = on;
    }

    public static void dumpInPacket(boolean on) {
        IN_DUMP_PACKET = on;
    }

    public static void dumpOutPacket(boolean on) {
        OUT_DUMP_PACKET = on;
    }

    public IMQBasicConnection(Service svc, PacketRouter router) throws BrokerException {
        super(svc);
        this.router = router;
    }

    public void setPacketRouter(PacketRouter r) {
        this.router = r;
    }

    @Override
    public boolean setConnectionState(int state) {
        this.state = state;
        return true;
    }

    public void countInPacket(Packet pkt) {
        if (pkt == null) {
            return;
        }
        if (pkt.getPacketType() <= 6 && pkt.getPacketType() >= 1) {
            this.counters.updateIn(1L, pkt.getPacketSize(), 1L, pkt.getPacketSize());
        } else {
            this.counters.updateIn(0L, 0L, 1L, pkt.getPacketSize());
        }
    }

    public void countOutPacket(Packet pkt) {
        if (pkt == null) {
            return;
        }
        if (pkt.getPacketType() <= 6 && pkt.getPacketType() >= 1) {
            this.counters.updateOut(1L, pkt.getPacketSize(), 1L, pkt.getPacketSize());
        } else {
            this.counters.updateOut(0L, 0L, 1L, pkt.getPacketSize());
        }
    }

    public void flushControl(long timeout) {
    }

    public int getLocalPort() {
        return 0;
    }

    public void waitForRelease(long time) {
    }

    @Override
    protected void sayGoodbye(int reason, String reasonstr) {
        this.sayGoodbye(false, reason, reasonstr);
    }

    protected void sayGoodbye(boolean force, int reason, String reasonStr) {
        Packet goodbye_pkt = new Packet(this.useDirectBuffers());
        goodbye_pkt.setPacketType(28);
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("JMQExit", force);
        hash.put("JMQGoodbyeReason", reason);
        hash.put("JMQGoodbyeReasonString", reasonStr);
        goodbye_pkt.setProperties(hash);
        this.sendControlMessage(goodbye_pkt);
    }

    @Override
    protected void sendConsumerInfo(int requestType, String destName, int destType, int infoType) {
        if (this.state >= 6) {
            return;
        }
        Packet info_pkt = new Packet(this.useDirectBuffers());
        info_pkt.setPacketType(73);
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("JMQRequestType", requestType);
        props.put("JMQStatus", 200);
        info_pkt.setProperties(props);
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("JMQDestination", destName);
        hash.put("JMQDestType", destType);
        hash.put("JMQConsumerInfoType", infoType);
        DestinationUID duid = null;
        try {
            duid = DestinationUID.getUID(destName, destType);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(hash);
            oos.flush();
            bos.flush();
            info_pkt.setMessageBody(bos.toByteArray());
            bos.close();
        }
        catch (Throwable t) {
            this.logger.log(16, "XXXI18N Error: Unable to send consumer info to client: " + duid, t);
            return;
        }
        this.sendControlMessage(info_pkt);
    }

    @Override
    public String toString() {
        return "IMQConn[" + this.getConnectionUID() + ", " + IMQBasicConnection.getConnectionStateString(this.state) + ", " + this.getRemoteConnectionString() + ", " + this.localsvcstring + "]";
    }

    @Override
    public String toDebugString() {
        return super.toString() + " state: " + this.state;
    }

    @Override
    public String remoteHostString() {
        if (this.remoteHostString == null) {
            try {
                InetAddress inetaddr = InetAddress.getByAddress(this.getRemoteIP());
                this.remoteHostString = inetaddr.getHostName();
            }
            catch (Exception e) {
                this.remoteHostString = IPAddress.rawIPToString(this.getRemoteIP(), true, true);
            }
        }
        return this.remoteHostString;
    }

    @Override
    public String getRemoteConnectionString() {
        String userString;
        boolean userset;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            userset = false;
            userString = "???";
            if (this.state >= 4) {
                try {
                    Principal principal = this.getAuthenticatedName();
                    if (principal != null) {
                        userString = principal.getName();
                        userset = true;
                    }
                }
                catch (BrokerException e) {
                    if (!DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + this.conId, e);
                }
            }
        }
        String retstr = userString + "@Direct2:" + this.getConnectionUID();
        if (userset) {
            this.remoteConString = retstr;
        }
        return retstr;
    }

    @Override
    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        this.localsvcstring = this.service.getName();
        return this.localsvcstring;
    }

    static {
        byte[] addr = null;
        try {
            addr = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception ex) {
            Globals.getLogger().log(8, "Internal Error, could not  retrieve localhost address ");
            addr = new byte[]{};
        }
        ipAddress = addr;
    }
}

